/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.common.config;

import java.io.File;
import java.util.ArrayList;
import net.crazysnailboy.mods.villagerinventory.VillagerInventoryMod;
import net.crazysnailboy.mods.villagerinventory.client.config.ModGuiConfigEntries;
import net.crazysnailboy.mods.villagerinventory.common.network.message.ConfigSyncMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModConfiguration {
    private static Configuration config = null;
    public static boolean enableInventoryGui = true;
    public static boolean enableDeathDrops = true;
    public static boolean requireEmptyHand = false;

    public static void initializeConfiguration() {
        File configFile = new File(Loader.instance().getConfigDir(), "villagerinventory.cfg");
        config = new Configuration(configFile);
        config.load();
        ModConfiguration.syncConfig(true, true);
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            config.load();
        }
        Property propEnableInventoryGUI = config.get("general", "enableInventoryGui", true, "");
        propEnableInventoryGUI.setLanguageKey("villagerinventory.options.enableInventoryGui");
        propEnableInventoryGUI.setRequiresMcRestart(false);
        Property propRequireEmptyHand = config.get("general", "requireEmptyHand", false, "");
        propRequireEmptyHand.setLanguageKey("villagerinventory.options.requireEmptyHand");
        propRequireEmptyHand.setRequiresMcRestart(false);
        Property propEnableDeathDrops = config.get("general", "enableDeathDrops", true, "");
        propEnableDeathDrops.setLanguageKey("villagerinventory.options.enableDeathDrops");
        propEnableDeathDrops.setRequiresMcRestart(false);
        try {
            propEnableInventoryGUI.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            propRequireEmptyHand.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            propEnableDeathDrops.setConfigEntryClass(ModGuiConfigEntries.BooleanEntry.class);
            ArrayList<String> propOrderGeneral = new ArrayList<String>();
            propOrderGeneral.add(propEnableInventoryGUI.getName());
            propOrderGeneral.add(propRequireEmptyHand.getName());
            propOrderGeneral.add(propEnableDeathDrops.getName());
            config.setCategoryPropertyOrder("general", propOrderGeneral);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (readFieldsFromConfig) {
            enableInventoryGui = propEnableInventoryGUI.getBoolean();
            requireEmptyHand = propRequireEmptyHand.getBoolean();
            enableDeathDrops = propEnableDeathDrops.getBoolean();
        }
        propEnableInventoryGUI.set(enableInventoryGui);
        propRequireEmptyHand.set(requireEmptyHand);
        propEnableDeathDrops.set(enableDeathDrops);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventBusSubscriber
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.player.field_70170_p.field_72995_K) {
                VillagerInventoryMod.NETWORK.sendTo((IMessage)new ConfigSyncMessage(), (EntityPlayerMP)event.player);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("villagerinventory") && (!event.isWorldRunning() || Minecraft.func_71410_x().func_71356_B())) {
                ModConfiguration.syncConfig(false, true);
                if (event.isWorldRunning() && Minecraft.func_71410_x().func_71356_B()) {
                    VillagerInventoryMod.NETWORK.sendToServer((IMessage)new ConfigSyncMessage());
                }
            }
        }
    }

    private static class DefaultValues {
        private static final boolean enableInventoryGui = true;
        private static final boolean enableDeathDrops = true;
        private static final boolean requireEmptyHand = false;

        private DefaultValues() {
        }
    }
}

