/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.common.network.message;

import io.netty.buffer.ByteBuf;
import net.crazysnailboy.mods.villagerinventory.common.config.ModConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ConfigSyncMessage
implements IMessage {
    private boolean enableInventoryGui = ModConfiguration.enableInventoryGui;
    private boolean enableDeathDrops = ModConfiguration.enableDeathDrops;
    private boolean requireEmptyHand = ModConfiguration.requireEmptyHand;

    public void fromBytes(ByteBuf buf) {
        this.enableInventoryGui = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
        this.enableDeathDrops = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
        this.requireEmptyHand = ByteBufUtils.readVarShort((ByteBuf)buf) == 1;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.enableInventoryGui ? 1 : 0));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.enableDeathDrops ? 1 : 0));
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.requireEmptyHand ? 1 : 0));
    }

    public static final class MessageHandler
    implements IMessageHandler<ConfigSyncMessage, IMessage> {
        private IThreadListener getThreadListener(MessageContext ctx) {
            switch (ctx.side) {
                case SERVER: {
                    return (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                }
                case CLIENT: {
                    return Minecraft.func_71410_x();
                }
            }
            return null;
        }

        public IMessage onMessage(final ConfigSyncMessage message, MessageContext ctx) {
            IThreadListener threadListener = this.getThreadListener(ctx);
            threadListener.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ModConfiguration.enableInventoryGui = message.enableInventoryGui;
                    ModConfiguration.enableDeathDrops = message.enableDeathDrops;
                    ModConfiguration.requireEmptyHand = message.requireEmptyHand;
                }
            });
            return null;
        }
    }
}

