/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.common.network.message;

import io.netty.buffer.ByteBuf;
import net.crazysnailboy.mods.villagerinventory.util.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EntityFlagMessage
implements IMessage {
    private int entityId;
    private int flag;
    private boolean value;

    public EntityFlagMessage() {
    }

    public EntityFlagMessage(Entity entity, int flag, boolean value) {
        this.entityId = entity.func_145782_y();
        this.flag = flag;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.flag = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.value = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.flag, (int)4);
        buf.writeBoolean(this.value);
    }

    public static final class MessageHandler
    implements IMessageHandler<EntityFlagMessage, IMessage> {
        public IMessage onMessage(final EntityFlagMessage message, MessageContext context) {
            final WorldServer world = (WorldServer)context.getServerHandler().field_147369_b.field_70170_p;
            world.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityUtils.setFlag(world.func_73045_a(message.entityId), message.flag, message.value);
                }
            });
            return null;
        }
    }
}

