/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.common.network.message;

import io.netty.buffer.ByteBuf;
import net.crazysnailboy.mods.villagerinventory.client.gui.inventory.GuiVillagerInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VillagerCareerMessage
implements IMessage {
    private int entityId;
    private int careerId;

    public VillagerCareerMessage() {
    }

    public VillagerCareerMessage(int entityId, int careerId) {
        this.entityId = entityId;
        this.careerId = careerId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarShort((ByteBuf)buf);
        this.careerId = ByteBufUtils.readVarShort((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.entityId);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.careerId);
    }

    public static final class MessageHandler
    implements IMessageHandler<VillagerCareerMessage, IMessage> {
        public IMessage onMessage(final VillagerCareerMessage message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            final WorldClient world = minecraft.field_71441_e;
            minecraft.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Entity entity = world.func_73045_a(message.entityId);
                    if (entity instanceof EntityVillager) {
                        EntityVillager villager = (EntityVillager)entity;
                        NBTTagCompound compound = new NBTTagCompound();
                        villager.func_70014_b(compound);
                        compound.func_74768_a("Career", message.careerId);
                        villager.func_70037_a(compound);
                        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
                        if (currentScreen != null && currentScreen instanceof GuiVillagerInventory) {
                            ((GuiVillagerInventory)currentScreen).readVillagerFromNBT(compound);
                        }
                    }
                }
            });
            return null;
        }
    }
}

