/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagerinventory.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ReflectionHelper {
    public static final Class<?> getClass(String ... classNames) {
        Exception failed = null;
        for (String className : classNames) {
            try {
                return Class.forName(className);
            }
            catch (Exception ex) {
                failed = ex;
            }
        }
        throw new ReflectionHelper.UnableToFindClassException(classNames, failed);
    }

    public static final Field getDeclaredField(Class<?> declaringClass, String ... fieldNames) {
        return net.minecraftforge.fml.relauncher.ReflectionHelper.findField(declaringClass, (String[])fieldNames);
    }

    public static final Field getDeclaredField(String className, String ... fieldNames) {
        return net.minecraftforge.fml.relauncher.ReflectionHelper.findField(ReflectionHelper.getClass(className), (String[])fieldNames);
    }

    public static final <T> T[] getDeclaredFields(Class<T> type, Class<?> declaringClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Field field : declaringClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!field.getType().isAssignableFrom(type) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                result.add(field.get(null));
            }
            catch (Exception ex) {
                throw new UnableToAccessFieldException(new String[0], ex);
            }
        }
        return result.toArray((Object[])Array.newInstance(type, result.size()));
    }

    public static final Type getGenericInterfaceType(Class<?> declaringClass, Class<?> interfaceClass) {
        for (Type type : declaringClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != interfaceClass) continue;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static final Method getDeclaredMethod(Class<?> declaringClass, String[] methodNames, Class<?> ... parameterTypes) {
        Exception failed = null;
        for (String methodName : methodNames) {
            try {
                Method method = declaringClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (Exception ex) {
                failed = ex;
            }
        }
        throw new ReflectionHelper.UnableToFindMethodException(methodNames, failed);
    }

    public static final Method getDeclaredMethod(String className, String[] methodNames, Class<?> ... parameterTypes) {
        return ReflectionHelper.getDeclaredMethod(ReflectionHelper.getClass(className), methodNames, parameterTypes);
    }

    public static final <T, E> T getFieldValue(Field fieldToAccess, E instance) {
        try {
            return (T)fieldToAccess.get(instance);
        }
        catch (Exception ex) {
            throw new UnableToAccessFieldException(fieldToAccess, ex);
        }
    }

    public static final <T, E> void setFieldValue(Field fieldToAccess, E instance, T value) {
        try {
            fieldToAccess.set(instance, value);
        }
        catch (Exception ex) {
            throw new UnableToAccessFieldException(fieldToAccess, ex);
        }
    }

    public static final <T, E> T invokeMethod(Method methodToAccess, E instance, Object ... args) {
        try {
            if (methodToAccess.getReturnType().equals(Void.TYPE)) {
                methodToAccess.invoke(instance, args);
                return null;
            }
            return (T)methodToAccess.invoke(instance, args);
        }
        catch (Exception ex) {
            throw new UnableToInvokeMethodException(methodToAccess, ex);
        }
    }

    public static final <T, E> T invokeMethod(Method methodToAccess, E instance) {
        return ReflectionHelper.invokeMethod(methodToAccess, instance, null);
    }

    public static class UnableToAccessFieldException
    extends ReflectionHelper.UnableToAccessFieldException {
        public UnableToAccessFieldException(String[] fieldNames, Exception ex) {
            super(fieldNames, ex);
        }

        public UnableToAccessFieldException(Field field, Exception ex) {
            this(new String[]{field.getName()}, ex);
        }
    }

    public static class UnableToInvokeMethodException
    extends RuntimeException {
        public UnableToInvokeMethodException(Method method, Exception ex) {
            super(ex);
        }
    }
}

