/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import team.chisel.client.render.ModelChiselBlock;
import team.chisel.common.util.json.JsonHelper;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.IChiselFace;
import team.chisel.ctm.client.model.parsing.ModelLoaderCTM;

@Deprecated
public class ModelChisel
implements IModelCTM {
    private Variant model;
    private Map<String, Variant> models = Maps.newHashMap();
    private String face;
    private Map<EnumFacing, String> overrides = Maps.newHashMap();
    private boolean ignoreStates;
    private boolean ambientOcclusion = true;
    private transient IChiselFace faceObj;
    private transient Map<EnumFacing, IChiselFace> overridesObj = new EnumMap<EnumFacing, IChiselFace>(EnumFacing.class);
    private transient List<ResourceLocation> textures = Lists.newArrayList();
    private transient byte layers;
    private transient IModel vanillaparent;

    public Collection<ResourceLocation> getDependencies() {
        ArrayList list = Lists.newArrayList((Object[])new ResourceLocation[]{this.model.func_188046_a()});
        list.addAll(this.models.values().stream().map(v -> v.func_188046_a()).collect(Collectors.toList()));
        return list;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        JsonElement ao;
        Function dummyGetter = t -> Minecraft.func_71410_x().func_147117_R().func_110572_b(TextureMap.field_174945_f.toString());
        IBakedModel parent = this.bake(this.model, format, (Function<ResourceLocation, TextureAtlasSprite>)dummyGetter);
        this.layers = 0;
        for (ICTMTexture tex : this.getChiselTextures()) {
            BlockRenderLayer layer = tex.getLayer();
            if (layer == null) continue;
            this.layers = (byte)(this.layers | 1 << layer.ordinal());
        }
        JsonObject rawmodel = ModelLoaderCTM.INSTANCE.getJSON(this.model.func_188046_a()).getAsJsonObject();
        if (rawmodel.has("ambientocclusion") && (ao = rawmodel.get("ambientocclusion")).isJsonPrimitive() && ao.getAsJsonPrimitive().isBoolean()) {
            this.ambientOcclusion = ao.getAsBoolean();
        }
        return new ModelChiselBlock(this, parent);
    }

    private IBakedModel bake(Variant variant, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> getter) {
        return this.getVanillaParent().bake(variant.getState(), format, getter);
    }

    private void initVanillaParent() {
        this.vanillaparent = ModelLoaderRegistry.getModel((ResourceLocation)this.model.func_188046_a());
        this.vanillaparent = ModelProcessingHelper.uvlock((IModel)this.vanillaparent, (boolean)this.model.func_188049_c());
    }

    public void load() {
        if (this.faceObj != null) {
            return;
        }
        this.faceObj = JsonHelper.getOrCreateFace(new ResourceLocation(this.face));
        for (Map.Entry<EnumFacing, String> e : this.overrides.entrySet()) {
            this.overridesObj.put(e.getKey(), JsonHelper.getOrCreateFace(new ResourceLocation(e.getValue())));
        }
        this.faceObj.getTextureList().forEach(t -> this.textures.addAll(t.getTextures()));
        this.overridesObj.values().forEach(f -> f.getTextureList().forEach(t -> this.textures.addAll(t.getTextures())));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IChiselFace getDefaultFace() {
        return this.faceObj;
    }

    public List<ICTMTexture<?>> getChiselTextures() {
        ArrayList ret = Lists.newArrayList();
        ret.addAll(this.getDefaultFace().getTextureList());
        for (IChiselFace face : this.overridesObj.values()) {
            ret.addAll(face.getTextureList());
        }
        return ret;
    }

    public ICTMTexture<?> getTexture(String iconName) {
        return null;
    }

    public IChiselFace getFace(EnumFacing facing) {
        return this.overridesObj.getOrDefault(facing, this.faceObj);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return (this.layers >> layer.ordinal() & 1) == 1;
    }

    @Nullable
    public TextureAtlasSprite getOverrideSprite(int tintIndex) {
        return null;
    }

    @Nullable
    public ICTMTexture<?> getOverrideTexture(int tintIndex, String sprite) {
        return null;
    }

    public IModel getVanillaParent() {
        if (this.vanillaparent == null) {
            this.initVanillaParent();
        }
        return this.vanillaparent;
    }

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public boolean ambientOcclusion() {
        return this.ambientOcclusion;
    }
}

