/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.mpm.ModelData;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.ServerTickHandler;
import noppes.mpm.client.Camera;
import noppes.mpm.client.Client;
import noppes.mpm.client.ClientProxy;
import noppes.mpm.client.RenderEvent;
import noppes.mpm.client.fx.EntityEnderFX;
import noppes.mpm.client.fx.EntityRainbowFX;
import noppes.mpm.client.gui.GuiCreationScreenInterface;
import noppes.mpm.client.gui.GuiMPM;
import noppes.mpm.commands.MpmCommandInterface;
import noppes.mpm.constants.EnumAnimation;
import noppes.mpm.constants.EnumPackets;
import noppes.mpm.constants.EnumParts;
import noppes.mpm.util.MPMEntityUtil;
import org.lwjgl.input.Keyboard;

public class ClientEventHandler {
    private long lastAltClick = 0L;
    private boolean altIsPressed = false;
    private World prevWorld;
    private List<EntityPlayer> playerlist;
    private boolean slashPressed = false;
    public static Camera camera = new Camera();

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (ClientProxy.Screen.func_151468_f()) {
            ModelData data = ModelData.get((EntityPlayer)mc.field_71439_g);
            data.setAnimation(EnumAnimation.NONE);
            if (mc.field_71462_r == null) {
                mc.func_147108_a((GuiScreen)new GuiMPM());
            }
        }
        if (mc.field_71462_r == null) {
            boolean bl = this.slashPressed = Keyboard.getEventCharacter() == '/';
        }
        if (!mc.field_71415_G) {
            return;
        }
        if (ClientProxy.Sleep.func_151468_f()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button1);
        }
        if (ClientProxy.Sit.func_151468_f()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button2);
        }
        if (ClientProxy.Dance.func_151468_f()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button3);
        }
        if (ClientProxy.Hug.func_151468_f()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button4);
        }
        if (ClientProxy.Crawl.func_151468_f()) {
            ClientEventHandler.processAnimation(MorePlayerModels.button5);
        }
        if (ClientProxy.Camera.func_151470_d() && mc.field_71474_y.field_74320_O == 1) {
            long time = System.currentTimeMillis();
            if (!this.altIsPressed) {
                if (time - this.lastAltClick < 400L) {
                    camera.reset();
                } else {
                    camera.enabled();
                    this.lastAltClick = time;
                }
            }
            this.altIsPressed = true;
        } else {
            this.altIsPressed = false;
        }
    }

    @SubscribeEvent
    public void keyEvent(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (event.getGui() instanceof GuiChat) {
            if (!this.slashPressed && Keyboard.getEventCharacter() == '/') {
                this.slashPressed = true;
            }
        } else {
            this.slashPressed = false;
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        if (!(event.getCommand() instanceof MpmCommandInterface) || event.getSender().func_184102_h() != null || this.slashPressed) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onMouse(MouseEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(event.getDwheel() != 0 && mc.field_71415_G && mc.field_71474_y.field_74320_O == 1 && ClientEventHandler.camera.enabled && this.altIsPressed)) {
            return;
        }
        ClientEventHandler.camera.cameraDistance -= (float)event.getDwheel() / 100.0f;
        if (ClientEventHandler.camera.cameraDistance > 14.0f) {
            ClientEventHandler.camera.cameraDistance = 14.0f;
        } else if (ClientEventHandler.camera.cameraDistance < 1.0f) {
            ClientEventHandler.camera.cameraDistance = 1.0f;
        }
        event.setCanceled(true);
    }

    public static void processAnimation(int type) {
        if (type < 0) {
            return;
        }
        if (MorePlayerModels.HasServerSide) {
            Client.sendData(EnumPackets.ANIMATION, type);
        } else {
            ModelData data;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            EnumAnimation animation = EnumAnimation.values()[type];
            if (animation == EnumAnimation.SLEEPING_SOUTH) {
                float rotation;
                for (rotation = player.field_70177_z; rotation < 0.0f; rotation += 360.0f) {
                }
                while (rotation > 360.0f) {
                    rotation -= 360.0f;
                }
                int rotate = (int)((rotation + 45.0f) / 90.0f);
                if (rotate == 1) {
                    animation = EnumAnimation.SLEEPING_WEST;
                }
                if (rotate == 2) {
                    animation = EnumAnimation.SLEEPING_NORTH;
                }
                if (rotate == 3) {
                    animation = EnumAnimation.SLEEPING_EAST;
                }
            }
            if ((data = ModelData.get((EntityPlayer)player)).animationEquals(animation)) {
                animation = EnumAnimation.NONE;
            }
            data.setAnimation(animation.ordinal());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        camera.update(event.phase == TickEvent.Phase.START);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && this.prevWorld != mc.field_71441_e) {
            MorePlayerModels.HasServerSide = false;
            GuiCreationScreenInterface.Message = "message.noserver";
            ModelData data = ModelData.get((EntityPlayer)mc.field_71439_g);
            Client.sendData(EnumPackets.PING, MorePlayerModels.Version, data.writeToNBT());
            this.prevWorld = mc.field_71441_e;
            ClientProxy.FixModels(false);
        }
        ++RenderEvent.lastSkinTick;
    }

    @SubscribeEvent
    public void onCamera(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn() || mc.field_71474_y.field_74320_O != 1) {
            return;
        }
        float f = entity.func_70047_e();
        double partialTicks = event.getRenderPartialTicks();
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * partialTicks + (double)f;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;
        double d3 = ClientEventHandler.camera.cameraDistance - 4.0f;
        float f1 = entity.field_70177_z;
        float f2 = entity.field_70125_A;
        double d4 = (double)(-MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
        double d5 = (double)(MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f2 * ((float)Math.PI / 180)))) * d3;
        double d6 = (double)(-MathHelper.func_76126_a((float)(f2 * ((float)Math.PI / 180)))) * d3;
        for (int i = 0; i < 8; ++i) {
            double d7;
            RayTraceResult raytraceresult;
            float f3 = (i & 1) * 2 - 1;
            float f4 = (i >> 1 & 1) * 2 - 1;
            float f5 = (i >> 2 & 1) * 2 - 1;
            if ((raytraceresult = mc.field_71441_e.func_72933_a(new Vec3d(d0 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), new Vec3d(d0 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5))) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(d0, d1, d2))) < d3)) continue;
            d3 = d7;
        }
        GlStateManager.func_179114_b((float)(entity.field_70125_A - f2), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70177_z - f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-d3)));
        GlStateManager.func_179114_b((float)(f1 - entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f2 - entity.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        ModelData data = ModelData.get(player);
        EntityLivingBase entity = data.getEntity(player);
        Minecraft mc = Minecraft.func_71410_x();
        if (entity != null) {
            entity.func_70071_h_();
            MPMEntityUtil.Copy((EntityLivingBase)player, entity);
            return;
        }
        if (!MorePlayerModels.HasServerSide) {
            data.eyes.update(player);
        }
        if (data.inLove > 0) {
            --data.inLove;
            if (player.func_70681_au().nextBoolean()) {
                double d0 = player.func_70681_au().nextGaussian() * 0.02;
                double d1 = player.func_70681_au().nextGaussian() * 0.02;
                double d2 = player.func_70681_au().nextGaussian() * 0.02;
                player.field_70170_p.func_175688_a(EnumParticleTypes.HEART, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, player.field_70163_u + 0.5 + (double)(player.func_70681_au().nextFloat() * player.field_70131_O), player.field_70161_v + (double)(player.func_70681_au().nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        if (data.animation == EnumAnimation.CRY) {
            float f1 = player.field_70177_z * (float)Math.PI / 180.0f;
            float dx = -MathHelper.func_76126_a((float)f1);
            float dz = MathHelper.func_76134_b((float)f1);
            int i = 0;
            while ((float)i < 10.0f) {
                float f2 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dx * 0.15f;
                float f3 = (player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 0.5f + dz * 0.15f;
                player.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, player.field_70165_t + (double)f2, player.field_70163_u - (double)data.getBodyY() + (double)1.1f - player.func_70033_W(), player.field_70161_v + (double)f3, (double)1.0E-25f, 0.0, (double)1.0E-25f, new int[0]);
                ++i;
            }
        }
        if (data.animation != EnumAnimation.NONE) {
            ServerTickHandler.checkAnimation(player, data);
        }
        data.prevPosX = player.field_70165_t;
        data.prevPosY = player.field_70163_u;
        data.prevPosZ = player.field_70161_v;
        ModelPartData particles = data.getPartData(EnumParts.PARTICLES);
        if (particles != null) {
            this.spawnParticles(player, data, particles);
        }
    }

    private void spawnParticles(EntityPlayer player, ModelData data, ModelPartData particles) {
        block4: {
            Random rand;
            double height;
            Minecraft minecraft;
            block3: {
                if (!MorePlayerModels.EnableParticles) {
                    return;
                }
                minecraft = Minecraft.func_71410_x();
                height = player.func_70033_W() + (double)data.getBodyY();
                rand = player.func_70681_au();
                if (particles.type != 0) break block3;
                for (int i = 0; i < 2; ++i) {
                    EntityEnderFX fx = new EntityEnderFX((AbstractClientPlayer)player, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                    minecraft.field_71452_i.func_78873_a((Particle)fx);
                }
                break block4;
            }
            if (particles.type != 1) break block4;
            for (int i = 0; i < 2; ++i) {
                double x = player.field_70165_t + (rand.nextDouble() - 0.5) * 0.9;
                double y = player.field_70163_u + rand.nextDouble() * 1.9 - 0.25 - height;
                double z = player.field_70161_v + (rand.nextDouble() - 0.5) * 0.9;
                double f = (rand.nextDouble() - 0.5) * 2.0;
                double f1 = -rand.nextDouble();
                double f2 = (rand.nextDouble() - 0.5) * 2.0;
                minecraft.field_71452_i.func_78873_a((Particle)new EntityRainbowFX(player.field_70170_p, x, y, z, f, f1, f2));
            }
        }
    }
}

