/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable.entities;

import com.mojang.authlib.GameProfile;
import cyano.lootable.LootableBodies;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import org.apache.commons.lang3.ObjectUtils;

public class EntityLootableBody
extends EntityLiving
implements IInventory {
    public static final EntityEquipmentSlot[] EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET, EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND};
    static final byte VACUUM_TIMELIMIT = 20;
    static final int VACUUM_RADIUS = 3;
    private final ItemStack[] mainInventory = new ItemStack[42];
    private final Deque<ItemStack> auxInventory = new LinkedList<ItemStack>();
    private byte vacuumTime = 0;
    private long deathTimestamp;
    private long decayTimestamp;
    private final AtomicReference<GameProfile> gpSwap = new AtomicReference<Object>(null);
    private int terminate = -1;
    private static final int DEATH_COUNTDOWN = 10;
    private String oldName = null;

    public EntityLootableBody(World w) {
        super(w);
        this.decayTimestamp = this.deathTimestamp = w.func_82737_E();
        this.func_174805_g(LootableBodies.displayNameTag);
        this.func_70105_a(0.85f, 0.75f);
        this.field_70178_ae = LootableBodies.completelyInvulnerable || !LootableBodies.hurtByEnvironment;
    }

    public EntityLootableBody(EntityPlayer player) {
        this(player.func_130014_f_());
        this.func_70107_b(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
        this.field_70159_w = player.field_70159_w;
        this.field_70181_x = player.field_70181_x + 0.0784000015258789;
        this.field_70179_y = player.field_70179_y;
        this.func_70296_d();
    }

    private void log(String format, Object ... o) {
        FMLLog.info((String)"%s: %s", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), String.format(format, o)});
    }

    private void log(Object o) {
        FMLLog.info((String)"%s: %s", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), String.valueOf(o)});
    }

    public void func_70030_z() {
        long age;
        String nameUpdate;
        boolean isServer;
        super.func_70030_z();
        boolean isClient = this.func_130014_f_().field_72995_K;
        boolean bl = isServer = !isClient;
        if (isServer && this.terminate >= 0) {
            if (this.terminate == 10) {
                this.dropAllItems();
            }
            if (this.terminate > 0) {
                --this.terminate;
            }
            if (this.terminate == 0) {
                this.func_130014_f_().func_72900_e((Entity)this);
            }
            return;
        }
        if (isServer && this.terminate < 0 && (this.func_110143_aJ() <= 0.0f || this.field_70128_L)) {
            this.terminate = 10;
        }
        if (ObjectUtils.notEqual((Object)this.oldName, (Object)(nameUpdate = this.func_95999_t()))) {
            this.oldName = nameUpdate;
            if (nameUpdate != null && nameUpdate.trim().length() > 0) {
                GameProfile gp = new GameProfile(null, nameUpdate);
                if (!LootableBodies.useLocalSkin && isClient) {
                    gp = TileEntitySkull.func_174884_b((GameProfile)gp);
                }
                this.setGameProfile(gp);
                this.func_96094_a(nameUpdate);
            } else {
                this.setGameProfile(null);
                this.func_96094_a("");
            }
        }
        long currentTime = this.func_130014_f_().func_82737_E();
        if (isServer && LootableBodies.allowCorpseDecay) {
            if (LootableBodies.decayOnlyWhenEmpty && !this.isEmpty()) {
                this.deathTimestamp = currentTime;
            }
            if ((age = currentTime - this.deathTimestamp) > LootableBodies.corpseDecayTime) {
                this.func_70076_C();
            }
        }
        if (isServer && LootableBodies.ticksPerItemDecay > 0L && (age = currentTime - this.decayTimestamp) > LootableBodies.ticksPerItemDecay) {
            int decayAmount = (int)(age / LootableBodies.ticksPerItemDecay);
            this.decayTimestamp += (long)decayAmount * LootableBodies.ticksPerItemDecay;
            this.decayItems(decayAmount);
        }
        if (isServer && !this.auxInventory.isEmpty()) {
            for (int slot = this.func_70302_i_() - 1; slot >= EQUIPMENT_SLOTS.length; --slot) {
                if (this.func_70301_a(slot) != null) continue;
                this.func_70299_a(slot, this.auxInventory.pollFirst());
                this.func_70296_d();
                break;
            }
        }
        if (isServer && this.vacuumTime < 20) {
            this.vacuumTime = (byte)(this.vacuumTime + 1);
            List items = this.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_70165_t - 3.0, this.field_70163_u - 3.0, this.field_70161_v - 3.0, this.field_70165_t + 3.0, this.field_70163_u + 3.0, this.field_70161_v + 3.0));
            for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                this.addItem(stack);
            }
            for (EntityItem item : items) {
                this.func_130014_f_().func_72900_e((Entity)item);
            }
        }
    }

    private void decayItems(int amount) {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            this.func_70299_a(slot, this.decayItem(this.func_70301_a(slot), amount));
        }
        for (ItemStack item : this.auxInventory) {
            this.decayItem(item, amount);
        }
    }

    private ItemStack decayItem(ItemStack item, int amount) {
        int durabilityRemaining;
        if (item != null && item.field_77994_a == 1 && item.func_77984_f() && item.func_77973_b().func_77645_m() && (durabilityRemaining = item.func_77958_k() - item.func_77952_i() - 1) > 0) {
            item.func_77972_a(Math.min(durabilityRemaining, amount), (EntityLivingBase)this);
        }
        return item;
    }

    public void addItem(ItemStack stack) {
        for (int slot = EQUIPMENT_SLOTS.length; slot < this.func_70302_i_(); ++slot) {
            if ((stack = this.mergeItem(slot, stack)) != null) continue;
            return;
        }
        this.auxInventory.addLast(stack);
    }

    public void initializeItems(ItemStack[] inv) {
        System.arraycopy(inv, 0, this.mainInventory, 0, Math.min(inv.length, this.mainInventory.length));
        for (int i = this.mainInventory.length; i < inv.length; ++i) {
            this.auxInventory.addLast(inv[i]);
        }
    }

    public ItemStack mergeItem(int slot, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack current = this.func_70301_a(slot);
        int inventorySizeLimit = Math.min(stack.func_77976_d(), this.func_70297_j_());
        if (current == null) {
            this.func_70299_a(slot, stack);
            return null;
        }
        if (current.field_77994_a < inventorySizeLimit && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)current) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)current)) {
            int delta = Math.min(stack.field_77994_a, inventorySizeLimit - current.field_77994_a);
            current.field_77994_a += delta;
            stack.field_77994_a -= delta;
            this.func_70299_a(slot, current);
            if (stack.field_77994_a <= 0) {
                return null;
            }
            return stack;
        }
        return stack;
    }

    protected void func_70665_d(DamageSource src, float amount) {
        EntityPlayer player;
        ItemStack item;
        String type = String.valueOf(src == null ? null : src.func_76355_l());
        if (src instanceof EntityDamageSource && src.func_76346_g() instanceof EntityPlayer && (item = (player = (EntityPlayer)src.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND)) != null && (item.func_77973_b() instanceof ItemSpade || item.func_77973_b().getToolClasses(item).contains("shovel"))) {
            this.func_70076_C();
        }
        if (type.equals(DamageSource.field_76380_i.func_76355_l())) {
            super.func_70665_d(src, amount);
            return;
        }
        if (type.equals(DamageSource.field_76368_d.func_76355_l())) {
            this.jumpOutOfWall();
        }
        if (LootableBodies.completelyInvulnerable) {
            return;
        }
        if (src instanceof EntityDamageSource) {
            if (LootableBodies.hurtByAttacks) {
                super.func_70665_d(src, amount);
            }
            return;
        }
        if (EntityLootableBody.matchesAny(type, DamageSource.field_82728_o, DamageSource.field_76367_g, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_188406_j, DamageSource.field_76372_a, DamageSource.field_76371_c, DamageSource.field_76376_m, DamageSource.field_180137_b, DamageSource.field_76370_b)) {
            if (LootableBodies.hurtByEnvironment) {
                super.func_70665_d(src, amount);
            }
            return;
        }
        if (LootableBodies.hurtByMisc) {
            super.func_70665_d(src, amount);
            return;
        }
    }

    public GameProfile getGameProfile() {
        return this.gpSwap.get();
    }

    public void setGameProfile(GameProfile gp) {
        this.gpSwap.set(gp);
    }

    public void setUserName(String name) {
        this.func_96094_a(name);
    }

    private long getDeathTimestamp() {
        return this.deathTimestamp;
    }

    private void setDeathTimestamp(long timestamp) {
        this.deathTimestamp = timestamp;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)LootableBodies.corpseHP);
    }

    public float getRotation() {
        return this.field_70177_z;
    }

    public void setRotation(float newRot) {
        this.field_70177_z = newRot;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void jumpOutOfWall() {
        this.log("Escaping from wall at position %s", this.func_180425_c());
        BlockPos currentCoord = this.func_180425_c();
        double[] vector = new double[]{(double)currentCoord.func_177958_n() + 0.5 - this.field_70165_t, 0.0, (double)currentCoord.func_177952_p() + 0.5 - this.field_70161_v};
        double normalizer = 1.0 / Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] * normalizer;
        vector[1] = vector[1] * normalizer;
        vector[2] = vector[2] * normalizer;
        IBlockState bs = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + vector[0], this.field_70163_u + vector[1], this.field_70161_v + vector[2]));
        if (!bs.func_185904_a().func_76230_c()) {
            this.func_70107_b(this.field_70165_t + vector[0], this.field_70163_u + vector[1], this.field_70161_v + vector[2]);
            return;
        }
        BlockPos n = currentCoord.func_177984_a();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        n = currentCoord.func_177978_c();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        n = currentCoord.func_177974_f();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        n = currentCoord.func_177968_d();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        n = currentCoord.func_177976_e();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        n = currentCoord.func_177977_b();
        if (!this.field_70170_p.func_180495_p(n).func_185904_a().func_76230_c()) {
            this.func_70107_b((double)n.func_177958_n() + 0.5, (double)n.func_177956_o() + 0.015625, (double)n.func_177952_p() + 0.5);
            return;
        }
        vector[0] = this.field_70170_p.field_73012_v.nextDouble() * 2.0;
        vector[1] = this.field_70170_p.field_73012_v.nextDouble() * 2.0;
        vector[2] = this.field_70170_p.field_73012_v.nextDouble() * 2.0;
        this.func_70107_b(this.field_70165_t + vector[0], this.field_70163_u + vector[1], this.field_70161_v + vector[2]);
        this.log("jumped to %s", this.func_180425_c());
    }

    protected void func_70076_C() {
        if (this.terminate < 0) {
            this.terminate = 10;
        }
        this.func_70097_a(DamageSource.field_76380_i, this.func_110138_aP());
        this.func_70296_d();
    }

    public int func_70627_aG() {
        return 1200;
    }

    public void func_70642_aH() {
    }

    protected int func_70693_a(EntityPlayer p_getExperiencePoints_1_) {
        return 0;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public boolean func_98052_bS() {
        return false;
    }

    public void func_98053_h(boolean p_setCanPickUpLoot_1_) {
    }

    public boolean func_70648_aU() {
        return true;
    }

    public int func_70302_i_() {
        return EQUIPMENT_SLOTS.length + this.mainInventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index < EQUIPMENT_SLOTS.length) {
            return super.func_184582_a(EQUIPMENT_SLOTS[index]);
        }
        return this.mainInventory[index - EQUIPMENT_SLOTS.length];
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < EQUIPMENT_SLOTS.length) {
            super.func_184201_a(EQUIPMENT_SLOTS[index], stack);
        } else {
            this.mainInventory[index - EntityLootableBody.EQUIPMENT_SLOTS.length] = stack;
        }
    }

    public ItemStack func_70304_b(int index) {
        ItemStack i = this.func_70301_a(index);
        this.func_70299_a(index, null);
        return i;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack i = this.func_70301_a(index);
        ItemStack result = i.func_77979_a(count);
        if (i.field_77994_a <= 0) {
            i = null;
        }
        this.func_70299_a(index, i);
        return result;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack item) {
        if (player.func_180425_c().func_177951_i((Vec3i)this.func_180425_c()) < 25.0) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)LootableBodies.getInstance(), (int)0, (World)this.func_130014_f_(), (int)this.func_145782_y(), (int)0, (int)0);
            return true;
        }
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 4) {
            return stack.func_77973_b().isValidArmor(stack, EQUIPMENT_SLOTS[index], (Entity)this);
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < EQUIPMENT_SLOTS.length; ++i) {
            this.func_70299_a(i, null);
        }
        Arrays.fill(this.mainInventory, null);
        this.auxInventory.clear();
    }

    public boolean isEmpty() {
        if (!this.auxInventory.isEmpty()) {
            return false;
        }
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.func_70301_a(slot) == null) continue;
            return false;
        }
        return true;
    }

    private void dropAllItems() {
        for (EntityEquipmentSlot entityEquipmentSlot : EQUIPMENT_SLOTS) {
            ItemStack i = this.func_184582_a(entityEquipmentSlot);
            if (i == null) continue;
            this.func_130014_f_().func_72838_d((Entity)new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
        for (EntityEquipmentSlot entityEquipmentSlot : this.mainInventory) {
            if (entityEquipmentSlot == null) continue;
            this.func_130014_f_().func_72838_d((Entity)new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, (ItemStack)entityEquipmentSlot));
        }
        for (ItemStack i : this.auxInventory) {
            if (i == null) continue;
            this.func_130014_f_().func_72838_d((Entity)new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
        this.func_174888_l();
    }

    private static boolean matchesAny(String damageType, DamageSource ... list) {
        for (int i = 0; i < list.length; ++i) {
            if (damageType.hashCode() != list[i].hashCode()) continue;
            return true;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        NBTTagList equipmentListTag = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            item.func_77955_b(slotTag);
            equipmentListTag.func_74742_a((NBTBase)slotTag);
        }
        root.func_74782_a("Equipment", (NBTBase)equipmentListTag);
        if (!this.auxInventory.isEmpty()) {
            NBTTagList nbtauxtaglist = new NBTTagList();
            for (ItemStack i : this.auxInventory) {
                if (i == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                i.func_77955_b(nbttagcompound1);
                nbtauxtaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            root.func_74782_a("Aux", (NBTBase)nbtauxtaglist);
        }
        if (this.vacuumTime < 20) {
            root.func_74774_a("Vac", this.vacuumTime);
        }
        if (this.getGameProfile() != null) {
            root.func_74778_a("Name", this.getGameProfile().getName());
        }
        root.func_74772_a("DeathTime", this.getDeathTimestamp());
        root.func_74772_a("DecayTime", this.decayTimestamp);
    }

    public void func_70037_a(NBTTagCompound root) {
        int i;
        NBTTagList nbttaglist;
        super.func_70037_a(root);
        if (root.func_150297_b("Equipment", 9)) {
            nbttaglist = root.func_150295_c("Equipment", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound slotTag = nbttaglist.func_150305_b(i);
                byte slot = slotTag.func_74771_c("Slot");
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)slotTag);
                this.func_70299_a(slot, item);
            }
        }
        if (root.func_74764_b("Aux")) {
            nbttaglist = root.func_150295_c("Aux", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.auxInventory.addLast(ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
            }
        }
        this.vacuumTime = root.func_74764_b("Vac") ? root.func_74771_c("Vac") : (byte)20;
        if (root.func_74764_b("DeathTime")) {
            this.setDeathTimestamp(root.func_74763_f("DeathTime"));
        }
        if (root.func_74764_b("DecayTime")) {
            this.decayTimestamp = root.func_74763_f("DecayTime");
        }
        if (root.func_74764_b("Name")) {
            this.setUserName(root.func_74779_i("Name"));
        }
        this.func_70101_b(this.field_70177_z, 0.0f);
    }

    public boolean useThinArms() {
        GameProfile p = this.getGameProfile();
        if (p != null) {
            if (p.isLegacy()) {
                return false;
            }
            UUID uid = p.getId();
            if (uid != null) {
                return (uid.hashCode() & 1) == 1;
            }
        }
        return false;
    }
}

