/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.arrow;

import com.google.common.collect.Sets;
import de.Whitedraco.switchbow.entity.EntityArrowBase;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTippedArrow
extends EntityArrowBase
implements IThrowableEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityTippedArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potion = PotionTypes.field_185229_a;
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();
    private boolean field_191509_at;

    public EntityTippedArrow(World worldIn) {
        super(worldIn);
    }

    public EntityTippedArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityTippedArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_185167_i) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)stack);
            List collection = PotionUtils.func_185190_b((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (PotionEffect potioneffect : collection) {
                    this.customPotionEffects.add(new PotionEffect(potioneffect));
                }
            }
            if ((i = EntityTippedArrow.func_191508_b(stack)) == -1) {
                this.refreshColor();
            } else {
                this.func_191507_d(i);
            }
        } else if (stack.func_77973_b() == Items.field_151032_g) {
            this.potion = PotionTypes.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    public static int func_191508_b(ItemStack p_191508_0_) {
        NBTTagCompound nbttagcompound = p_191508_0_.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("CustomPotionColor", 99) ? nbttagcompound.func_74762_e("CustomPotionColor") : -1;
    }

    private void refreshColor() {
        this.field_191509_at = false;
        this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    public void addEffect(PotionEffect effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.customPotionEffects)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = PotionTypes.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    private void func_191507_d(int p_191507_1_) {
        this.field_191509_at = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)p_191507_1_);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.potion != PotionTypes.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)this.potion)).toString());
        }
        if (this.field_191509_at) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.customPotionEffects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("CustomPotionEffects", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((NBTTagCompound)compound);
        }
        for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
            this.addEffect(potioneffect);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.func_191507_d(compound.func_74762_e("Color"));
        } else {
            this.refreshColor();
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        for (PotionEffect potioneffect : this.potion.func_185170_a()) {
            living.func_70690_d(new PotionEffect(potioneffect.func_188419_a(), Math.max(potioneffect.func_76459_b() / 8, 1), potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect potioneffect1 : this.customPotionEffects) {
                living.func_70690_d(potioneffect1);
            }
        }
    }

    @Override
    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potion == PotionTypes.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (PotionType)this.potion);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        if (this.field_191509_at) {
            NBTTagCompound nbttagcompound = itemstack.func_77978_p();
            if (nbttagcompound == null) {
                nbttagcompound = new NBTTagCompound();
                itemstack.func_77982_d(nbttagcompound);
            }
            nbttagcompound.func_74768_a("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }
}

