/*
 * Decompiled with CFR 0.152.
 */
package de.Whitedraco.switchbow.entity.living;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLittleIronGolem
extends EntityGolem {
    protected static final DataParameter<Byte> PLAYER_CREATED = EntityDataManager.func_187226_a(EntityIronGolem.class, (DataSerializer)DataSerializers.field_187191_a);
    private int attackTimer;
    private int livingTime = 0;

    public EntityLittleIronGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.35f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving p_apply_1_) {
                return p_apply_1_ != null && IMob.field_175450_e.apply((Object)p_apply_1_);
            }
        }));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_CREATED, (Object)0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        ++this.livingTime;
        if (!this.field_70170_p.field_72995_K && (this.func_70638_az() == null || this.func_70638_az().field_70128_L || this.livingTime >= 200)) {
            this.func_70106_y();
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return this.isPlayerCreated() && EntityPlayer.class.isAssignableFrom(cls) ? false : (cls == EntityCreeper.class ? false : super.func_70686_a(cls));
    }

    public static void registerFixesIronGolem(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, (String)"VillagerGolem");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("PlayerCreated", this.isPlayerCreated());
        compound.func_74768_a("time", this.livingTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPlayerCreated(compound.func_74767_n("PlayerCreated"));
        this.livingTime = compound.func_74762_e("time");
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(1 + this.field_70146_Z.nextInt(4)));
        if (flag) {
            entityIn.field_70181_x += 0.2000000059604645;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean isPlayerCreated() {
        return ((Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED) & 1) != 0;
    }

    public void setPlayerCreated(boolean playerCreated) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED);
        if (playerCreated) {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }
}

