/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.SaveHandler;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings.item.LeaderRequiredItem;

public class EventListener {
    public static int upkeepTick = 0;
    public static int dayTick = 0;
    public static int saveTick = 0;

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Main.console("[TERRITORIAL DEALINGS] Player " + event.getPlayer().func_70005_c_() + " placed a block at pos x " + event.getPos().func_177958_n() + " y " + event.getPos().func_177956_o() + " z " + event.getPos().func_177952_p() + ".");
        Chunk chunk = event.getPlayer().field_70170_p.func_175726_f(event.getPos());
        if (TerritoryHandler.canPlayerEditChunk(event.getPlayer(), chunk)) {
            Main.console("[TERRITORIAL DEALINGS] Player is allowed to edit this chunk. Doing nothing.");
        } else {
            Main.console("[TERRITORIAL DEALINGS] Player is not allowed to edit this chunk. Cancelling.");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Main.console("[TERRITORIAL DEALINGS] Block at x " + event.getPos().func_177958_n() + " / y " + event.getPos().func_177956_o() + " / z " + event.getPos().func_177952_p() + " broken by player " + event.getPlayer().func_70005_c_() + ".");
        Chunk chunk = event.getPlayer().field_70170_p.func_175726_f(event.getPos());
        if (TerritoryHandler.canPlayerEditChunk(event.getPlayer(), chunk)) {
            Main.console("[TERRITORIAL DEALINGS] Player is allowed to edit this chunk. Doing nothing.");
        } else {
            Main.console("[TERRITORIAL DEALINGS] Player is not allowed to edit this chunk. Cancelling.");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBucketUse(FillBucketEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        if (pos == null) {
            return;
        }
        Main.console("[TERRITORIAL DEALINGS] Bucket used by player " + event.getEntityPlayer().func_70005_c_() + " at x " + pos.func_177958_n() + " / y " + pos.func_177956_o() + " / z " + pos.func_177952_p() + ".");
        Chunk chunk = event.getEntityPlayer().field_70170_p.func_175726_f(pos);
        if (TerritoryHandler.canPlayerEditChunk(event.getEntityPlayer(), chunk)) {
            Main.console("[TERRITORIAL DEALINGS] Player is allowed to edit this chunk. Doing nothing.");
        } else {
            Main.console("[TERRITORIAL DEALINGS] Player is not allowed to edit this chunk. Cancelling.");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (Main.isPlayerInteractionAllowed()) {
            return;
        }
        Main.console("[TERRITORIAL DEALINGS] Block at x " + event.getPos().func_177958_n() + " / y " + event.getPos().func_177956_o() + " / z " + event.getPos().func_177952_p() + " touched by player " + event.getEntityPlayer().func_70005_c_() + ".");
        Chunk chunk = event.getEntityPlayer().field_70170_p.func_175726_f(event.getPos());
        if (TerritoryHandler.canPlayerEditChunk(event.getEntityPlayer(), chunk)) {
            Main.console("[TERRITORIAL DEALINGS] Player is allowed to interact with this chunk. Doing nothing.");
        } else {
            Main.console("[TERRITORIAL DEALINGS] Player is not allowed to interact with this chunk. Cancelling.");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (Main.isPlayerInteractionAllowed()) {
            return;
        }
        Main.console("[TERRITORIAL DEALINGS] Block at x " + event.getPos().func_177958_n() + " / y " + event.getPos().func_177956_o() + " / z " + event.getPos().func_177952_p() + " hit by player " + event.getEntityPlayer().func_70005_c_() + ".");
        Chunk chunk = event.getEntityPlayer().field_70170_p.func_175726_f(event.getPos());
        if (TerritoryHandler.canPlayerEditChunk(event.getEntityPlayer(), chunk)) {
            Main.console("[TERRITORIAL DEALINGS] Player is allowed to interact with this chunk. Doing nothing.");
        } else {
            Main.console("[TERRITORIAL DEALINGS] Player is not allowed to interact with this chunk. Cancelling.");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.crafting.func_77973_b() instanceof LeaderRequiredItem && TerritoryHandler.getFactionPlayerIsLeaderOf(event.player) == null) {
            Main.console("Item is leader-only, but the player is not a leader. Removing the item.");
            event.crafting.field_77994_a = 0;
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == Side.CLIENT) {
            return;
        }
        if (++upkeepTick >= Main.getConsumeUpkeepTick()) {
            TerritoryHandler.consumeUpkeep(event.world);
            upkeepTick = 0;
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == Side.CLIENT) {
            return;
        }
        if (++dayTick >= Main.getControlRefreshTick()) {
            TerritoryHandler.refreshChunkControl();
            dayTick = 0;
        }
        if (++saveTick >= Main.getSaveTick()) {
            SaveHandler.saveFactionsToFile();
            saveTick = 0;
        }
    }
}

