/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;
import net.wwsf.domochevsky.territorialdealings.EventListener;
import net.wwsf.domochevsky.territorialdealings.SaveHandler;
import net.wwsf.domochevsky.territorialdealings.ValueTable;
import net.wwsf.domochevsky.territorialdealings.item.ClaimTerritoryOrder;
import net.wwsf.domochevsky.territorialdealings.item.FactionLedger;
import net.wwsf.domochevsky.territorialdealings.item.FactionOverviewCard;
import net.wwsf.domochevsky.territorialdealings.item.FactionRenameOrder;
import net.wwsf.domochevsky.territorialdealings.item.InheritanceDeed;
import net.wwsf.domochevsky.territorialdealings.item.PaymentOrder;
import net.wwsf.domochevsky.territorialdealings.item.PlayerIDCard;
import net.wwsf.domochevsky.territorialdealings.item.ReturnOrder;
import net.wwsf.domochevsky.territorialdealings.item.StartFactionDeed;
import net.wwsf.domochevsky.territorialdealings.item.TerritoryMap;
import net.wwsf.domochevsky.territorialdealings.net.PacketHandler;
import net.wwsf.domochevsky.territorialdealings.recipe.Recipe_LeaderRequired;
import net.wwsf.domochevsky.territorialdealings.recipe.Recipe_Payment;

@Mod(modid="territorychevsky", name="Territorial Dealings", version="b17", acceptedMinecraftVersions="[1.9,1.11)")
public class Main {
    private static boolean isDebugEnabled;
    private static boolean playerNeedsToBeOnline;
    private static int playerAmountForOnline;
    private static String worldFolder;
    private static File configDir;
    private static Item startDeed;
    private static Item claimOrder;
    private static Item playerIDCard;
    private static Item paymentOrder;
    private static Item renameOrder;
    private static Item infoCard;
    private static Item inheritanceDeed;
    private static Item factionLedger;
    private static Item returnOrder;
    private static Item territoryMap;
    private static int maxControlStrength;
    private static int controlStrengthRefresh;
    private static int controlRefreshTick;
    private static int consumeUpkeepTick;
    private static int saveTick;
    private static int upkeepMultiplier;
    private static int maxPaymentOrderAmount;
    private static boolean allowPlayerInteract;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        isDebugEnabled = config.get("generic", "Should I display a whole bunch of additional debug information on the server console? (default false)", false).getBoolean();
        saveTick = config.get("generic", "How often do I autosave, in addition to onServerStop? (default 24000 ticks, for once per ingame day.)", 24000).getInt();
        playerNeedsToBeOnline = config.get("generic", "Does someone from the target faction need to be online to start a hostile takeover? (default true)", true).getBoolean();
        playerAmountForOnline = config.get("generic", "How many members of the target faction need to be online for a hostile takeover? (Default 1% minimum)", 1).getInt();
        maxControlStrength = config.get("chunk control", "How long does it take to claim someone else's chunk? (default 90 sec)", 90).getInt();
        controlStrengthRefresh = config.get("chunk control", "How much lost chunk control strength gets restored every interval? (default +15 sec)", 15).getInt();
        controlRefreshTick = config.get("chunk control", "How long is each chunk control strength refresh interval? (default 24000 ticks, for once per ingame day.)", 24000).getInt();
        consumeUpkeepTick = config.get("chunk control", "How long is each upkeep consumption interval? (default 24000 ticks, for once per ingame day.)", 24000).getInt();
        upkeepMultiplier = config.get("chunk control", "How much upkeep does a chunk cost per upkeep consumption interval? (default 1 VALUABLE)", 1).getInt();
        maxPaymentOrderAmount = config.get("items", "How many valuables can the PAYMENT ORDER hold? (default 100 VALUABLES)", 100).getInt();
        ValueTable.setValueForDiamond(config.get("valuables", "How much value does a single diamond have? (default 2 VALUABLES)", 2).getInt());
        ValueTable.setValueForEmerald(config.get("valuables", "How much value does a single emerald have? (default 3 VALUABLES)", 3).getInt());
        ValueTable.setValueForGold(config.get("valuables", "How much value does a single gold ingot have? (default 1 VALUABLE)", 1).getInt());
        allowPlayerInteract = config.get("extra", "Are other players allowed to interact with chests/doors and such in protected chunks? (default false)", false).getBoolean();
        config.save();
        PacketHandler.initPackets();
        this.registerItems();
        if (event.getSide().isClient()) {
            this.loadModels();
        }
        configDir = event.getModConfigurationDirectory();
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
        RecipeSorter.register((String)"territorychevsky:recipehandler_payment", Recipe_Payment.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"territorychevsky:recipehandler_leader", Recipe_LeaderRequired.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        this.registerItemRecipes();
        this.registerPaymentRecipes();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        worldFolder = event.getServer().func_71270_I();
        SaveHandler.loadFactionsFromFile();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        SaveHandler.saveFactionsToFile();
    }

    private void registerItems() {
        startDeed = new StartFactionDeed();
        GameRegistry.register((IForgeRegistryEntry)startDeed);
        claimOrder = new ClaimTerritoryOrder();
        GameRegistry.register((IForgeRegistryEntry)claimOrder);
        paymentOrder = new PaymentOrder();
        GameRegistry.register((IForgeRegistryEntry)paymentOrder);
        renameOrder = new FactionRenameOrder();
        GameRegistry.register((IForgeRegistryEntry)renameOrder);
        playerIDCard = new PlayerIDCard();
        GameRegistry.register((IForgeRegistryEntry)playerIDCard);
        infoCard = new FactionOverviewCard();
        GameRegistry.register((IForgeRegistryEntry)infoCard);
        inheritanceDeed = new InheritanceDeed();
        GameRegistry.register((IForgeRegistryEntry)inheritanceDeed);
        factionLedger = new FactionLedger();
        GameRegistry.register((IForgeRegistryEntry)factionLedger);
        returnOrder = new ReturnOrder();
        GameRegistry.register((IForgeRegistryEntry)returnOrder);
        territoryMap = new TerritoryMap();
        GameRegistry.register((IForgeRegistryEntry)territoryMap);
    }

    private void loadModels() {
        ModelLoader.setCustomModelResourceLocation((Item)startDeed, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:startfactiondeed"));
        ModelLoader.setCustomModelResourceLocation((Item)claimOrder, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:claimorder"));
        ModelLoader.setCustomModelResourceLocation((Item)paymentOrder, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:paymentorder"));
        ModelLoader.setCustomModelResourceLocation((Item)renameOrder, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:factionnameorder"));
        ModelLoader.setCustomModelResourceLocation((Item)playerIDCard, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:playerid_blank"));
        ModelLoader.setCustomModelResourceLocation((Item)playerIDCard, (int)1, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:playerid"));
        ModelLoader.setCustomModelResourceLocation((Item)infoCard, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:overviewcard"));
        ModelLoader.setCustomModelResourceLocation((Item)inheritanceDeed, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:inheritancedeed_blank"));
        ModelLoader.setCustomModelResourceLocation((Item)inheritanceDeed, (int)1, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:inheritancedeed"));
        ModelLoader.setCustomModelResourceLocation((Item)factionLedger, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:factionledger_blank"));
        ModelLoader.setCustomModelResourceLocation((Item)factionLedger, (int)1, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:factionledger"));
        ModelLoader.setCustomModelResourceLocation((Item)returnOrder, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:returnorder"));
        ModelLoader.setCustomModelResourceLocation((Item)territoryMap, (int)0, (ModelResourceLocation)new ModelResourceLocation("territorychevsky:territorymap"));
    }

    private void registerItemRecipes() {
        this.registerLeaderRecipes(new ItemStack(claimOrder), Items.field_151121_aF, Items.field_151032_g);
        this.registerLeaderRecipes(new ItemStack(paymentOrder), Items.field_151121_aF, Items.field_151054_z);
        this.registerLeaderRecipes(new ItemStack(renameOrder), Items.field_151121_aF, Items.field_151065_br);
        this.registerLeaderRecipes(new ItemStack(inheritanceDeed), Items.field_151121_aF, Items.field_151043_k);
        this.registerLeaderRecipes(new ItemStack(factionLedger), Items.field_151121_aF, Items.field_151122_aG);
        this.registerLeaderRecipes(new ItemStack(returnOrder), Items.field_151121_aF, (Item)Items.field_151148_bJ);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(playerIDCard), (Object[])new Object[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151041_m)});
        Object[] objectArray = new Object[7];
        objectArray[0] = " o ";
        objectArray[1] = "oco";
        objectArray[2] = " o ";
        objectArray[3] = Character.valueOf('o');
        objectArray[4] = new ItemStack(claimOrder);
        objectArray[5] = Character.valueOf('c');
        objectArray[6] = Items.field_151111_aL;
        GameRegistry.addRecipe((ItemStack)new ItemStack(territoryMap), (Object[])objectArray);
    }

    private void registerLeaderRecipes(ItemStack result, Item comp1, Item comp2) {
        if (result == null) {
            return;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (comp1 != null) {
            list.add(new ItemStack(comp1));
        }
        if (comp2 != null) {
            list.add(new ItemStack(comp2));
        }
        if (!list.isEmpty()) {
            GameRegistry.addRecipe((IRecipe)new Recipe_LeaderRequired(result, list));
        }
    }

    private void registerPaymentRecipes() {
        this.registerPayment(new ItemStack(Items.field_151166_bC), ValueTable.getValueFromItem(Items.field_151166_bC));
        this.registerPayment(new ItemStack(Items.field_151045_i), ValueTable.getValueFromItem(Items.field_151045_i));
        this.registerPayment(new ItemStack(Items.field_151043_k), ValueTable.getValueFromItem(Items.field_151043_k));
        this.registerPayment(new ItemStack(Item.func_150898_a((Block)Blocks.field_150475_bE)), ValueTable.getValueFromBlock(Blocks.field_150475_bE));
        this.registerPayment(new ItemStack(Item.func_150898_a((Block)Blocks.field_150484_ah)), ValueTable.getValueFromBlock(Blocks.field_150484_ah));
        this.registerPayment(new ItemStack(Item.func_150898_a((Block)Blocks.field_150340_R)), ValueTable.getValueFromBlock(Blocks.field_150340_R));
    }

    private void registerPayment(ItemStack component, int value) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack resultStack = new ItemStack(paymentOrder, 1, Short.MAX_VALUE);
        list.add(resultStack);
        list.add(component);
        GameRegistry.addRecipe((IRecipe)new Recipe_Payment(new ItemStack(paymentOrder), list, value));
    }

    public static void console(String text) {
        if (text == null) {
            return;
        }
        if (!isDebugEnabled) {
            return;
        }
        System.out.println(text);
    }

    public static void sendMessageToPlayer(EntityPlayer player, String msg) {
        player.func_145747_a((ITextComponent)new TextComponentString(msg));
    }

    public static void startFireworks(Entity entity) {
        EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, null);
        entity.field_70170_p.func_72838_d((Entity)entityfireworkrocket);
        entity.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, entity.field_70165_t, entity.field_70163_u - 0.3, entity.field_70161_v, new Random().nextGaussian() * 0.05, -entity.field_70181_x * 0.5, new Random().nextGaussian() * 0.05, new int[0]);
    }

    public static int getControlRefreshTick() {
        return controlRefreshTick;
    }

    public static int getSaveTick() {
        return saveTick;
    }

    public static int getConsumeUpkeepTick() {
        return consumeUpkeepTick;
    }

    public static int getStrengthRefreshAmount() {
        return controlStrengthRefresh;
    }

    public static int getMaxControlStrength() {
        return maxControlStrength;
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static String getConfigDirPath() {
        return configDir.getPath();
    }

    public static String getWorldFolder() {
        return worldFolder;
    }

    public static boolean doesPlayerNeedToBeOnline() {
        return playerNeedsToBeOnline;
    }

    public static int getUpkeepMultiplier() {
        return upkeepMultiplier;
    }

    public static double getRequiredPlayerAmount() {
        return playerAmountForOnline;
    }

    public static boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static Item getPaymentOrder() {
        return paymentOrder;
    }

    public static int getMaxPaymentOrderAmount() {
        return maxPaymentOrderAmount;
    }

    public static boolean isPlayerInteractionAllowed() {
        return allowPlayerInteract;
    }
}

