/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.SaveHandler;
import net.wwsf.domochevsky.territorialdealings._Territory;

public class TerritoryHandler {
    private static ArrayList<_Territory> factions = new ArrayList();

    public static ArrayList<_Territory> getFactionsForSaving() {
        return factions;
    }

    public static void setFactionsFromLoading(ArrayList<_Territory> fact) {
        factions = fact;
    }

    public static void setFactionsFromLoadingOld(_Territory[] oldFactions) {
        if (oldFactions == null) {
            return;
        }
        for (int slot = 0; slot < oldFactions.length && oldFactions[slot] != null; ++slot) {
            if (!oldFactions[slot].isFactionValid()) continue;
            factions.add(oldFactions[slot]);
        }
    }

    public static boolean tryToAddFaction(World world, EntityPlayer player, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (TerritoryHandler.isChunkOccupied(chunk)) {
            if (player.field_71075_bZ.field_75098_d) {
                _Territory faction = TerritoryHandler.getFactionFromChunk(chunk);
                Main.sendMessageToPlayer(player, "Assuming control of faction " + faction.getFactionName() + ".");
                faction.addMember(player);
                faction.setNewLeader(player);
            } else {
                Main.sendMessageToPlayer(player, "This territory is already occupied by another faction.");
            }
            return false;
        }
        _Territory faction = TerritoryHandler.getFactionPlayerIsMemberOf(player);
        if (faction != null) {
            Main.sendMessageToPlayer(player, "You are already a member of " + faction.getFactionName() + ".");
            return false;
        }
        TerritoryHandler.addFaction(player, chunk);
        return true;
    }

    private static void addFaction(EntityPlayer player, Chunk chunk) {
        _Territory territory = new _Territory(player.field_70170_p.field_73011_w.getDimension(), player.func_70005_c_() + "'s Group");
        Main.console("[TERRITORY HANDLER] Added a new faction in dimension " + territory.getDimensionID() + ". Core chunk pos: X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h);
        territory.addMember(player);
        territory.setLeader(player);
        territory.addChunk(chunk);
        territory.setUpkeepPaid(true);
        factions.add(territory);
        Main.startFireworks((Entity)player);
        Main.sendMessageToPlayer(player, "New faction successfully founded and territory claimed! Faction name: " + territory.getFactionName());
        SaveHandler.saveFactionsToFile();
    }

    public static boolean isChunkOccupied(Chunk chunk) {
        if (chunk == null) {
            return false;
        }
        for (_Territory territory : factions) {
            if (chunk.func_177412_p().field_73011_w.getDimension() != territory.getDimensionID() || !territory.isChunkInTerritory(chunk)) continue;
            Main.console("[TERRITORY HANDLER] Chunk at X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h + " is occupied by faction " + territory.getFactionName() + ".");
            return true;
        }
        return false;
    }

    public static _Territory getFactionFromChunk(Chunk chunk) {
        for (_Territory territory : factions) {
            if (chunk.func_177412_p().field_73011_w.getDimension() != territory.getDimensionID() || !territory.isChunkInTerritory(chunk)) continue;
            return territory;
        }
        return null;
    }

    public static boolean canPlayerEditChunk(EntityPlayer player, Chunk chunk) {
        if (player == null) {
            return false;
        }
        if (chunk == null) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            Main.console("[TERRITORIAL DEALINGS] Player " + player.func_70005_c_() + " is in creative mode.");
            return true;
        }
        for (_Territory territory : factions) {
            if (chunk.func_177412_p().field_73011_w.getDimension() != territory.getDimensionID() || !territory.isChunkInTerritory(chunk)) continue;
            if (!territory.isUpkeepPaid()) {
                Main.console("[TERRITORIAL DEALINGS] Territory of " + territory.getFactionName() + " is currently unprotected.");
                return true;
            }
            if (territory.isPartOfFaction(player)) {
                Main.console("[TERRITORIAL DEALINGS] Player " + player.func_70005_c_() + " is a member of territory owner faction. (" + territory.getFactionName() + ")");
                return true;
            }
            Main.console("[TERRITORIAL DEALINGS] Player " + player.func_70005_c_() + " is not a member of territory owner faction. (" + territory.getFactionName() + ")");
            return false;
        }
        Main.console("[TERRITORIAL DEALINGS] No faction seems to have claimed this chunk.");
        return true;
    }

    public static boolean addChunkToFaction(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        _Territory faction = TerritoryHandler.getFactionPlayerIsMemberOf(player);
        if (faction == null) {
            Main.console("[addChunkToFaction] Player (" + player.func_70005_c_() + ") is not part of any faction. Can't claim territory.");
            Main.sendMessageToPlayer(player, "You are not part of any faction and thus can't claim any territory.");
            return false;
        }
        Chunk chunk = player.field_70170_p.func_175726_f(new BlockPos((Entity)player));
        if (faction.isChunkInTerritory(chunk)) {
            Main.console("[addChunkToFaction] Chunk at X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h + " is already part of player's (" + player.func_70005_c_() + ") faction.");
            return false;
        }
        _Territory enemyFaction = TerritoryHandler.getFactionFromChunk(chunk);
        if (enemyFaction != null) {
            Main.console("[addChunkToFaction] Chunk at X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h + " is part of another faction. Starting takeover.");
            if (enemyFaction.isMemberOnline(player.field_70170_p)) {
                enemyFaction.takeOverChunk(chunk);
                Main.startFireworks((Entity)player);
            } else {
                Main.sendMessageToPlayer(player, "No member of that faction is online. Cancelling takeover.");
            }
            return false;
        }
        boolean proceed = false;
        Chunk tempChunk = player.field_70170_p.func_72964_e(chunk.field_76635_g + 1, chunk.field_76647_h);
        if (faction.isChunkInTerritory(tempChunk)) {
            proceed = true;
        }
        if (!proceed && faction.isChunkInTerritory(tempChunk = player.field_70170_p.func_72964_e(chunk.field_76635_g - 1, chunk.field_76647_h))) {
            proceed = true;
        }
        if (!proceed && faction.isChunkInTerritory(tempChunk = player.field_70170_p.func_72964_e(chunk.field_76635_g, chunk.field_76647_h + 1))) {
            proceed = true;
        }
        if (!proceed && faction.isChunkInTerritory(tempChunk = player.field_70170_p.func_72964_e(chunk.field_76635_g, chunk.field_76647_h - 1))) {
            proceed = true;
        }
        if (!proceed) {
            Main.console("[addChunkToFaction] Chunk at X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h + " is unclaimed, but not adjacent to existing territory of player's (" + player.func_70005_c_() + ") faction.");
            Main.sendMessageToPlayer(player, "This chunk is not adjacent to your faction's territory.");
            return false;
        }
        Main.console("[addChunkToFaction] Chunk at X " + chunk.field_76635_g + " / Z " + chunk.field_76647_h + " is unclaimed and adjacent to existing territory at X " + tempChunk.field_76635_g + " / Z " + tempChunk.field_76647_h + ". Adding it.");
        faction.addChunk(chunk);
        Main.sendMessageToPlayer(player, "Territory successfully claimed in the name of " + faction.getFactionName() + ".");
        Main.startFireworks((Entity)player);
        return true;
    }

    public static _Territory getFactionPlayerIsMemberOf(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        for (_Territory territory : factions) {
            if (!territory.isPartOfFaction(player)) continue;
            return territory;
        }
        return null;
    }

    public static _Territory getFactionPlayerIsLeaderOf(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        for (_Territory territory : factions) {
            if (!territory.isLeader(player)) continue;
            return territory;
        }
        return null;
    }

    public static _Territory getFactionPlayerIsLeaderOf(UUID leaderUUID) {
        if (leaderUUID == null) {
            return null;
        }
        for (_Territory territory : factions) {
            if (!territory.isLeader(leaderUUID)) continue;
            return territory;
        }
        return null;
    }

    public static void refreshChunkControl() {
        Main.console("[TERRITORIAL DEALINGS] Refreshing chunk control of all territories by " + Main.getStrengthRefreshAmount() + ". Max control strength: " + Main.getMaxControlStrength());
        Iterator<_Territory> it = factions.iterator();
        while (it.hasNext()) {
            it.next().refreshChunkControl();
        }
    }

    public static void consumeUpkeep(World world) {
        Main.console("[TERRITORIAL DEALINGS] Consuming upkeep for all claimed territories now.");
        Iterator<_Territory> it = factions.iterator();
        while (it.hasNext()) {
            it.next().consumeUpkeep(world);
        }
    }

    public static void removeTerritory(_Territory territory) {
        if (territory == null) {
            return;
        }
        factions.remove(territory);
    }

    public static Iterator<_Territory> getFactionIterator() {
        return factions.iterator();
    }
}

