/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Transition {
    static void transferPlayerToDimension(EntityPlayerMP player, int dimensionTo, int targetHeight) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (int)dimensionTo)) {
            return;
        }
        Teleporter teleporter = player.field_71133_b.func_71218_a(dimensionTo).func_85176_s();
        PlayerList playerList = player.field_71133_b.func_184103_al();
        int dimensionFrom = player.field_71093_bK;
        WorldServer wsPrev = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimensionTo;
        WorldServer wsNew = player.field_71133_b.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, wsNew.func_175659_aa(), wsNew.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        playerList.func_187243_f(player);
        wsPrev.func_72900_e((Entity)player);
        player.field_70128_L = false;
        Transition.transferEntityToWorld((Entity)player, dimensionFrom, wsPrev, wsNew, teleporter, targetHeight);
        playerList.func_72375_a(player, wsPrev);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(wsNew);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        playerList.func_72354_b(player, wsNew);
        playerList.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimensionFrom, dimensionTo);
    }

    private static void transferEntityToWorld(Entity entityIn, int lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn, Teleporter teleporter, int targetHeight) {
        WorldProvider pOld = oldWorldIn.field_73011_w;
        WorldProvider pNew = toWorldIn.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double newPosX = entityIn.field_70165_t * moveFactor;
        double newPosZ = entityIn.field_70161_v * moveFactor;
        float entityRotationYaw = entityIn.field_70177_z;
        oldWorldIn.field_72984_F.func_76320_a("moving");
        if (entityIn.field_71093_bK == 1) {
            BlockPos blockpos = lastDimension == 1 ? toWorldIn.func_175694_M() : toWorldIn.func_180504_m();
            newPosX = blockpos.func_177958_n();
            entityIn.field_70163_u = blockpos.func_177956_o();
            newPosZ = blockpos.func_177952_p();
            entityIn.func_70012_b(newPosX, entityIn.field_70163_u, newPosZ, 90.0f, 0.0f);
            if (entityIn.func_70089_S()) {
                oldWorldIn.func_72866_a(entityIn, false);
            }
        }
        oldWorldIn.field_72984_F.func_76319_b();
        if (lastDimension != 1) {
            oldWorldIn.field_72984_F.func_76320_a("placing");
            newPosX = MathHelper.func_76125_a((int)((int)newPosX), (int)-29999872, (int)29999872);
            newPosZ = MathHelper.func_76125_a((int)((int)newPosZ), (int)-29999872, (int)29999872);
            if (entityIn.func_70089_S()) {
                entityIn.func_70012_b(newPosX, (double)targetHeight, newPosZ, entityIn.field_70177_z, entityIn.field_70125_A);
                toWorldIn.func_72838_d(entityIn);
                toWorldIn.func_72866_a(entityIn, false);
            }
            oldWorldIn.field_72984_F.func_76319_b();
        }
        entityIn.func_70029_a((World)toWorldIn);
    }
}

