/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings.Transition;
import net.wwsf.domochevsky.territorialdealings._ClaimedChunk;

public class _Territory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID leaderUUID;
    private HashMap<UUID, String> members = new HashMap();
    private int memberCount = 0;
    private int dimensionID;
    private String factionName;
    private ArrayList<_ClaimedChunk> chunks = new ArrayList();
    private int chunkCount = 0;
    private boolean upkeepPaid;
    private int upkeepStored;
    private byte mapColor = (byte)-1;
    private double returnX;
    private double returnY;
    private double returnZ;
    private int returnDim;

    public _Territory(int dimID, String name) {
        this.dimensionID = dimID;
        this.factionName = name;
        Random rand = new Random();
        this.mapColor = (byte)rand.nextInt(16);
    }

    public boolean isFactionValid() {
        if (this.leaderUUID == null) {
            return false;
        }
        return !this.members.isEmpty();
    }

    public MapColor getMapColor() {
        if (this.mapColor == -1 || this.mapColor >= MapColor.field_76281_a.length) {
            Random rand = new Random();
            this.mapColor = (byte)rand.nextInt(MapColor.field_76281_a.length);
        }
        return MapColor.field_76281_a[this.mapColor];
    }

    public boolean isLeader(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return this.leaderUUID != null && this.leaderUUID.equals(player.func_146103_bH().getId());
    }

    public void setLeader(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.leaderUUID = player.func_146103_bH().getId();
        this.sendMessageToFactionMembers(player.field_70170_p, player.func_70005_c_() + " has become LEADER!");
        if (this.members.containsKey(this.leaderUUID)) {
            this.members.put(this.leaderUUID, "\u00ef\u00bf\u00bd6" + player.func_70005_c_());
        }
    }

    public void setNewLeader(EntityPlayer player) {
        if (player == null) {
            return;
        }
        UUID prevLeader = this.leaderUUID;
        this.leaderUUID = player.func_146103_bH().getId();
        if (this.members.containsKey(prevLeader)) {
            String prevName = this.members.get(prevLeader);
            this.members.put(prevLeader, prevName.replace("\u00ef\u00bf\u00bd6", ""));
        }
        this.members.put(this.leaderUUID, "\u00ef\u00bf\u00bd6" + player.func_70005_c_());
        this.sendMessageToFactionMembers(player.field_70170_p, player.func_70005_c_() + " has become LEADER!");
    }

    public boolean isChunkInTerritory(Chunk chunk) {
        return this.getChunkClaimFromTerritory(chunk) != null;
    }

    public void addChunk(Chunk chunk) {
        if (chunk == null) {
            return;
        }
        if (this.chunks.contains(chunk)) {
            return;
        }
        _ClaimedChunk claim = new _ClaimedChunk(chunk.field_76635_g, chunk.field_76647_h);
        this.chunks.add(claim);
        ++this.chunkCount;
    }

    public boolean isPartOfFaction(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return this.members.containsKey(player.func_146103_bH().getId());
    }

    public void addMember(EntityPlayer player) {
        if (player == null) {
            return;
        }
        if (TerritoryHandler.getFactionPlayerIsMemberOf(player) != null) {
            return;
        }
        this.members.put(player.func_146103_bH().getId(), player.func_70005_c_());
        ++this.memberCount;
        this.sendMessageToFactionMembers(player.field_70170_p, player.func_70005_c_() + " was added as faction member of " + this.getFactionName() + ".");
    }

    public void removeMember(EntityPlayer player) {
        if (this.members.remove(player.func_146103_bH().getId()) != null) {
            --this.memberCount;
            this.sendMessageToFactionMembers(player.field_70170_p, player.func_70005_c_() + " left the faction " + this.getFactionName() + ".");
        }
    }

    public void takeOverChunk(Chunk chunk) {
        Iterator<_ClaimedChunk> it = this.chunks.iterator();
        while (it.hasNext()) {
            _ClaimedChunk claim = it.next();
            if (chunk.field_76635_g != claim.getChunkPosX() || chunk.field_76647_h != claim.getChunkPosZ()) continue;
            claim.decreaseControlStrength();
            this.sendMessageToFactionMembers(chunk.func_177412_p(), "Someone is trying to take over the chunk at X " + claim.getChunkPosX() + " / Z " + claim.getChunkPosZ() + "! Control strength: " + claim.getControlStrength());
            if (!this.isUpkeepPaid()) {
                claim.DisableStrength();
            }
            if (claim.getControlStrength() > 0) continue;
            it.remove();
            this.sendMessageToFactionMembers(chunk.func_177412_p(), "Chunk control lost!");
            --this.chunkCount;
            this.verifyTerritory(claim, chunk.func_177412_p(), chunk);
        }
    }

    public void sendMessageToFactionMembers(World world, String msg) {
        for (EntityPlayer player : world.field_73010_i) {
            if (!this.isPartOfFaction(player)) continue;
            Main.sendMessageToPlayer(player, msg);
        }
    }

    public void dropValuablesAtFactionMember(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            if (this.isLeader(player)) {
                this.dropValuables(world, player);
                return;
            }
            if (!this.isPartOfFaction(player)) continue;
            this.dropValuables(world, player);
            return;
        }
    }

    private void dropValuables(World world, EntityPlayer player) {
        while (this.getUpkeepStored() > 0) {
            int amount = Main.getMaxPaymentOrderAmount();
            if (this.getUpkeepStored() < Main.getMaxPaymentOrderAmount()) {
                amount = this.getUpkeepStored();
            }
            ItemStack stack = new ItemStack(Main.getPaymentOrder(), 1, amount);
            EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, stack);
            entityitem.func_174869_p();
            Main.console("[TERRITORIAL DEALINGS] Dropping all valuables at position of " + player.func_70005_c_() + ". Current amount: " + amount + ". Leftover: " + this.getUpkeepStored());
            world.func_72838_d((Entity)entityitem);
            this.upkeepStored -= amount;
        }
    }

    public _ClaimedChunk getChunkClaimFromTerritory(Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        for (_ClaimedChunk claim : this.chunks) {
            if (chunk.field_76635_g != claim.getChunkPosX() || chunk.field_76647_h != claim.getChunkPosZ()) continue;
            return claim;
        }
        return null;
    }

    private void verifyTerritory(_ClaimedChunk claim, World world, Chunk chunk) {
        Main.console("[TERRITORY] Verified territory. Claimed chunks of faction " + this.getFactionName() + ": " + this.getChunkCount());
        if (this.getChunkCount() <= 0) {
            TerritoryHandler.removeTerritory(this);
            this.sendMessageToFactionMembers(world, "Faction " + this.getFactionName() + " has no territory left! Disbanding.");
            Main.console("[TERRITORY] Dropping remaining vault contents at last chunk. Value: " + this.getUpkeepStored());
            this.dropValuablesAtFactionMember(world);
        }
    }

    public void refreshChunkControl() {
        for (_ClaimedChunk claim : this.chunks) {
            if (claim.getControlStrength() >= Main.getMaxControlStrength()) continue;
            claim.refreshControlStrength();
        }
    }

    public void addUpkeep(EntityPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        this.upkeepStored += amount;
        this.setUpkeepPaid(true);
        this.sendMessageToFactionMembers(player.field_70170_p, "Added " + amount + " VALUABLES to territory vault. Total: " + this.getUpkeepStored());
    }

    public void consumeUpkeep(World world) {
        if (Main.getUpkeepMultiplier() <= 0) {
            return;
        }
        this.sendMessageToFactionMembers(world, "Deducting territory upkeep of " + this.getChunkCount() * Main.getUpkeepMultiplier() + " VALUABLES from the vault (" + this.getUpkeepStored() + " VALUABLES) now.");
        Main.console("[TERRITORIAL DEALINGS] Deducting territory upkeep of " + this.getChunkCount() * Main.getUpkeepMultiplier() + " VALUABLES from the vault (" + this.getUpkeepStored() + " VALUABLES) now.");
        this.upkeepStored -= this.getChunkCount() * Main.getUpkeepMultiplier();
        if (this.getUpkeepStored() < 0) {
            this.upkeepStored = 0;
            this.setUpkeepPaid(false);
            this.sendMessageToFactionMembers(world, "Deduction failed! Disabling territory protection.");
        } else {
            this.sendMessageToFactionMembers(world, "Deduction successful. Territory protection is enabled.");
        }
    }

    public boolean isMemberOnline(World world) {
        if (!Main.doesPlayerNeedToBeOnline()) {
            return true;
        }
        if (!this.isUpkeepPaid()) {
            return true;
        }
        Iterator it = world.field_73010_i.iterator();
        double percentOnline = 0.0;
        double percentIncrease = 100 / this.memberCount;
        while (it.hasNext()) {
            EntityPlayer player = (EntityPlayer)it.next();
            if (!this.isPartOfFaction(player) || !((percentOnline += percentIncrease) >= Main.getRequiredPlayerAmount())) continue;
            return true;
        }
        return false;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public String getFactionName() {
        return this.factionName;
    }

    public void setFactionName(String factionName) {
        this.factionName = factionName;
    }

    public boolean isUpkeepPaid() {
        return this.upkeepPaid;
    }

    public void setUpkeepPaid(boolean upkeepPaid) {
        this.upkeepPaid = upkeepPaid;
    }

    public int getChunkControlStrength(Chunk chunk) {
        if (chunk == null) {
            return 0;
        }
        _ClaimedChunk claim = this.getChunkClaimFromTerritory(chunk);
        if (claim == null) {
            return 0;
        }
        return claim.getControlStrength();
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public int getUpkeepStored() {
        return this.upkeepStored;
    }

    public Iterator<Map.Entry<UUID, String>> getMemberListIterator() {
        return this.members.entrySet().iterator();
    }

    public boolean isLeader(UUID uuid) {
        return this.leaderUUID.equals(uuid);
    }

    public int getMembercount() {
        return this.memberCount;
    }

    public void markPositionForReturn(EntityPlayer player) {
        if (!this.isLeader(player)) {
            return;
        }
        Chunk chunk = player.field_70170_p.func_175726_f(new BlockPos((Entity)player));
        if (!this.isChunkInTerritory(chunk)) {
            Main.sendMessageToPlayer(player, "This location doesn't seem to be part of your territory.");
            return;
        }
        this.returnX = player.field_70165_t;
        this.returnY = player.field_70163_u;
        this.returnZ = player.field_70161_v;
        this.returnDim = player.field_71093_bK;
        Main.sendMessageToPlayer(player, "Marked this position as return point for your faction members.");
    }

    public void moveMemberToReturnPoint(EntityPlayer player) {
        if (this.returnX == 0.0 && this.returnY == 0.0 && this.returnZ == 0.0) {
            Main.sendMessageToPlayer(player, "Looks like no return point has been set set.");
            return;
        }
        player.func_70634_a(this.returnX, this.returnY, this.returnZ);
        if (this.returnDim != player.field_71093_bK) {
            Transition.transferPlayerToDimension((EntityPlayerMP)player, this.returnDim, (int)this.returnY);
            player.func_70634_a(this.returnX, this.returnY, this.returnZ);
        }
    }
}

