/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings.item;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings._Territory;
import net.wwsf.domochevsky.territorialdealings.item.LeaderRequiredItem;

public class FactionLedger
extends LeaderRequiredItem {
    public FactionLedger() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName("factionledger");
        this.func_77655_b("territorychevsky_factionledger");
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            return "Faction Ledger of " + stack.func_77978_p().func_74779_i("factionName");
        }
        return "Blank Faction Ledger";
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77942_o()) {
            this.displayFactionInfo(player, stack);
        } else {
            _Territory faction = TerritoryHandler.getFactionPlayerIsLeaderOf(player);
            if (faction != null) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74778_a("ownerName", player.func_70005_c_());
                stack.func_77978_p().func_74778_a("playerUUID", player.func_146103_bH().getId().toString());
                stack.func_77978_p().func_74778_a("factionName", faction.getFactionName());
                stack.func_77964_b(1);
            } else {
                Main.sendMessageToPlayer(player, "You don't seem to be the leader of any faction.");
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add("Holds information about a");
        list.add("faction and its members.");
        if (!stack.func_77942_o()) {
            list.add("It's blank.");
            list.add("\u00ef\u00bf\u00bdeUse to fill it as a leader.");
        } else {
            list.add("\u00ef\u00bf\u00bd9Signed by " + stack.func_77978_p().func_74779_i("ownerName") + ".");
            list.add("\u00ef\u00bf\u00bd9Faction: " + stack.func_77978_p().func_74779_i("factionName") + ".");
            list.add("\u00ef\u00bf\u00bdeUse to read it.");
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    private void displayFactionInfo(EntityPlayer player, ItemStack stack) {
        UUID uuid = UUID.fromString(stack.func_77978_p().func_74779_i("playerUUID"));
        _Territory territory = TerritoryHandler.getFactionPlayerIsLeaderOf(uuid);
        if (territory == null) {
            Main.sendMessageToPlayer(player, "This ledger doesn't seem to be valid anymore. Who signed it?");
            return;
        }
        Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bd9Faction: " + territory.getFactionName());
        Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bdaTerritory: " + territory.getChunkCount() + " Chunks (Protected: " + territory.isUpkeepPaid() + ")");
        Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bdeIn vault: " + territory.getUpkeepStored() + " VALUABLES");
        Main.sendMessageToPlayer(player, "Members:");
        Iterator<Map.Entry<UUID, String>> memberIt = territory.getMemberListIterator();
        if (!memberIt.hasNext()) {
            Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bdc- NONE (This should not be possible.)");
        }
        while (memberIt.hasNext()) {
            Main.sendMessageToPlayer(player, "- " + memberIt.next().getValue());
        }
    }
}

