/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings.item;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings._Territory;

public class FactionOverviewCard
extends Item {
    public FactionOverviewCard() {
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName("overviewcard");
        this.func_77655_b("territorychevsky_overviewcard");
    }

    public String func_77653_i(ItemStack stack) {
        return "Overview Card";
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            this.toggleChunkProtection(player);
        } else {
            this.getFactionInfo(player);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void getFactionInfo(EntityPlayer player) {
        Main.sendMessageToPlayer(player, "Factions:");
        Iterator<_Territory> it = TerritoryHandler.getFactionIterator();
        if (!it.hasNext()) {
            Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bd7NONE");
        }
        while (it.hasNext()) {
            _Territory territory = it.next();
            Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bd9" + territory.getFactionName() + " (" + territory.getChunkCount() + " Chunks / " + territory.getUpkeepStored() + " Valuables / Protection: " + territory.isUpkeepPaid() + ")");
            Iterator<Map.Entry<UUID, String>> memberIt = territory.getMemberListIterator();
            if (!memberIt.hasNext()) {
                Main.sendMessageToPlayer(player, "\u00ef\u00bf\u00bdc- NONE (This should not be possible.)");
            }
            while (memberIt.hasNext()) {
                Map.Entry<UUID, String> entry = memberIt.next();
                if (Main.isDebugEnabled()) {
                    Main.sendMessageToPlayer(player, "- " + entry.getValue() + "\u00ef\u00bf\u00bdf (UUID " + entry.getKey() + ")");
                    continue;
                }
                Main.sendMessageToPlayer(player, "- " + entry.getValue());
            }
        }
    }

    private void toggleChunkProtection(EntityPlayer player) {
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        Chunk chunk = player.field_70170_p.func_175726_f(pos);
        _Territory faction = TerritoryHandler.getFactionFromChunk(chunk);
        if (faction == null) {
            return;
        }
        if (faction.isUpkeepPaid()) {
            faction.setUpkeepPaid(false);
            Main.sendMessageToPlayer(player, "Disabled chunk protection for faction " + faction.getFactionName() + " until next upkeep payment.");
        } else {
            faction.setUpkeepPaid(true);
            Main.sendMessageToPlayer(player, "Enabled chunk protection for faction " + faction.getFactionName() + " until next upkeep payment.");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add("Use to display a list of all");
        list.add("factions and their members.");
        list.add("Crouch-use to toggle chunk protection");
        list.add("of the faction whose chunk you're");
        list.add("standing in right now.");
        list.add("\u00ef\u00bf\u00bdcOnly usable in creative mode.");
    }
}

