/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.wwsf.domochevsky.territorialdealings.Main;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings._Territory;

public class PlayerIDCard
extends Item {
    public PlayerIDCard() {
        this.func_77625_d(1);
        this.func_77656_e(1);
        this.func_77664_n();
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName("playerid");
        this.func_77655_b("territorychevsky_playerid");
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            return "Player ID Card of " + stack.func_77978_p().func_74779_i("ownerName");
        }
        return "Blank Player ID Card";
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77942_o()) {
            if (UUID.fromString(stack.func_77978_p().func_74779_i("playerUUID")).equals(player.func_146103_bH().getId())) {
                _Territory faction = TerritoryHandler.getFactionPlayerIsMemberOf(player);
                if (faction != null) {
                    if (player.func_70093_af()) {
                        this.leaveFaction(player);
                    } else {
                        stack.func_77978_p().func_74778_a("factionName", faction.getFactionName());
                    }
                }
            } else if (player.func_70093_af()) {
                if (this.removePlayerFromFaction(world, player, UUID.fromString(stack.func_77978_p().func_74779_i("playerUUID")))) {
                    stack.func_77978_p().func_74778_a("factionName", "NONE");
                }
            } else {
                _Territory faction = this.addPlayerToFaction(world, player, UUID.fromString(stack.func_77978_p().func_74779_i("playerUUID")));
                if (faction != null) {
                    stack.func_77978_p().func_74778_a("factionName", faction.getFactionName());
                }
            }
        } else {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a("ownerName", player.func_70005_c_());
            stack.func_77978_p().func_74778_a("playerUUID", player.func_146103_bH().getId().toString());
            stack.func_77978_p().func_74778_a("factionName", "NONE");
            _Territory faction = TerritoryHandler.getFactionPlayerIsMemberOf(player);
            if (faction != null) {
                stack.func_77978_p().func_74778_a("factionName", faction.getFactionName());
            }
            stack.func_77964_b(1);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private void leaveFaction(EntityPlayer player) {
        _Territory faction = TerritoryHandler.getFactionPlayerIsMemberOf(player);
        if (faction != null) {
            if (faction.isLeader(player)) {
                TerritoryHandler.removeTerritory(faction);
                faction.dropValuablesAtFactionMember(player.field_70170_p);
                faction.sendMessageToFactionMembers(player.field_70170_p, "The leader of " + faction.getFactionName() + " left the faction. Disbanding!");
                Main.console("[TERRITORIAL DEALINGS] " + player.func_70005_c_() + ", the leader of " + faction.getFactionName() + ", left the faction. Disbanding!");
            } else {
                faction.removeMember(player);
                Main.sendMessageToPlayer(player, "You left your faction.");
                Main.console("[TERRITORIAL DEALINGS] " + player.func_70005_c_() + ", a member of " + faction.getFactionName() + ", left the faction.");
            }
        }
    }

    private _Territory addPlayerToFaction(World world, EntityPlayer leader, UUID uuid) {
        _Territory faction = TerritoryHandler.getFactionPlayerIsLeaderOf(leader);
        if (faction == null) {
            return null;
        }
        for (EntityPlayer player : world.field_73010_i) {
            if (!player.func_146103_bH().getId().equals(uuid)) continue;
            faction.addMember(player);
            return faction;
        }
        Main.sendMessageToPlayer(leader, "Couldn't add that player to your faction. They might not be online.");
        return null;
    }

    private boolean removePlayerFromFaction(World world, EntityPlayer leader, UUID playerUUID) {
        _Territory faction = TerritoryHandler.getFactionPlayerIsLeaderOf(leader);
        for (EntityPlayer player : world.field_73010_i) {
            if (!player.func_146103_bH().getId().equals(playerUUID)) continue;
            if (faction.isLeader(player)) {
                TerritoryHandler.removeTerritory(faction);
                faction.dropValuablesAtFactionMember(player.field_70170_p);
                faction.sendMessageToFactionMembers(leader.field_70170_p, "The leader of " + faction.getFactionName() + " left the faction. Disbanding!");
                return true;
            }
            if (faction.isPartOfFaction(player)) {
                faction.removeMember(player);
                Main.sendMessageToPlayer(leader, player.func_70005_c_() + " has been removed from " + faction.getFactionName() + ".");
                return true;
            }
            Main.sendMessageToPlayer(leader, player.func_70005_c_() + " is not a member of " + faction.getFactionName() + ".");
            return false;
        }
        Main.sendMessageToPlayer(leader, "Couldn't remove that player from your faction. They might not be online.");
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (!stack.func_77942_o()) {
            list.add("Use to sign this card with your ID.");
        } else {
            list.add("Signed by " + stack.func_77978_p().func_74779_i("ownerName"));
            list.add("Member of " + stack.func_77978_p().func_74779_i("factionName"));
            list.add("\u00ef\u00bf\u00bdcCrouch-use to leave your faction.");
            list.add("\u00ef\u00bf\u00bdeLeader: Use/crouch-use to add/remove");
            list.add("\u00ef\u00bf\u00bdethis player to/from your faction.");
            list.add("\u00ef\u00bf\u00bdcLeader: If you crouch-use your own");
            list.add("\u00ef\u00bf\u00bdccard, your faction will disband.");
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

