/*
 * Decompiled with CFR 0.152.
 */
package net.wwsf.domochevsky.territorialdealings.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.wwsf.domochevsky.territorialdealings.TerritoryHandler;
import net.wwsf.domochevsky.territorialdealings._Territory;

public class TerritoryMap
extends ItemMap {
    public TerritoryMap() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77627_a(true);
        this.setRegistryName("territorymap");
        this.func_77655_b("territorychevsky_territorymap");
    }

    public String func_77653_i(ItemStack stack) {
        return "Territory Map";
    }

    public MapData func_77873_a(ItemStack stack, World world) {
        if (!this.isMapReady(stack)) {
            return null;
        }
        String mapID = "map_" + stack.func_77952_i();
        MapData mapdata = (MapData)world.func_72943_a(MapData.class, mapID);
        if (mapdata == null && !world.field_72995_K) {
            stack.func_77964_b(world.func_72841_b("map"));
            mapID = "map_" + stack.func_77952_i();
            mapdata = new MapData(mapID);
            mapdata.field_76197_d = (byte)2;
            int iUnknown = 128 * (1 << mapdata.field_76197_d);
            mapdata.field_76201_a = Math.round(world.func_72912_H().func_76079_c() / iUnknown) * iUnknown;
            mapdata.field_76199_b = Math.round(world.func_72912_H().func_76074_e() / iUnknown) * iUnknown;
            mapdata.field_76200_c = world.field_73011_w.getDimension();
            mapdata.func_76185_a();
            world.func_72823_a(mapID, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        MapData mapdata = this.func_77873_a(stack, worldIn);
        if (mapdata == null) {
            mapdata = new MapData("map_0");
            worldIn.func_72823_a("map_0", (WorldSavedData)mapdata);
        }
        return mapdata.func_176052_a(stack, worldIn, player);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            MapData mapdata = this.func_77873_a(stack, worldIn);
            if (mapdata == null) {
                mapdata = new MapData("map_0");
                worldIn.func_72823_a("map_0", (WorldSavedData)mapdata);
            }
            if (isSelected || entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack) {
                this.func_77872_a(worldIn, entityIn, mapdata);
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!this.isMapReady(stack)) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("initiated", true);
            stack.func_77964_b(world.func_72841_b("map"));
            String uniqueName = "map_" + stack.func_77952_i();
            MapData mapdata = new MapData(uniqueName);
            world.func_72823_a(uniqueName, (WorldSavedData)mapdata);
            mapdata.field_76197_d = (byte)2;
            int i = 128 * (1 << mapdata.field_76197_d);
            mapdata.field_76201_a = (int)(Math.round(player.field_70165_t / (double)i) * (long)i);
            mapdata.field_76199_b = (int)(Math.round(player.field_70161_v / (double)i) * (long)i);
            mapdata.field_76200_c = world.field_73011_w.getDimension();
            mapdata.func_76185_a();
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean showAdvancedInfo) {
        if (!this.isMapReady(stack)) {
            info.add("It's currently blank. Use the");
            info.add("map to start inscribing it.");
        } else {
            MapData mapData = this.func_77873_a(stack, player.field_70170_p);
            info.add("A map of the land.");
            info.add("Dimension: " + mapData.field_76200_c);
            if (showAdvancedInfo) {
                info.add("Scaling at 1:" + (1 << mapData.field_76197_d));
                info.add("(Level " + mapData.field_76197_d + "/" + 4 + ")");
            }
        }
    }

    private boolean isMapReady(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("initiated");
    }

    public void func_77872_a(World worldIn, Entity viewer, MapData data) {
        if (worldIn.field_73011_w.func_186058_p().func_186068_a() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int mapScale = 1 << data.field_76197_d;
            int mapCenterX = data.field_76201_a;
            int mapCenterZ = data.field_76199_b;
            int mapX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)mapCenterX)) / mapScale + 64;
            int mapZ = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)mapCenterZ)) / mapScale + 64;
            int mapY = 128 / mapScale;
            if (worldIn.field_73011_w.func_177495_o()) {
                mapY /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int unknownInt = mapX - mapY + 1; unknownInt < mapX + mapY; ++unknownInt) {
                this.updateMapData_2(worldIn, viewer, data, mapX, mapY, mapZ, unknownInt, mapScale, mapCenterX, mapCenterZ, mapdata$mapinfo, flag);
            }
        }
    }

    private void updateMapData_2(World worldIn, Entity viewer, MapData data, int mapX, int mapY, int mapZ, int unknownInt, int mapScale, int mapCenterX, int mapCenterZ, MapData.MapInfo mapdata$mapinfo, boolean bUnknown) {
        if ((unknownInt & 0xF) == (mapdata$mapinfo.field_82569_d & 0xF) || bUnknown) {
            bUnknown = false;
            double d0 = 0.0;
            for (int unknownInt_2 = mapZ - mapY - 1; unknownInt_2 < mapZ + mapY; ++unknownInt_2) {
                byte b1;
                byte b0;
                MapColor mapcolor;
                if (unknownInt < 0 || unknownInt_2 < -1 || unknownInt >= 128 || unknownInt_2 >= 128) continue;
                int i2 = unknownInt - mapX;
                int j2 = unknownInt_2 - mapZ;
                boolean flag1 = i2 * i2 + j2 * j2 > (mapY - 2) * (mapY - 2);
                int k2 = (mapCenterX / mapScale + unknownInt - 64) * mapScale;
                int l2 = (mapCenterZ / mapScale + unknownInt_2 - 64) * mapScale;
                HashMultiset multiset = HashMultiset.create();
                Chunk chunk = worldIn.func_175726_f(new BlockPos(k2, 0, l2));
                _Territory territory = TerritoryHandler.getFactionFromChunk(chunk);
                if (chunk.func_76621_g()) continue;
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double dUnknown = 0.0;
                if (worldIn.field_73011_w.func_177495_o()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT).func_185909_g(), 10);
                    } else {
                        multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE).func_185909_g(), 100);
                    }
                    dUnknown = 100.0;
                } else {
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int i4 = 0; i4 < mapScale; ++i4) {
                        for (int j4 = 0; j4 < mapScale; ++j4) {
                            int blockHeight = chunk.func_76611_b(i4 + i3, j4 + j3) + 1;
                            IBlockState iblockstate = Blocks.field_150350_a.func_176223_P();
                            if (blockHeight > 1) {
                                while ((iblockstate = chunk.func_177435_g((BlockPos)blockpos$mutableblockpos.func_181079_c(i4 + i3, --blockHeight, j4 + j3))).func_185909_g() == MapColor.field_151660_b && blockHeight > 0) {
                                }
                                if (blockHeight > 0 && iblockstate.func_185904_a().func_76224_d()) {
                                    IBlockState iblockstate1;
                                    int l4 = blockHeight - 1;
                                    do {
                                        iblockstate1 = chunk.func_186032_a(i4 + i3, l4--, j4 + j3);
                                        ++k3;
                                    } while (l4 > 0 && iblockstate1.func_185904_a().func_76224_d());
                                }
                            }
                            dUnknown += (double)blockHeight / (double)(mapScale * mapScale);
                            if (territory != null) {
                                multiset.add((Object)territory.getMapColor());
                                continue;
                            }
                            multiset.add((Object)iblockstate.func_185909_g());
                        }
                    }
                }
                k3 /= mapScale * mapScale;
                double d2 = (dUnknown - d0) * 4.0 / (double)(mapScale + 4) + ((double)(unknownInt + unknownInt_2 & 1) - 0.5) * 0.4;
                int i5 = 1;
                if (d2 > 0.6) {
                    i5 = 2;
                }
                if (d2 < -0.6) {
                    i5 = 0;
                }
                if ((mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.field_151660_b)) == MapColor.field_151662_n) {
                    d2 = (double)k3 * 0.1 + (double)(unknownInt + unknownInt_2 & 1) * 0.2;
                    i5 = 1;
                    if (d2 < 0.5) {
                        i5 = 2;
                    }
                    if (d2 > 0.9) {
                        i5 = 0;
                    }
                }
                d0 = dUnknown;
                if (unknownInt_2 < 0 || i2 * i2 + j2 * j2 >= mapY * mapY || flag1 && (unknownInt + unknownInt_2 & 1) == 0 || (b0 = data.field_76198_e[unknownInt + unknownInt_2 * 128]) == (b1 = (byte)(mapcolor.field_76290_q * 4 + i5))) continue;
                data.field_76198_e[unknownInt + unknownInt_2 * 128] = b1;
                data.func_176053_a(unknownInt, unknownInt_2);
                bUnknown = true;
            }
        }
    }
}

