/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.core.ModVillagers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntitySnowVillager
extends EntityVillager {
    private String professionName;
    private VillagerRegistry.VillagerProfession prof;

    public EntitySnowVillager(World worldIn) {
        super(worldIn);
    }

    public EntitySnowVillager(World worldIn, int profession) {
        super(worldIn, profession);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        ModVillagers.INSTANCE.setRandomProfession(this, this.field_70170_p.field_73012_v);
        return livingdata;
    }

    public void func_70938_b(int professionId) {
        if (professionId > 2) {
            professionId = 2;
        }
        super.func_70938_b(professionId);
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityZombie && (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD)) {
            return;
        }
        super.func_70645_a(cause);
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        if (ModVillagers.INSTANCE.professions.containsValue(prof)) {
            try {
                this.field_70180_af.func_187227_b((DataParameter)ReflectionHelper.findField(EntityVillager.class, (String[])new String[]{"PROFESSION_STR", "PROFESSION_STR"}).get((Object)this), (Object)prof.getRegistryName().toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.prof = prof;
        } else {
            ModVillagers.INSTANCE.setRandomProfession(this, this.field_70170_p.field_73012_v);
        }
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntitySnowVillager entityvillager = new EntitySnowVillager(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            String p = this.getEntityData().func_74779_i("ProfessionName");
            this.prof = ModVillagers.INSTANCE.professions.get(this.intFromProfesion(p));
            try {
                ReflectionHelper.findField(EntityVillager.class, (String[])new String[]{"field_175563_bv", "careerId"}).set((Object)this, 1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.prof;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70938_b(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = ModVillagers.INSTANCE.professions.get(this.intFromProfesion(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = ModVillagers.INSTANCE.professions.get(0);
            }
            this.setProfession(p);
        }
    }

    private int intFromProfesion(String prof) {
        if (prof.contains("fisherman")) {
            return 0;
        }
        if (prof.contains("craftsman")) {
            return 1;
        }
        if (prof.contains("shaman")) {
            return 2;
        }
        return 0;
    }
}

