/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.api;

import com.google.common.collect.Maps;
import fossilsarcheology.api.EnumDiet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum FoodMappings {
    INSTANCE;

    private Map<Item, Integer> carnivoreItemDiet;
    private Map<Item, Integer> herbivoreItemDiet;
    private Map<Item, Integer> omnivoreItemDiet;
    private Map<Item, Integer> piscivoreItemDiet;
    private Map<Item, Integer> carnivoreEggItemDiet;
    private Map<Item, Integer> insectivoreItemDiet;
    private Map<Item, Integer> pisccarnivoreItemDiet;
    private Map<Block, Integer> carnivoreBlockDiet;
    private Map<Block, Integer> herbivoreBlockDiet;
    private Map<Block, Integer> omnivoreBlockDiet;
    private Map<Block, Integer> piscivoreBlockDiet;
    private Map<Block, Integer> carnivoreEggBlockDiet;
    private Map<Block, Integer> insectivoreBlockDiet;
    private Map<Block, Integer> pisccarnivoreBlockDiet;
    private Map<Class<? extends Entity>, Integer> carnivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> herbivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> omnivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> piscivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> carnivore_eggEntityDiet;
    private Map<Class<? extends Entity>, Integer> insectivoreEntityDiet;
    private Map<Class<? extends Entity>, Integer> pisccarnivoreEntityDiet;

    public void addToItemMappings(Item item, int food, EnumDiet diet) {
        if (item != null) {
            switch (diet) {
                case CARNIVORE: {
                    if (this.carnivoreItemDiet == null) {
                        this.carnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.carnivoreItemDiet.containsKey(item)) break;
                    this.carnivoreItemDiet.put(item, food);
                    break;
                }
                case HERBIVORE: {
                    if (this.herbivoreItemDiet == null) {
                        this.herbivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.herbivoreItemDiet.containsKey(item)) break;
                    this.herbivoreItemDiet.put(item, food);
                    break;
                }
                case OMNIVORE: {
                    if (this.omnivoreItemDiet == null) {
                        this.omnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.omnivoreItemDiet.containsKey(item)) break;
                    this.omnivoreItemDiet.put(item, food);
                    break;
                }
                case PISCIVORE: {
                    if (this.piscivoreItemDiet == null) {
                        this.piscivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.piscivoreItemDiet.containsKey(item)) break;
                    this.piscivoreItemDiet.put(item, food);
                    break;
                }
                case CARNIVORE_EGG: {
                    if (this.carnivoreEggItemDiet == null) {
                        this.carnivoreEggItemDiet = Maps.newHashMap();
                    }
                    if (this.carnivoreEggItemDiet.containsKey(item)) break;
                    this.carnivoreEggItemDiet.put(item, food);
                    break;
                }
                case INSECTIVORE: {
                    if (this.insectivoreItemDiet == null) {
                        this.insectivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.insectivoreItemDiet.containsKey(item)) break;
                    this.insectivoreItemDiet.put(item, food);
                    break;
                }
                case PISCCARNIVORE: {
                    if (this.pisccarnivoreItemDiet == null) {
                        this.pisccarnivoreItemDiet = Maps.newHashMap();
                    }
                    if (this.pisccarnivoreItemDiet.containsKey(item)) break;
                    this.pisccarnivoreItemDiet.put(item, food);
                    break;
                }
            }
        }
    }

    public int getItemFoodAmount(Item item, EnumDiet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreItemDiet == null || !this.carnivoreItemDiet.containsKey(item)) break;
                return this.carnivoreItemDiet.get(item);
            }
            case HERBIVORE: {
                if (this.herbivoreItemDiet == null || !this.herbivoreItemDiet.containsKey(item)) break;
                return this.herbivoreItemDiet.get(item);
            }
            case OMNIVORE: {
                if (this.omnivoreItemDiet == null || !this.omnivoreItemDiet.containsKey(item)) break;
                return this.omnivoreItemDiet.get(item);
            }
            case PISCIVORE: {
                if (this.piscivoreItemDiet == null || !this.piscivoreItemDiet.containsKey(item)) break;
                return this.piscivoreItemDiet.get(item);
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggItemDiet == null || !this.carnivoreEggItemDiet.containsKey(item)) break;
                return this.carnivoreEggItemDiet.get(item);
            }
            case INSECTIVORE: {
                if (this.insectivoreItemDiet == null || !this.insectivoreItemDiet.containsKey(item)) break;
                return this.insectivoreItemDiet.get(item);
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreItemDiet == null || !this.pisccarnivoreItemDiet.containsKey(item)) break;
                return this.pisccarnivoreItemDiet.get(item);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public void addToBlockMappings(Block block, int food, EnumDiet diet, boolean registerItem) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreBlockDiet == null) {
                    this.carnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.carnivoreBlockDiet.containsKey(block)) break;
                this.carnivoreBlockDiet.put(block, food);
                break;
            }
            case HERBIVORE: {
                if (this.herbivoreBlockDiet == null) {
                    this.herbivoreBlockDiet = Maps.newHashMap();
                }
                if (this.herbivoreBlockDiet.containsKey(block)) break;
                this.herbivoreBlockDiet.put(block, food);
                break;
            }
            case OMNIVORE: {
                if (this.omnivoreBlockDiet == null) {
                    this.omnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.omnivoreBlockDiet.containsKey(block)) break;
                this.omnivoreBlockDiet.put(block, food);
                break;
            }
            case PISCIVORE: {
                if (this.piscivoreBlockDiet == null) {
                    this.piscivoreBlockDiet = Maps.newHashMap();
                }
                if (this.piscivoreBlockDiet.containsKey(block)) break;
                this.piscivoreBlockDiet.put(block, food);
                break;
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggBlockDiet == null) {
                    this.carnivoreEggBlockDiet = Maps.newHashMap();
                }
                if (this.carnivoreEggBlockDiet.containsKey(block)) break;
                this.carnivoreEggBlockDiet.put(block, food);
                break;
            }
            case INSECTIVORE: {
                if (this.insectivoreBlockDiet == null) {
                    this.insectivoreBlockDiet = Maps.newHashMap();
                }
                if (this.insectivoreBlockDiet.containsKey(block)) break;
                this.insectivoreBlockDiet.put(block, food);
                break;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreBlockDiet == null) {
                    this.pisccarnivoreBlockDiet = Maps.newHashMap();
                }
                if (this.pisccarnivoreBlockDiet.containsKey(block)) break;
                this.pisccarnivoreBlockDiet.put(block, food);
                break;
            }
        }
        if (registerItem) {
            this.addToItemMappings(Item.func_150898_a((Block)block), food, diet);
        }
    }

    public int getBlockFoodAmount(Block block, EnumDiet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreBlockDiet == null || !this.carnivoreBlockDiet.containsKey(block)) break;
                return this.carnivoreBlockDiet.get(block);
            }
            case HERBIVORE: {
                if (this.herbivoreBlockDiet == null || !this.herbivoreBlockDiet.containsKey(block)) break;
                return this.herbivoreBlockDiet.get(block);
            }
            case OMNIVORE: {
                if (this.omnivoreBlockDiet == null || !this.omnivoreBlockDiet.containsKey(block)) break;
                return this.omnivoreBlockDiet.get(block);
            }
            case PISCIVORE: {
                if (this.piscivoreBlockDiet == null || !this.piscivoreBlockDiet.containsKey(block)) break;
                return this.piscivoreBlockDiet.get(block);
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggBlockDiet == null || !this.carnivoreEggBlockDiet.containsKey(block)) break;
                return this.carnivoreEggBlockDiet.get(block);
            }
            case INSECTIVORE: {
                if (this.insectivoreBlockDiet == null || !this.insectivoreBlockDiet.containsKey(block)) break;
                return this.insectivoreBlockDiet.get(block);
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreBlockDiet == null || !this.pisccarnivoreBlockDiet.containsKey(block)) break;
                return this.pisccarnivoreBlockDiet.get(block);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public void addToEntityMappings(Class<? extends Entity> entity, int food, EnumDiet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreEntityDiet == null) {
                    this.carnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.carnivoreEntityDiet.containsKey(entity)) break;
                this.carnivoreEntityDiet.put(entity, food);
                break;
            }
            case HERBIVORE: {
                if (this.herbivoreEntityDiet == null) {
                    this.herbivoreEntityDiet = Maps.newHashMap();
                }
                if (this.herbivoreEntityDiet.containsKey(entity)) break;
                this.herbivoreEntityDiet.put(entity, food);
                break;
            }
            case OMNIVORE: {
                if (this.omnivoreEntityDiet == null) {
                    this.omnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.omnivoreEntityDiet.containsKey(entity)) break;
                this.omnivoreEntityDiet.put(entity, food);
                break;
            }
            case PISCIVORE: {
                if (this.piscivoreEntityDiet == null) {
                    this.piscivoreEntityDiet = Maps.newHashMap();
                }
                if (this.piscivoreEntityDiet.containsKey(entity)) break;
                this.piscivoreEntityDiet.put(entity, food);
                break;
            }
            case CARNIVORE_EGG: {
                if (this.carnivore_eggEntityDiet == null) {
                    this.carnivore_eggEntityDiet = Maps.newHashMap();
                }
                if (this.carnivore_eggEntityDiet.containsKey(entity)) break;
                this.carnivore_eggEntityDiet.put(entity, food);
                break;
            }
            case INSECTIVORE: {
                if (this.insectivoreEntityDiet == null) {
                    this.insectivoreEntityDiet = Maps.newHashMap();
                }
                if (this.insectivoreEntityDiet.containsKey(entity)) break;
                this.insectivoreEntityDiet.put(entity, food);
                break;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreEntityDiet == null) {
                    this.pisccarnivoreEntityDiet = Maps.newHashMap();
                }
                if (this.pisccarnivoreEntityDiet.containsKey(entity)) break;
                this.pisccarnivoreEntityDiet.put(entity, food);
                break;
            }
        }
    }

    public int getEntityFoodAmount(Class<? extends Entity> entity, EnumDiet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreEntityDiet == null || !this.carnivoreEntityDiet.containsKey(entity)) break;
                return this.carnivoreEntityDiet.get(entity);
            }
            case HERBIVORE: {
                if (this.herbivoreEntityDiet == null || !this.herbivoreEntityDiet.containsKey(entity)) break;
                return this.herbivoreEntityDiet.get(entity);
            }
            case OMNIVORE: {
                if (this.omnivoreEntityDiet == null || !this.omnivoreEntityDiet.containsKey(entity)) break;
                return this.omnivoreEntityDiet.get(entity);
            }
            case PISCIVORE: {
                if (this.piscivoreEntityDiet == null || !this.piscivoreEntityDiet.containsKey(entity)) break;
                return this.piscivoreEntityDiet.get(entity);
            }
            case CARNIVORE_EGG: {
                if (this.carnivore_eggEntityDiet == null || !this.carnivore_eggEntityDiet.containsKey(entity)) break;
                return this.carnivore_eggEntityDiet.get(entity);
            }
            case INSECTIVORE: {
                if (this.insectivoreEntityDiet == null || !this.insectivoreEntityDiet.containsKey(entity)) break;
                return this.insectivoreEntityDiet.get(entity);
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreEntityDiet == null || !this.pisccarnivoreEntityDiet.containsKey(entity)) break;
                return this.pisccarnivoreEntityDiet.get(entity);
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public Map<Item, Integer> getFoodRenderList(EnumDiet diet) {
        switch (diet) {
            case CARNIVORE: {
                if (this.carnivoreItemDiet == null) {
                    this.carnivoreItemDiet = Maps.newHashMap();
                }
                return this.carnivoreItemDiet;
            }
            case HERBIVORE: {
                if (this.herbivoreItemDiet == null) {
                    this.herbivoreItemDiet = Maps.newHashMap();
                }
                return this.herbivoreItemDiet;
            }
            case OMNIVORE: {
                if (this.omnivoreItemDiet == null) {
                    this.omnivoreItemDiet = Maps.newHashMap();
                }
                return this.omnivoreItemDiet;
            }
            case PISCIVORE: {
                if (this.piscivoreItemDiet == null) {
                    this.piscivoreItemDiet = Maps.newHashMap();
                }
                return this.piscivoreItemDiet;
            }
            case CARNIVORE_EGG: {
                if (this.carnivoreEggItemDiet == null) {
                    this.carnivoreEggItemDiet = Maps.newHashMap();
                }
                return this.carnivoreEggItemDiet;
            }
            case INSECTIVORE: {
                if (this.insectivoreItemDiet == null) {
                    this.insectivoreItemDiet = Maps.newHashMap();
                }
                return this.insectivoreItemDiet;
            }
            case PISCCARNIVORE: {
                if (this.pisccarnivoreItemDiet == null) {
                    this.pisccarnivoreItemDiet = Maps.newHashMap();
                }
                return this.pisccarnivoreItemDiet;
            }
        }
        return this.carnivoreItemDiet;
    }

    public void removeItemMapping(Item item, EnumDiet diet) {
        this.getFoodRenderList(diet).remove(item);
    }

    public void addMeat(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, EnumDiet.CARNIVORE);
        this.addToEntityMappings(entity, food, EnumDiet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, EnumDiet.OMNIVORE);
        this.addToEntityMappings(entity, food, EnumDiet.PISCCARNIVORE);
    }

    public void addMeat(Block block, int food) {
        this.addToBlockMappings(block, food, EnumDiet.CARNIVORE, true);
        this.addToBlockMappings(block, food, EnumDiet.CARNIVORE_EGG, true);
        this.addToBlockMappings(block, food, EnumDiet.OMNIVORE, true);
        this.addToBlockMappings(block, food, EnumDiet.PISCCARNIVORE, true);
    }

    public void addMeat(Item item, int food) {
        this.addToItemMappings(item, food, EnumDiet.CARNIVORE);
        this.addToItemMappings(item, food, EnumDiet.CARNIVORE_EGG);
        this.addToItemMappings(item, food, EnumDiet.OMNIVORE);
        this.addToItemMappings(item, food, EnumDiet.PISCCARNIVORE);
    }

    public void addMeat(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.CARNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.CARNIVORE_EGG);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.OMNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.PISCCARNIVORE);
    }

    public void addPlant(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, EnumDiet.HERBIVORE);
        this.addToEntityMappings(entity, food, EnumDiet.OMNIVORE);
    }

    public void addPlant(Block block, int food) {
        this.addToBlockMappings(block, food, EnumDiet.HERBIVORE, true);
        this.addToBlockMappings(block, food, EnumDiet.OMNIVORE, true);
    }

    public void addPlant(Item item, int food) {
        this.addToItemMappings(item, food, EnumDiet.HERBIVORE);
        this.addToItemMappings(item, food, EnumDiet.OMNIVORE);
    }

    public void addPlant(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.HERBIVORE);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.OMNIVORE);
    }

    public void addFish(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, EnumDiet.PISCCARNIVORE);
        this.addToEntityMappings(entity, food, EnumDiet.PISCIVORE);
    }

    public void addFish(Block block, int food) {
        this.addToBlockMappings(block, food, EnumDiet.PISCCARNIVORE, true);
        this.addToBlockMappings(block, food, EnumDiet.PISCIVORE, true);
    }

    public void addFish(Item item, int food) {
        this.addToItemMappings(item, food, EnumDiet.PISCCARNIVORE);
        this.addToItemMappings(item, food, EnumDiet.PISCIVORE);
    }

    public void addFish(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.PISCCARNIVORE);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.PISCIVORE);
    }

    public void addEgg(Class<? extends Entity> entity, int food) {
        this.addToEntityMappings(entity, food, EnumDiet.CARNIVORE_EGG);
        this.addToEntityMappings(entity, food, EnumDiet.OMNIVORE);
    }

    public void addEgg(Block block, int food) {
        this.addToBlockMappings(block, food, EnumDiet.CARNIVORE_EGG, true);
        this.addToBlockMappings(block, food, EnumDiet.OMNIVORE, true);
    }

    public void addEgg(Item item, int food) {
        this.addToItemMappings(item, food, EnumDiet.CARNIVORE_EGG);
        this.addToItemMappings(item, food, EnumDiet.OMNIVORE);
    }

    public void addEgg(String ore_dictionary_name, int food) {
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.CARNIVORE_EGG);
        this.addOreDictionary(ore_dictionary_name, food, EnumDiet.OMNIVORE);
    }

    private void addOreDictionary(String dict_name, int food_value, EnumDiet diet) {
        List stacks = OreDictionary.getOres((String)dict_name);
        if (!stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                if (stack == null || stack.func_77973_b() == null) continue;
                if (stack.func_77973_b() instanceof ItemBlock) {
                    this.addToBlockMappings(((ItemBlock)stack.func_77973_b()).field_150939_a, food_value, diet, true);
                    continue;
                }
                this.addToItemMappings(stack.func_77973_b(), food_value, diet);
            }
        }
    }
}

