/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.blockbakery;

import codechicken.lib.internal.CCLLog;
import codechicken.lib.model.BakedModelProperties;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.PerspectiveAwareModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.model.bakedmodels.PerspectiveAwareLayeredModel;
import codechicken.lib.model.bakery.PlanarFaceBakery;
import codechicken.lib.model.blockbakery.BlockBakeryProperties;
import codechicken.lib.model.blockbakery.IBakeryBlock;
import codechicken.lib.model.blockbakery.IBakeryItem;
import codechicken.lib.model.blockbakery.IBlockStateKeyGenerator;
import codechicken.lib.model.blockbakery.ICustomBlockBakery;
import codechicken.lib.model.blockbakery.IItemBakery;
import codechicken.lib.model.blockbakery.IItemStackKeyGenerator;
import codechicken.lib.model.blockbakery.ILayeredBlockBakery;
import codechicken.lib.model.blockbakery.ISimpleBlockBakery;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.texture.IItemBlockTextureProvider;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockBakery
implements IResourceManagerReloadListener {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("ccl.debugBakeryLogging"));
    private static Cache<String, IBakedModel> keyModelCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static Map<Item, IItemStackKeyGenerator> itemKeyGeneratorMap = new HashMap<Item, IItemStackKeyGenerator>();
    private static Map<Block, IBlockStateKeyGenerator> blockKeyGeneratorMap = new HashMap<Block, IBlockStateKeyGenerator>();
    private static IBakedModel missingModel;
    public static final IBlockStateKeyGenerator defaultBlockKeyGenerator;
    public static final IItemStackKeyGenerator defaultItemKeyGenerator;

    public static void init() {
        TextureUtils.registerReloadListener(new BlockBakery());
        ModelRegistryHelper.registerCallback(new ModelRegistryHelper.IModelBakeCallback(){

            @Override
            public void onModelBake(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry) {
                missingModel = ModelLoaderRegistry.getMissingModel().bake((IModelState)TransformUtils.DEFAULT_BLOCK, DefaultVertexFormats.field_176599_b, TextureUtils.bakedTextureGetter);
            }
        });
    }

    public static IBlockStateKeyGenerator getKeyGenerator(Block block) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            return blockKeyGeneratorMap.get(block);
        }
        return defaultBlockKeyGenerator;
    }

    public static IItemStackKeyGenerator getKeyGenerator(Item item) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            return itemKeyGeneratorMap.get(item);
        }
        return defaultItemKeyGenerator;
    }

    public static void registerBlockKeyGenerator(Block block, IBlockStateKeyGenerator generator) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            throw new IllegalArgumentException("Unable to register IBlockStateKeyGenerator as one is already registered for block:" + block.getRegistryName());
        }
        blockKeyGeneratorMap.put(block, generator);
    }

    public static void registerItemKeyGenerator(Item item, IItemStackKeyGenerator generator) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            throw new IllegalArgumentException("Unable to register IItemStackKeyGenerator as one is already registered for item: " + item.getRegistryName());
        }
        itemKeyGeneratorMap.put(item, generator);
    }

    public static IBlockState handleExtendedState(IExtendedBlockState state, TileEntity tileEntity) {
        Block block = state.func_177230_c();
        if (block instanceof IBakeryBlock) {
            return ((IBakeryBlock)block).getCustomBakery().handleState(state, tileEntity);
        }
        if (block instanceof IWorldBlockTextureProvider) {
            IWorldBlockTextureProvider provider = (IWorldBlockTextureProvider)block;
            HashMap layerFaceSpriteMap = new HashMap();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!block.canRenderInLayer((IBlockState)state, layer)) continue;
                HashMap<EnumFacing, TextureAtlasSprite> faceSpriteMap = new HashMap<EnumFacing, TextureAtlasSprite>();
                if (tileEntity != null) {
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        TextureAtlasSprite sprite = provider.getTexture(face, (IBlockState)state, layer, (IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v());
                        if (sprite == null) continue;
                        faceSpriteMap.put(face, sprite);
                    }
                }
                layerFaceSpriteMap.put(layer, faceSpriteMap);
            }
            state = state.withProperty((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP, layerFaceSpriteMap);
        }
        return state;
    }

    public static IBakedModel getCachedItemModel(ItemStack stack) {
        IItemStackKeyGenerator generator = BlockBakery.getKeyGenerator(stack.func_77973_b());
        String key = generator.generateKey(stack);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null) {
            block5: {
                try {
                    model = BlockBakery.generateItemModel(stack);
                }
                catch (Throwable t) {
                    CCLLog.errorOnce(t, "ItemBaking", "Fatal exception thrown whilst baking item model for: " + stack, new Object[0]);
                    BakingVertexBuffer buffer = BakingVertexBuffer.create();
                    if (!buffer.field_179010_r) break block5;
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
            }
            if (DEBUG) {
                FMLLog.info((String)("Baking item model: " + key), (Object[])new Object[0]);
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateItemModel(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof IBakeryBlock) {
                ICustomBlockBakery bakery = ((IBakeryBlock)block).getCustomBakery();
                LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
                HashMap<EnumFacing, List<BakedQuad>> faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
                generalQuads.addAll(bakery.bakeItemQuads(null, stack));
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(PlanarFaceBakery.shadeQuadFaces(bakery.bakeItemQuads(face, stack)));
                    faceQuads.put(face, quads);
                }
                BakedModelProperties properties = new BakedModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuads, generalQuads, TransformUtils.DEFAULT_BLOCK, properties);
            }
            if (block instanceof IItemBlockTextureProvider) {
                IItemBlockTextureProvider provider = (IItemBlockTextureProvider)block;
                HashMap<EnumFacing, List<BakedQuad>> faceQuadMap = new HashMap<EnumFacing, List<BakedQuad>>();
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> faceQuads = new LinkedList<BakedQuad>();
                    faceQuads.addAll(PlanarFaceBakery.shadeQuadFaces(PlanarFaceBakery.bakeFace(face, provider.getTexture(face, stack), DefaultVertexFormats.field_176599_b)));
                    faceQuadMap.put(face, faceQuads);
                }
                BakedModelProperties properties = new BakedModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuadMap, (IModelState)TransformUtils.DEFAULT_BLOCK, properties);
            }
        } else if (item instanceof IBakeryItem) {
            IItemBakery bakery = ((IBakeryItem)item).getBakery();
            LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
            HashMap<EnumFacing, List<BakedQuad>> faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
            generalQuads.addAll(bakery.bakeItemQuads(null, stack));
            for (EnumFacing face : EnumFacing.field_82609_l) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.addAll(bakery.bakeItemQuads(face, stack));
                faceQuads.put(face, quads);
            }
            PerspectiveAwareModelProperties bakeryProperties = PerspectiveAwareModelProperties.DEFAULT_ITEM;
            try {
                bakeryProperties = bakery.getModelProperties(stack);
            }
            catch (Exception properties) {
                // empty catch block
            }
            BakedModelProperties properties = bakeryProperties.getProperties();
            return new PerspectiveAwareBakedModel(faceQuads, generalQuads, bakeryProperties.getModelState(), properties);
        }
        return missingModel;
    }

    public static IBakedModel getCachedModel(IExtendedBlockState state) {
        if (state == null) {
            return missingModel;
        }
        IBlockStateKeyGenerator keyGenerator = BlockBakery.getKeyGenerator(state.func_177230_c());
        String key = keyGenerator.generateKey(state);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null) {
            block6: {
                try {
                    model = BlockBakery.generateModel(state);
                }
                catch (Throwable t) {
                    CCLLog.errorOnce(t, "BlockBaking", "Fatal exception thrown whilst baking block model for: " + state, new Object[0]);
                    BakingVertexBuffer buffer = BakingVertexBuffer.create();
                    if (!buffer.field_179010_r) break block6;
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
            }
            if (DEBUG) {
                FMLLog.info((String)("Baking block model: " + key), (Object[])new Object[0]);
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateModel(IExtendedBlockState state) {
        if (state.func_177230_c() instanceof IBakeryBlock) {
            ICustomBlockBakery bakery = ((IBakeryBlock)state.func_177230_c()).getCustomBakery();
            if (bakery instanceof ISimpleBlockBakery) {
                ISimpleBlockBakery simpleBakery = (ISimpleBlockBakery)bakery;
                LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
                HashMap<EnumFacing, List<BakedQuad>> faceQuads = new HashMap<EnumFacing, List<BakedQuad>>();
                generalQuads.addAll(simpleBakery.bakeQuads(null, state));
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(simpleBakery.bakeQuads(face, state));
                    faceQuads.put(face, quads);
                }
                BakedModelProperties bakedModelProperties = new BakedModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuads, generalQuads, TransformUtils.DEFAULT_BLOCK, bakedModelProperties);
            }
            if (bakery instanceof ILayeredBlockBakery) {
                ILayeredBlockBakery layeredBakery = (ILayeredBlockBakery)bakery;
                HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = new HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>>();
                HashMap<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads = new HashMap<BlockRenderLayer, List<BakedQuad>>();
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer((IBlockState)state, layer)) continue;
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(layeredBakery.bakeLayerFace(null, layer, state));
                    layerGeneralQuads.put(layer, quads);
                }
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer((IBlockState)state, layer)) continue;
                    HashMap faceQuadMap = new HashMap();
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                        quads.addAll(layeredBakery.bakeLayerFace(face, layer, state));
                        faceQuadMap.put(face, quads);
                    }
                    layerFaceQuadMap.put(layer, faceQuadMap);
                }
                BakedModelProperties bakedModelProperties = new BakedModelProperties(true, true, null);
                return new PerspectiveAwareLayeredModel(layerFaceQuadMap, layerGeneralQuads, TransformUtils.DEFAULT_BLOCK, bakedModelProperties);
            }
        }
        if (state.func_177230_c() instanceof IWorldBlockTextureProvider) {
            Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = BlockBakery.generateLayerFaceQuadMap(state);
            BakedModelProperties properties = new BakedModelProperties(true, true, null);
            return new PerspectiveAwareLayeredModel(layerFaceQuadMap, TransformUtils.DEFAULT_BLOCK, properties);
        }
        return missingModel;
    }

    public static Map<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> generateLayerFaceQuadMap(IExtendedBlockState state) {
        Map layerFaceSpriteMap = (Map)state.getValue((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP);
        HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>> layerFaceQuadMap = new HashMap<BlockRenderLayer, Map<EnumFacing, List<BakedQuad>>>();
        for (BlockRenderLayer layer : layerFaceSpriteMap.keySet()) {
            Map faceSpriteMap = (Map)layerFaceSpriteMap.get(layer);
            HashMap faceQuadMap = new HashMap();
            for (EnumFacing face : faceSpriteMap.keySet()) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.add(PlanarFaceBakery.bakeFace(face, (TextureAtlasSprite)faceSpriteMap.get(face)));
                faceQuadMap.put(face, quads);
            }
            layerFaceQuadMap.put(layer, faceQuadMap);
        }
        return layerFaceQuadMap;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        BlockBakery.nukeModelCache();
    }

    public static void nukeModelCache() {
        keyModelCache.invalidateAll();
    }

    static {
        defaultBlockKeyGenerator = new IBlockStateKeyGenerator(){

            @Override
            public String generateKey(IExtendedBlockState state) {
                if (state.func_177230_c() instanceof IWorldBlockTextureProvider) {
                    Map layerFaceSpriteMap = (Map)state.getValue((IUnlistedProperty)BlockBakeryProperties.LAYER_FACE_SPRITE_MAP);
                    StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName() + ",");
                    for (Map.Entry layerEntry : layerFaceSpriteMap.entrySet()) {
                        builder.append(((BlockRenderLayer)layerEntry.getKey()).toString()).append(",");
                        for (Map.Entry faceSpriteEntry : ((Map)layerEntry.getValue()).entrySet()) {
                            builder.append(faceSpriteEntry.getKey()).append(",").append(((TextureAtlasSprite)faceSpriteEntry.getValue()).func_94215_i()).append(",");
                        }
                    }
                    return builder.toString();
                }
                return state.func_177230_c().getRegistryName().toString() + "|" + state.func_177230_c().func_176201_c((IBlockState)state);
            }
        };
        defaultItemKeyGenerator = new IItemStackKeyGenerator(){

            @Override
            public String generateKey(ItemStack stack) {
                return stack.func_77973_b().getRegistryName().toString() + "|" + stack.func_77960_j();
            }
        };
    }
}

