/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.blockstate;

import codechicken.lib.model.blockstate.CCFinalMultiVariant;
import codechicken.lib.model.blockstate.CCFinalVariant;
import codechicken.lib.model.blockstate.CCVariant;
import codechicken.lib.util.ArrayUtils;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.client.model.BlockStateLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.io.IOUtils;

public class CCBlockStateLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(CCVariant.class, (Object)new CCVariant.Deserializer()).create();

    public static ModelBlockDefinition handleLoad(Reader reader, Gson vanillaGSON) {
        try {
            String json = IOUtils.toString((Reader)reader);
            ModelBlockDefinition cclDef = CCBlockStateLoader.load(json);
            if (cclDef != null) {
                return cclDef;
            }
            return BlockStateLoader.load((Reader)new StringReader(json), (Gson)vanillaGSON);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static ModelBlockDefinition load(String json) {
        try {
            JsonParser parser = new JsonParser();
            JsonReader reader = new JsonReader((Reader)new StringReader(json));
            reader.setLenient(true);
            JsonObject object = parser.parse(reader).getAsJsonObject();
            if (JsonUtils.func_151204_g((JsonObject)object, (String)"ccl_marker")) {
                ArrayList<String> variantSets = new ArrayList<String>();
                for (JsonElement element : object.getAsJsonArray("variant_sets")) {
                    variantSets.add(element.getAsString());
                }
                String textureDomain = "";
                if (object.has("texture_domain")) {
                    textureDomain = object.get("texture_domain").getAsString();
                }
                CCVariant defaultVariant = null;
                if (object.has("defaults")) {
                    defaultVariant = (CCVariant)GSON.fromJson(object.get("defaults"), CCVariant.class);
                }
                Map<String, Map<String, CCVariant>> variants = CCBlockStateLoader.parseVariants(object.getAsJsonObject("variants"));
                Map<String, Map<String, Map<String, CCVariant>>> subModels = CCBlockStateLoader.parseSubModels(object.getAsJsonObject("sub_model"));
                LinkedHashMap<String, CCVariant> compiledVariants = new LinkedHashMap<String, CCVariant>();
                LinkedHashMap<String, Map<String, CCVariant>> compiledSubModelVariants = new LinkedHashMap<String, Map<String, CCVariant>>();
                ArrayList<String> possibleCombos = new ArrayList<String>();
                for (String string : variantSets) {
                    Map<String, List<String>> variantValueMap = CCBlockStateLoader.generateVariantValueMap(Arrays.asList(string.split(",")), variants, subModels);
                    possibleCombos.addAll(CCBlockStateLoader.generatePossibleCombos(variantValueMap));
                }
                for (String string : possibleCombos) {
                    Map<String, String> kvArray = ArrayUtils.convertKeyValueArrayToMap(string.split(","));
                    Object finalVariant = new CCVariant();
                    if (defaultVariant != null) {
                        finalVariant = defaultVariant.copy();
                    }
                    compiledVariants.put(string, CCBlockStateLoader.compileVariant(((CCVariant)finalVariant).copy(), kvArray, variants));
                }
                for (Map.Entry entry : subModels.entrySet()) {
                    LinkedHashMap<String, CCVariant> compiledVariants2 = new LinkedHashMap<String, CCVariant>();
                    for (String var : possibleCombos) {
                        Map<String, String> kvArray = ArrayUtils.convertKeyValueArrayToMap(var.split(","));
                        CCVariant finalVariant = new CCVariant();
                        if (defaultVariant != null) {
                            finalVariant = defaultVariant.copy();
                        }
                        compiledVariants2.put(var, CCBlockStateLoader.compileVariant(finalVariant.copy(), kvArray, (Map)entry.getValue()));
                    }
                    compiledSubModelVariants.put((String)entry.getKey(), (Map<String, CCVariant>)compiledVariants2);
                }
                HashMap variantList = new HashMap();
                for (Map.Entry entry : compiledVariants.entrySet()) {
                    Map<String, CCVariant> subModelVariants = CCBlockStateLoader.getSubModelsForKey((String)entry.getKey(), compiledSubModelVariants);
                    ArrayList<Variant> vars = new ArrayList<Variant>();
                    CCVariant variant = (CCVariant)entry.getValue();
                    boolean uvLock = (Boolean)variant.uvLock.or((Object)false);
                    boolean smooth = (Boolean)variant.smooth.or((Object)true);
                    boolean gui3d = (Boolean)variant.gui3d.or((Object)true);
                    int weight = (Integer)variant.weight.or((Object)1);
                    if (variant.model != null && subModelVariants.size() == 0 && variant.textures.size() == 0 && variant.customData.size() == 0 && variant.state.orNull() instanceof ModelRotation) {
                        vars.add(new Variant(variant.model, (ModelRotation)variant.state.get(), uvLock, weight));
                    } else if (subModelVariants.size() == 0) {
                        vars.add(new CCFinalVariant(variant.model, (IModelState)variant.state.or((Object)TRSRTransformation.identity()), uvLock, smooth, gui3d, weight, variant.textures, textureDomain, variant.customData));
                    } else {
                        vars.add(new CCFinalMultiVariant(variant, textureDomain, subModelVariants));
                    }
                    variantList.put(entry.getKey(), new VariantList(vars));
                }
                return new ModelBlockDefinition(variantList, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwables.propagate((Throwable)e);
        }
        return null;
    }

    public static Map<String, Map<String, CCVariant>> parseVariants(JsonObject variantElement) {
        LinkedHashMap<String, Map<String, CCVariant>> variants = new LinkedHashMap<String, Map<String, CCVariant>>();
        for (Map.Entry variantsEntry : variantElement.entrySet()) {
            String variantName = (String)variantsEntry.getKey();
            LinkedHashMap<String, CCVariant> variantValues = (LinkedHashMap<String, CCVariant>)variants.get(variantName);
            if (variantValues == null) {
                variantValues = new LinkedHashMap<String, CCVariant>();
                variants.put(variantName, variantValues);
            }
            for (Map.Entry variantEntry : ((JsonElement)variantsEntry.getValue()).getAsJsonObject().entrySet()) {
                String variantValue = (String)variantEntry.getKey();
                CCVariant variant = (CCVariant)GSON.fromJson((JsonElement)variantEntry.getValue(), CCVariant.class);
                variantValues.put(variantValue, variant);
            }
        }
        return variants;
    }

    public static Map<String, Map<String, Map<String, CCVariant>>> parseSubModels(JsonObject object) {
        LinkedHashMap<String, Map<String, Map<String, CCVariant>>> subModels = new LinkedHashMap<String, Map<String, Map<String, CCVariant>>>();
        if (object != null) {
            for (Map.Entry subModelEntry : object.entrySet()) {
                subModels.put((String)subModelEntry.getKey(), CCBlockStateLoader.parseVariants(((JsonElement)subModelEntry.getValue()).getAsJsonObject().getAsJsonObject("variants")));
            }
        }
        return subModels;
    }

    public static CCVariant compileVariant(CCVariant finalVariant, Map<String, String> kvArray, Map<String, Map<String, CCVariant>> variants) {
        Map<String, CCVariant> variantMap;
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : variants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = finalVariant.with(variantMap.get(entry.getValue()));
            }
        }
        for (Map.Entry<String, String> entry : kvArray.entrySet()) {
            for (Map.Entry<String, Map<String, CCVariant>> variantsEntry : variants.entrySet()) {
                if (!entry.getKey().equals(variantsEntry.getKey()) || !(variantMap = variantsEntry.getValue()).containsKey(entry.getValue())) continue;
                finalVariant = variantMap.get(entry.getValue()).applySubOverrides(finalVariant, kvArray);
            }
        }
        return finalVariant;
    }

    public static Map<String, CCVariant> getSubModelsForKey(String key, Map<String, Map<String, CCVariant>> subModels) {
        LinkedHashMap<String, CCVariant> subModelVariants = new LinkedHashMap<String, CCVariant>();
        for (Map.Entry<String, Map<String, CCVariant>> subModelEntry : subModels.entrySet()) {
            for (Map.Entry<String, CCVariant> variantEntry : subModelEntry.getValue().entrySet()) {
                if (!variantEntry.getKey().equals(key)) continue;
                subModelVariants.put(subModelEntry.getKey(), variantEntry.getValue());
            }
        }
        return subModelVariants;
    }

    public static List<String> generatePossibleCombos(Map<String, List<String>> variantValueMap) {
        ArrayList<String> possibleCombos = new ArrayList<String>();
        ArrayList keys = Lists.newArrayList(variantValueMap.keySet());
        int comboCount = 1;
        for (String key : variantValueMap.keySet()) {
            comboCount *= variantValueMap.get(key).size();
        }
        int[] indexes = new int[variantValueMap.size()];
        for (int l = 0; l < comboCount; ++l) {
            for (int in = 0; in < indexes.length; ++in) {
                int n = in;
                indexes[n] = indexes[n] + 1;
                if (indexes[in] < variantValueMap.get(keys.get(in)).size()) break;
                indexes[in] = 0;
            }
            String combo = "";
            for (int i = 0; i < indexes.length; ++i) {
                combo = combo + (String)keys.get(i) + "=" + variantValueMap.get(keys.get(i)).get(indexes[i]) + ",";
            }
            possibleCombos.add(combo.substring(0, combo.length() - 1));
        }
        return possibleCombos;
    }

    public static Map<String, List<String>> generateVariantValueMap(List<String> keys, Map<String, Map<String, CCVariant>> variants, Map<String, Map<String, Map<String, CCVariant>>> subModels) {
        LinkedHashMap<String, List<String>> variantValueMap = new LinkedHashMap<String, List<String>>();
        for (String variant : keys) {
            ArrayList<String> variantValues = new ArrayList<String>();
            for (String string : variants.keySet()) {
                if (string.equals(variant) && variants.containsKey(variant)) {
                    variantValues.addAll(variants.get(variant).keySet());
                }
                for (CCVariant subVariant : variants.get(string).values()) {
                    variantValues.addAll(subVariant.getPossibleVariantValues(variant));
                }
            }
            for (Map map : subModels.values()) {
                for (String variantName : map.keySet()) {
                    if (variantName.equals(variant) && map.containsKey(variant)) {
                        variantValues.addAll(((Map)map.get(variant)).keySet());
                    }
                    for (CCVariant subVariant : ((Map)map.get(variantName)).values()) {
                        variantValues.addAll(subVariant.getPossibleVariantValues(variant));
                    }
                }
            }
            variantValueMap.put(variant, variantValues);
        }
        return variantValueMap;
    }
}

