/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.internal.CCLLog;
import codechicken.lib.texture.PlaceholderTexture;
import codechicken.lib.texture.TextureDataHolder;
import codechicken.lib.texture.TextureSpecial;
import com.google.common.base.Function;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static ArrayList<IIconRegister> iconRegisters;
    public static Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

    public static void addIconRegister(IIconRegister registrar) {
        iconRegisters.add(registrar);
    }

    public static void registerReloadListener(IResourceManagerReloadListener reloadListener) {
        TextureUtils.getResourceManager().func_110542_a(reloadListener);
    }

    @SubscribeEvent
    public void textureLoad(TextureStitchEvent.Pre event) {
        if (!event.getMap().getBasePath().equals("textures")) {
            CCLLog.log(Level.WARN, "Someone is calling the TextureStitchEvent.Pre for a texture map that is NOT vanillas.");
            CCLLog.log(Level.WARN, "This is a bug. There is no sense of different atlas's in vanilla so this event is NOT generic and is specific to the vanilla atlas.");
            CCLLog.log(Level.WARN, "Im catching this so things don't explode. Fix your shit!");
            CCLLog.big(Level.WARN, 100, "", new Object[0]);
            return;
        }
        for (IIconRegister reg : iconRegisters) {
            reg.registerIcons(event.getMap());
        }
    }

    public static int[] loadTextureData(ResourceLocation resource) {
        return TextureUtils.loadTexture((ResourceLocation)resource).data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static InputStream getTextureResource(ResourceLocation textureFile) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(textureFile).func_110527_b();
    }

    public static BufferedImage loadBufferedImage(ResourceLocation textureFile) {
        try {
            return TextureUtils.loadBufferedImage(TextureUtils.getTextureResource(textureFile));
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static TextureAtlasSprite getBlankIcon(int size, TextureMap textureMap) {
        String s = "blank_" + size;
        TextureAtlasSprite icon = textureMap.getTextureExtry(s);
        if (icon == null) {
            icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, icon);
        }
        return icon;
    }

    public static TextureSpecial getTextureSpecial(TextureMap textureMap, String name) {
        if (textureMap.getTextureExtry(name) != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (TextureAtlasSprite)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GlStateManager.func_187421_b((int)target, (int)10241, (int)min_mag_filter);
        GlStateManager.func_187421_b((int)target, (int)10240, (int)min_mag_filter);
        if (target == 3553) {
            GlStateManager.func_179144_i((int)target);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
        switch (target) {
            case 32879: {
                GlStateManager.func_187421_b((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GlStateManager.func_187421_b((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GlStateManager.func_187421_b((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureDataHolder loadTexture(ResourceLocation resource) {
        BufferedImage img = TextureUtils.loadBufferedImage(resource);
        if (img == null) {
            throw new RuntimeException("Texture not found: " + resource);
        }
        return new TextureDataHolder(img);
    }

    public static boolean refreshTexture(TextureMap map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (TextureAtlasSprite)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static TextureManager getTextureManager() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static TextureMap getTextureMap() {
        return Minecraft.func_71410_x().func_147117_R();
    }

    public static IReloadableResourceManager getResourceManager() {
        return (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
    }

    public static TextureAtlasSprite getMissingSprite() {
        return TextureUtils.getTextureMap().func_174944_f();
    }

    public static TextureAtlasSprite getTexture(String location) {
        return TextureUtils.getTextureMap().func_110572_b(location);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return TextureUtils.getTexture(location.toString());
    }

    public static TextureAtlasSprite getBlockTexture(String string) {
        return TextureUtils.getBlockTexture(new ResourceLocation(string));
    }

    public static TextureAtlasSprite getBlockTexture(ResourceLocation location) {
        return TextureUtils.getTexture(new ResourceLocation(location.func_110624_b(), "blocks/" + location.func_110623_a()));
    }

    public static TextureAtlasSprite getItemTexture(String string) {
        return TextureUtils.getItemTexture(new ResourceLocation(string));
    }

    public static TextureAtlasSprite getItemTexture(ResourceLocation location) {
        return TextureUtils.getTexture(new ResourceLocation(location.func_110624_b(), "items/" + location.func_110623_a()));
    }

    public static IResource getResource(String location) throws IOException {
        return TextureUtils.getResource(new ResourceLocation(location));
    }

    public static IResource getResource(ResourceLocation location) throws IOException {
        return TextureUtils.getResourceManager().func_110536_a(location);
    }

    public static void changeTexture(String texture) {
        TextureUtils.changeTexture(new ResourceLocation(texture));
    }

    public static void changeTexture(ResourceLocation texture) {
        TextureUtils.getTextureManager().func_110577_a(texture);
    }

    public static void disableMipmap(String texture) {
        TextureUtils.disableMipmap(new ResourceLocation(texture));
    }

    public static void disableMipmap(ResourceLocation texture) {
        TextureUtils.getTextureManager().func_110581_b(texture).func_174936_b(false, false);
    }

    public static void restoreLastMipmap(String texture) {
        TextureUtils.restoreLastMipmap(new ResourceLocation(texture));
    }

    public static void restoreLastMipmap(ResourceLocation location) {
        TextureUtils.getTextureManager().func_110581_b(location).func_174935_a();
    }

    public static void bindBlockTexture() {
        TextureUtils.changeTexture(TextureMap.field_110575_b);
    }

    public static void dissableBlockMipmap() {
        TextureUtils.disableMipmap(TextureMap.field_110575_b);
    }

    public static void restoreBlockMipmap() {
        TextureUtils.restoreLastMipmap(TextureMap.field_110575_b);
    }

    public static TextureAtlasSprite[] getSideIconsForBlock(IBlockState state) {
        TextureAtlasSprite[] sideSprites = new TextureAtlasSprite[6];
        TextureAtlasSprite missingSprite = TextureUtils.getMissingSprite();
        for (int i = 0; i < 6; ++i) {
            TextureAtlasSprite[] sprites = TextureUtils.getIconsForBlock(state, i);
            TextureAtlasSprite sideSprite = missingSprite;
            if (sprites.length != 0) {
                sideSprite = sprites[0];
            }
            sideSprites[i] = sideSprite;
        }
        return sideSprites;
    }

    public static TextureAtlasSprite[] getIconsForBlock(IBlockState state, int side) {
        return TextureUtils.getIconsForBlock(state, EnumFacing.values()[side]);
    }

    public static TextureAtlasSprite[] getIconsForBlock(IBlockState state, EnumFacing side) {
        List quads;
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model != null && (quads = model.func_188616_a(state, side, 0L)) != null && quads.size() > 0) {
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[quads.size()];
            for (int i = 0; i < quads.size(); ++i) {
                sprites[i] = ((BakedQuad)quads.get(i)).func_187508_a();
            }
            return sprites;
        }
        return new TextureAtlasSprite[0];
    }

    public static TextureAtlasSprite getParticleIconForBlock(IBlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model != null) {
            return model.func_177554_e();
        }
        return null;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        iconRegisters = new ArrayList();
        bakedTextureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return TextureUtils.getTexture(input);
            }
        };
    }

    public static interface IIconRegister {
        @SideOnly(value=Side.CLIENT)
        public void registerIcons(TextureMap var1);
    }
}

