/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.api.util;

import com.google.common.collect.Maps;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.custom_hash.TObjectLongCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.RegionCache;

@ParametersAreNonnullByDefault
public class RenderContextList {
    private final Map<ICTMTexture<?>, ITextureContext> contextMap = Maps.newIdentityHashMap();
    private final TObjectLongMap<ICTMTexture<?>> serialized = new TObjectLongCustomHashMap((HashingStrategy)new IdentityHashingStrategy());

    public RenderContextList(IBlockState state, Collection<ICTMTexture<?>> textures, IBlockAccess world, BlockPos pos) {
        world = new RegionCache(pos, 2, world);
        for (ICTMTexture<?> iCTMTexture : textures) {
            Object type = iCTMTexture.getType();
            ITextureContext ctx = type.getBlockRenderContext(state, world, pos, iCTMTexture);
            if (ctx == null) continue;
            this.contextMap.put(iCTMTexture, ctx);
        }
        for (Map.Entry entry : this.contextMap.entrySet()) {
            this.serialized.put(entry.getKey(), ((ITextureContext)entry.getValue()).getCompressedData());
        }
    }

    @Nullable
    public ITextureContext getRenderContext(ICTMTexture<?> tex) {
        return this.contextMap.get(tex);
    }

    public boolean contains(ICTMTexture<?> tex) {
        return this.getRenderContext(tex) != null;
    }

    public TObjectLongMap<ICTMTexture<?>> serialized() {
        return this.serialized;
    }
}

