/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.ArsMagica2;
import am2.LogHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class AMChunkLoader
implements ForgeChunkManager.LoadingCallback {
    public static final AMChunkLoader INSTANCE = new AMChunkLoader();
    private HashMap<TicketIdentifier, ForgeChunkManager.Ticket> tickets = new HashMap();

    private AMChunkLoader() {
    }

    private ForgeChunkManager.Ticket requestTicket(BlockPos pos, World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)ArsMagica2.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            this.cacheTicket(new TicketIdentifier(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension()), ticket);
            return ticket;
        }
        return null;
    }

    private void cacheTicket(TicketIdentifier identifier, ForgeChunkManager.Ticket ticket) {
        if (this.tickets.containsKey(identifier)) {
            LogHelper.warn("Attempted to register duplicate tickets for the same world - this shouldn't really happen.", new Object[0]);
            return;
        }
        this.tickets.put(identifier, ticket);
    }

    private ForgeChunkManager.Ticket getTicket(TicketIdentifier identifier) {
        return this.tickets.get(identifier);
    }

    public void requestStaticChunkLoad(Class<?> clazz, BlockPos pos, World world) {
        ForgeChunkManager.Ticket ticket = this.requestTicket(pos, world);
        if (ticket == null) {
            LogHelper.warn("Unable to get a ticket for chunk loading!  The chunk identified by %d, %d is *not* loaded!", pos.func_177958_n(), pos.func_177952_p());
            return;
        }
        NBTTagCompound compound = ticket.getModData();
        compound.func_74783_a("StaticLoadCoords", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        compound.func_74778_a("ChunkLoadClass", clazz.getName());
        ChunkPos pair = new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pair);
    }

    public void releaseStaticChunkLoad(Class<?> clazz, BlockPos pos, World world) {
        ForgeChunkManager.Ticket ticket = this.getTicket(new TicketIdentifier(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world.field_73011_w.getDimension()));
        if (ticket == null) {
            LogHelper.warn("No ticket for specified location.  No chunk to unload!", new Object[0]);
            return;
        }
        ChunkPos pair = new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pair);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound compound = ticket.getModData();
            int[] coords = compound.func_74759_k("StaticLoadCoords");
            String clazzName = compound.func_74779_i("ChunkLoadClass");
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                LogHelper.info("Cached class not found (%s) when attempting to load a chunk loading ticket.  This ticket will be discarded, and the chunk may not be loaded.  Block Coords: %d, %d", clazzName, coords[0], coords[2]);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                continue;
            }
            TileEntity te = world.func_175625_s(new BlockPos(coords[0], coords[1], coords[2]));
            if (te != null && te.getClass().isAssignableFrom(clazz)) {
                ChunkPos pair = new ChunkPos(coords[0] >> 4, coords[2] >> 4);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pair);
                continue;
            }
            LogHelper.info("Either no tile entity was found or it did not match the cached class.  This chunk loading ticket will be discarded, and the chunk may not be loaded.  Block Coords: %d, %d", coords[0], coords[2]);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    private class TicketIdentifier
    implements Comparable<TicketIdentifier> {
        public final int dimension;
        public final int x;
        public final int y;
        public final int z;

        public TicketIdentifier(int x, int y, int z, int dimension) {
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public int compareTo(TicketIdentifier o) {
            if (o.x == this.x && o.y == this.y && o.z == this.z && o.dimension == this.dimension) {
                return 0;
            }
            return -1;
        }
    }
}

