/*
 * Decompiled with CFR 0.152.
 */
package am2.affinity;

import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class AffinityAbilityModifiers {
    public static AffinityAbilityModifiers instance = new AffinityAbilityModifiers();
    public static final int OPERATION_ADD = 2;
    public static final int OPERATION_MULTIPLY = 0;
    public static final int OPERATION_DIVIDE = 1;
    public static final UUID natureAffinityModifierID = UUID.fromString("d0a02b30-c830-11e3-9c1a-0800200c9a66");
    public static final AttributeModifier natureAffinityRoots = new AttributeModifier(natureAffinityModifierID, "Nature's Roots", -0.1, 2);
    public static final UUID iceAffinityodifierID = UUID.fromString("d0a02b30-c830-11e3-9c1a-0800200c9a65");
    public static final AttributeModifier iceAffinityColdBlooded = new AttributeModifier(iceAffinityodifierID, "Cold Blooded", -0.1, 2);
    public static final UUID lightningAffinityModifierID = UUID.fromString("3b51a94c-8866-470b-8b69-e1d5cb50a61f");
    public static final AttributeModifier lightningAffinitySpeed = new AttributeModifier(lightningAffinityModifierID, "Lightning Reflexes", 1.2, 2);
    public static final UUID waterWeaknessID = UUID.fromString("3b51a94c-7844-732b-8b69-a1f5cd50a60f");
    public static final AttributeModifier waterWeakness = new AttributeModifier(waterWeaknessID, "Water Weakness", -0.25, 2);
    public static final UUID fireWeaknessID = UUID.fromString("3b51a94c-7844-732b-8b69-a1f5cd50a60e");
    public static final AttributeModifier fireWeakness = new AttributeModifier(fireWeaknessID, "Fire Weakness", -0.25, 2);
    public static final UUID sunlightWeaknessID = UUID.fromString("3b51a94c-7844-732b-8b69-a1f5cd50a60d");
    public static final AttributeModifier sunlightWeakness = new AttributeModifier(sunlightWeaknessID, "Sunlight Weakness", -0.25, 2);

    public void applySpeedModifiersBasedOnDepth(EntityPlayer ent, float natureDepth, float iceDepth, float lightningDepth) {
        IAttributeInstance attribute = ent.func_110148_a(SharedMonsterAttributes.field_111263_d);
        this.applyOrRemoveModifier(attribute, natureAffinityRoots, natureDepth >= 0.5f);
        this.applyOrRemoveModifier(attribute, lightningAffinitySpeed, lightningDepth >= 0.65f);
        this.applyOrRemoveModifier(attribute, iceAffinityColdBlooded, iceDepth >= 0.1f && !this.isOnIce(ent));
    }

    public void applyHealthModifiers(EntityPlayer ent, float enderDepth, float waterDepth, float fireDepth, float lightningDepth) {
        IAttributeInstance attribute = ent.func_110148_a(SharedMonsterAttributes.field_111267_a);
        this.applyOrRemoveModifier(attribute, waterWeakness, (fireDepth >= 0.5f && fireDepth <= 0.9f || enderDepth >= 0.5f && enderDepth <= 0.9f || lightningDepth >= 0.5f && lightningDepth <= 0.9f) && ent.func_70026_G());
        this.applyOrRemoveModifier(attribute, fireWeakness, waterDepth >= 0.5f && waterDepth <= 0.9f && (ent.func_70027_ad() || ent.field_70170_p.field_73011_w.getDimension() == -1));
        int worldTime = (int)ent.field_70170_p.func_72820_D() % 24000;
        this.applyOrRemoveModifier(attribute, sunlightWeakness, (double)enderDepth > 0.65 && enderDepth <= 0.95f && ent.field_70170_p.func_175710_j(ent.func_180425_c()) && (worldTime > 23000 || worldTime < 12500));
    }

    public void applyOrRemoveModifier(IAttributeInstance attribute, AttributeModifier modifier, boolean tryApply) {
        if (tryApply) {
            if (attribute.func_111127_a(modifier.func_111167_a()) == null) {
                attribute.func_111121_a(modifier);
            }
        } else if (attribute.func_111127_a(modifier.func_111167_a()) != null) {
            attribute.func_111124_b(modifier);
        }
    }

    public boolean isOnIce(EntityPlayer ent) {
        AxisAlignedBB par1AxisAlignedBB = ent.func_174813_aQ().func_72314_b(0.0, (double)-0.4f, 0.0).func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72338_b - 1.0));
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0));
        boolean isOnIce = false;
        for (int k1 = i; k1 < j && !isOnIce; ++k1) {
            for (int l1 = k; l1 < l && !isOnIce; ++l1) {
                for (int i2 = i1; i2 < j1 && !isOnIce; ++i2) {
                    Material block = ent.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_185904_a();
                    if (block != Material.field_151588_w && block != Material.field_151598_x) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

