/*
 * Decompiled with CFR 0.152.
 */
package am2.affinity.abilities;

import am2.ArsMagica2;
import am2.api.affinity.AbstractAffinityAbility;
import am2.api.affinity.Affinity;
import am2.defs.BindingsDefs;
import am2.extensions.AffinityData;
import am2.extensions.EntityExtension;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityRelocation
extends AbstractAffinityAbility {
    public AbilityRelocation() {
        super(new ResourceLocation("arsmagica2", "relocation"));
    }

    @Override
    public float getMinimumDepth() {
        return 0.75f;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ENDER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public KeyBinding getKey() {
        return BindingsDefs.ENDER_TP;
    }

    @Override
    public boolean canApply(EntityPlayer player) {
        return super.canApply(player);
    }

    @Override
    public void applyKeyPress(EntityPlayer player) {
        EnderTeleportEvent event;
        if (AffinityData.For((EntityLivingBase)player).getCooldown("EnderTP") > 0) {
            if (player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.chat.relocation_cooldown")));
            }
            return;
        }
        Vec3d playerPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        RayTraceResult result = player.field_70170_p.func_72933_a(playerPos, playerPos.func_178787_e(new Vec3d(player.func_70040_Z().field_72450_a * 32.0, player.func_70040_Z().field_72448_b * 32.0, player.func_70040_Z().field_72449_c * 32.0)));
        if (result == null) {
            result = new RayTraceResult(playerPos.func_178787_e(new Vec3d(player.func_70040_Z().field_72450_a * 32.0, player.func_70040_Z().field_72448_b * 32.0, player.func_70040_Z().field_72449_c * 32.0)), null);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)player, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 0.0f)))) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.chat.relocation_failed")));
            }
            return;
        }
        double posY = event.getTargetY();
        while (!player.field_70170_p.func_175623_d(new BlockPos(event.getTargetX(), posY, event.getTargetZ())) || !player.field_70170_p.func_175623_d(new BlockPos(event.getTargetX(), posY + 1.0, event.getTargetZ()))) {
            posY += 1.0;
        }
        if (player.func_70092_e(event.getTargetX(), posY, event.getTargetZ()) > 1024.0) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.chat.relocation_out_of_range")));
            }
            return;
        }
        player.func_70634_a(event.getTargetX(), posY, event.getTargetZ());
        player.field_70143_R = 0.0f;
        EntityExtension.For((EntityLivingBase)player).setFallProtection(20000.0f);
        AffinityData.For((EntityLivingBase)player).addCooldown("EnderTP", ArsMagica2.config.getEnderAffinityAbilityCooldown());
    }
}

