/*
 * Decompiled with CFR 0.152.
 */
package am2.api;

import am2.api.affinity.AbstractAffinityAbility;
import am2.api.affinity.Affinity;
import am2.api.flickers.AbstractFlickerFunctionality;
import am2.api.items.armor.ArmorImbuement;
import am2.api.skill.Skill;
import am2.api.spell.AbstractSpellPart;
import com.google.common.collect.BiMap;
import java.util.Map;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;

public class ArsMagicaAPI {
    private static final IForgeRegistry<Affinity> AFFINITY_REGISTRY;
    private static final IForgeRegistry<AbstractAffinityAbility> ABILITY_REGISTRY;
    private static final IForgeRegistry<ArmorImbuement> IMBUEMENTS_REGISTRY;
    private static final IForgeRegistry<AbstractSpellPart> SPELL_REGISTRY;
    private static final IForgeRegistry<Skill> SKILL_REGISTRY;
    private static final IForgeRegistry<AbstractFlickerFunctionality> FLICKER_FOCUS_REGISTRY;
    private static boolean enableTier4;
    private static boolean enableTier5;
    private static boolean enableTier6;
    public static final IAttribute maxManaBonus;
    public static final IAttribute maxBurnoutBonus;
    public static final IAttribute xpGainModifier;
    public static final IAttribute manaRegenTimeModifier;
    public static final IAttribute burnoutReductionRate;

    public static FMLControlledNamespacedRegistry<Affinity> getAffinityRegistry() {
        return (FMLControlledNamespacedRegistry)AFFINITY_REGISTRY;
    }

    public static FMLControlledNamespacedRegistry<AbstractAffinityAbility> getAffinityAbilityRegistry() {
        return (FMLControlledNamespacedRegistry)ABILITY_REGISTRY;
    }

    public static FMLControlledNamespacedRegistry<ArmorImbuement> getArmorImbuementRegistry() {
        return (FMLControlledNamespacedRegistry)IMBUEMENTS_REGISTRY;
    }

    public static FMLControlledNamespacedRegistry<AbstractSpellPart> getSpellRegistry() {
        return (FMLControlledNamespacedRegistry)SPELL_REGISTRY;
    }

    public static FMLControlledNamespacedRegistry<Skill> getSkillRegistry() {
        return (FMLControlledNamespacedRegistry)SKILL_REGISTRY;
    }

    public static FMLControlledNamespacedRegistry<AbstractFlickerFunctionality> getFlickerFocusRegistry() {
        return (FMLControlledNamespacedRegistry)FLICKER_FOCUS_REGISTRY;
    }

    public static void enableTier4() {
        enableTier4 = true;
    }

    public static boolean hasTier4() {
        return enableTier4 || ArsMagicaAPI.hasTier5();
    }

    public static void enableTier5() {
        enableTier5 = true;
    }

    public static boolean hasTier5() {
        return enableTier5 || ArsMagicaAPI.hasTier6();
    }

    public static void enableTier6() {
        enableTier6 = true;
    }

    public static boolean hasTier6() {
        return enableTier6;
    }

    public static String getCurrentModId() {
        ModContainer current = Loader.instance().activeModContainer();
        String modid = "arsmagica2";
        if (current != null) {
            modid = current.getModId();
        }
        return modid;
    }

    static {
        enableTier4 = false;
        enableTier5 = false;
        enableTier6 = false;
        AFFINITY_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "affinities")).setType(Affinity.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.AFFINITY).create();
        ABILITY_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "affinityabilities")).setType(AbstractAffinityAbility.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.AFFINITY).create();
        IMBUEMENTS_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "armorimbuments")).setType(ArmorImbuement.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.IMBUEMENT).create();
        SPELL_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "spells")).setType(AbstractSpellPart.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.SPELL).create();
        SKILL_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "skills")).setType(Skill.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.SKILL).create();
        FLICKER_FOCUS_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("arsmagica2", "flicker_focus")).setType(AbstractFlickerFunctionality.class).setIDRange(0, Short.MAX_VALUE).addCallback(ObjectCallbacks.FLICKER_FOCUS).create();
        maxManaBonus = new RangedAttribute(null, "am2.maxManaBonus", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Mana Bonus").func_111112_a(true);
        maxBurnoutBonus = new RangedAttribute(null, "am2.maxBurnoutBonus", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Burnout Bonus").func_111112_a(true);
        xpGainModifier = new RangedAttribute(null, "am2.xpMultiplier", 1.0, 0.0, Double.MAX_VALUE).func_111117_a("XP Mutiplier").func_111112_a(true);
        manaRegenTimeModifier = new RangedAttribute(null, "am2.manaRegenModifier", 1.0, 0.5, 2.0).func_111117_a("Mana Regen Rate Multiplier").func_111112_a(true);
        burnoutReductionRate = new RangedAttribute(null, "am2.burnoutReduction", 1.0, (double)0.1f, 2.0).func_111117_a("Burnout Reduction Rate").func_111112_a(true);
    }

    public static class SpellCallbacks
    extends ObjectCallbacks<AbstractSpellPart> {
        @Override
        public void onAdd(AbstractSpellPart ability, int id, Map<ResourceLocation, ?> slaves) {
        }
    }

    public static class ObjectCallbacks<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistry.AddCallback<T>,
    IForgeRegistry.ClearCallback<T>,
    IForgeRegistry.CreateCallback<T> {
        static final ObjectCallbacks<AbstractSpellPart> SPELL = new SpellCallbacks();
        static final ObjectCallbacks<AbstractAffinityAbility> ABILITY = new ObjectCallbacks();
        static final ObjectCallbacks<Affinity> AFFINITY = new ObjectCallbacks();
        static final ObjectCallbacks<ArmorImbuement> IMBUEMENT = new ObjectCallbacks();
        static final ObjectCallbacks<Skill> SKILL = new ObjectCallbacks();
        static final ObjectCallbacks<AbstractFlickerFunctionality> FLICKER_FOCUS = new ObjectCallbacks();

        public void onCreate(Map<ResourceLocation, ?> slaveset, BiMap<ResourceLocation, ? extends IForgeRegistry<?>> registries) {
        }

        public void onClear(IForgeRegistry<T> is, Map<ResourceLocation, ?> slaveset) {
        }

        public void onAdd(T obj, int id, Map<ResourceLocation, ?> slaveset) {
        }
    }
}

