/*
 * Decompiled with CFR 0.152.
 */
package am2.api;

import am2.api.sources.DamageSourceDarkNexus;
import am2.api.sources.DamageSourceFire;
import am2.api.sources.DamageSourceFrost;
import am2.api.sources.DamageSourceHoly;
import am2.api.sources.DamageSourceLightning;
import am2.api.sources.DamageSourceUnsummon;
import am2.api.sources.DamageSourceWTFBoom;
import am2.api.sources.DamageSourceWind;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class DamageSources {
    public static DamageSourceUnsummon unsummon = new DamageSourceUnsummon();
    public static DamageSourceWTFBoom wtfBoom = new DamageSourceWTFBoom();
    public static DamageSourceDarkNexus darkNexus = new DamageSourceDarkNexus();

    public static DamageSourceFire causeFireDamage(EntityLivingBase source) {
        DamageSourceFire fire = new DamageSourceFire(source);
        fire.func_76351_m();
        return fire;
    }

    public static DamageSourceFrost causeFrostDamage(EntityLivingBase source) {
        DamageSourceFrost frost = new DamageSourceFrost(source);
        frost.func_76351_m();
        return frost;
    }

    public static DamageSourceLightning causeLightningDamage(EntityLivingBase source) {
        DamageSourceLightning lightning = new DamageSourceLightning(source);
        lightning.func_76351_m();
        return lightning;
    }

    public static DamageSourceWind causeWindDamage(EntityLivingBase source) {
        DamageSourceWind wind = new DamageSourceWind(source);
        wind.func_76351_m();
        return wind;
    }

    public static DamageSourceHoly causeHolyDamage(EntityLivingBase source) {
        DamageSourceHoly holy = new DamageSourceHoly(source);
        holy.func_76351_m();
        return holy;
    }

    public static DamageSource causeDamage(DamageSourceTypes type, EntityLivingBase source) {
        switch (type) {
            case FIRE: {
                DamageSourceFire fire = new DamageSourceFire(source);
                fire.func_76351_m();
                return fire;
            }
            case FROST: {
                DamageSourceFrost frost = new DamageSourceFrost(source);
                frost.func_76351_m();
                return frost;
            }
            case LIGHTNING: {
                DamageSourceLightning lightning = new DamageSourceLightning(source);
                lightning.func_76351_m();
                return lightning;
            }
            case MAGIC: {
                return DamageSource.func_76354_b((Entity)source, (Entity)source);
            }
            case WITHER: {
                return DamageSources.causeWitherDamage(source);
            }
            case THORNS: {
                return DamageSources.causeThornsDamage(source);
            }
            case CACTUS: {
                return DamageSources.causeCactusDamage(source);
            }
        }
        return DamageSource.func_76358_a((EntityLivingBase)source);
    }

    public static DamageSource causeDamage(DamageSourceTypes type, EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeDamage(type, source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeWitherDamage(EntityLivingBase source) {
        return new EntityDamageSource("wither", (Entity)source);
    }

    public static DamageSource causeThornsDamage(EntityLivingBase source) {
        return new EntityDamageSource("thorns", (Entity)source);
    }

    public static DamageSource causeCactusDamage(EntityLivingBase source) {
        return new EntityDamageSource("cactus", (Entity)source);
    }

    public static DamageSource causeMagicDamage(EntityLivingBase source) {
        EntityDamageSource ds = new EntityDamageSource("magic", (Entity)source);
        ds.func_82726_p();
        DamageSources.setDamageSourceUnblockable((DamageSource)ds);
        return ds;
    }

    public static DamageSource causePhysicalDamage(Entity source) {
        if (source instanceof EntityPlayer) {
            return new EntityDamageSource("player", source);
        }
        return new EntityDamageSource("mob", source);
    }

    public static DamageSource causeWitherDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeWitherDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeThornsDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeThornsDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeCactusDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeCactusDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource setDamageSourceUnblockable(DamageSource original) {
        ReflectionHelper.setPrivateValue(DamageSource.class, (Object)original, (Object)true, (String[])new String[]{"field_76374_o", "isUnblockable"});
        return original;
    }

    public static DamageSource causeDrownDamage(EntityLivingBase source) {
        return new EntityDamageSource("drown", (Entity)source);
    }

    public static enum DamageSourceTypes {
        PHYSICAL,
        FIRE,
        FROST,
        LIGHTNING,
        MAGIC,
        WITHER,
        THORNS,
        CACTUS,
        HOLY;

    }
}

