/*
 * Decompiled with CFR 0.152.
 */
package am2.api;

import am2.LogHelper;
import am2.api.ArsMagicaAPI;
import am2.api.skill.Skill;
import am2.api.skill.SkillPoint;
import am2.api.skill.SkillTree;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellShape;
import am2.utils.NBTUtils;
import am2.utils.RecipeUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class SpellRegistry {
    public static void registerSpellComponent(String id, ResourceLocation icon, SkillPoint tier, SpellComponent part, SkillTree tree, int posX, int posY, String ... parents) {
        id = id.toLowerCase();
        GameRegistry.register((IForgeRegistryEntry)part, (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
        GameRegistry.register((IForgeRegistryEntry)new Skill(icon, tier, posX, posY, tree, parents), (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
    }

    public static void registerSpellModifier(String id, ResourceLocation icon, SkillPoint tier, SpellModifier part, SkillTree tree, int posX, int posY, String ... parents) {
        id = id.toLowerCase();
        GameRegistry.register((IForgeRegistryEntry)part, (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
        GameRegistry.register((IForgeRegistryEntry)new Skill(icon, tier, posX, posY, tree, parents), (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
    }

    public static void registerSpellShape(String id, ResourceLocation icon, SkillPoint tier, SpellShape part, SkillTree tree, int posX, int posY, String ... parents) {
        id = id.toLowerCase();
        GameRegistry.register((IForgeRegistryEntry)part, (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
        GameRegistry.register((IForgeRegistryEntry)new Skill(icon, tier, posX, posY, tree, parents), (ResourceLocation)new ResourceLocation(ArsMagicaAPI.getCurrentModId(), id));
    }

    public static Skill getSkillFromPart(AbstractSpellPart part) {
        return (Skill)ArsMagicaAPI.getSkillRegistry().getValue(part.getRegistryName());
    }

    public static AbstractSpellPart getPartByRecipe(ArrayList<ItemStack> currentAddedItems) {
        for (AbstractSpellPart data : ArsMagicaAPI.getSpellRegistry().getValues()) {
            boolean match;
            if (data == null || data.getRecipe() == null) continue;
            ArrayList<ItemStack> convRecipe = RecipeUtils.getConvRecipe(data);
            boolean bl = match = currentAddedItems.size() == convRecipe.size();
            if (!match) continue;
            for (int i = 0; i < convRecipe.size(); ++i) {
                match &= OreDictionary.itemMatches((ItemStack)convRecipe.get(i), (ItemStack)currentAddedItems.get(i), (boolean)false);
                if (!(match &= convRecipe.get(i).func_77978_p() == null ? true : (currentAddedItems.get(i).func_77978_p() == null ? false : NBTUtils.contains(convRecipe.get(i).func_77978_p(), currentAddedItems.get(i).func_77978_p())))) break;
            }
            if (!match) {
                LogHelper.debug("Part doesn't match %s", data.getRegistryName().toString());
            }
            if (!match) continue;
            LogHelper.debug("Part matches : %s!", data.getRegistryName().toString());
            return data;
        }
        return null;
    }

    public static SpellShape getShapeFromName(String shapeName) {
        AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(new ResourceLocation(shapeName));
        return part instanceof SpellShape ? (SpellShape)part : null;
    }

    public static SpellModifier getModifierFromName(String shapeName) {
        AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(new ResourceLocation(shapeName));
        return part instanceof SpellModifier ? (SpellModifier)part : null;
    }

    public static SpellComponent getComponentFromName(String shapeName) {
        AbstractSpellPart part = (AbstractSpellPart)ArsMagicaAPI.getSpellRegistry().getValue(new ResourceLocation(shapeName));
        return part instanceof SpellComponent ? (SpellComponent)part : null;
    }
}

