/*
 * Decompiled with CFR 0.152.
 */
package am2.api.blocks;

import am2.api.blocks.MultiblockGroup;
import am2.gui.AMGuiHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiblockStructureDefinition {
    public ArrayList<List<MultiblockGroup>> groups = new ArrayList();
    String id;

    public MultiblockStructureDefinition(String id) {
        this.id = id;
    }

    public void addGroup(MultiblockGroup group, MultiblockGroup ... rest) {
        this.groups.add(Lists.asList((Object)group, (Object[])rest));
    }

    public boolean matches(World world, BlockPos startCheckPos) {
        boolean subFlag = true;
        for (List<MultiblockGroup> subGroup : this.groups) {
            boolean groupCheck = false;
            boolean hasCheck = false;
            for (MultiblockGroup group : subGroup) {
                hasCheck = true;
                groupCheck |= group.matches(world, startCheckPos);
            }
            if (!hasCheck) continue;
            subFlag &= groupCheck;
        }
        return subFlag;
    }

    public List<MultiblockGroup> getMatchingGroups(World world, BlockPos startCheckPos) {
        ArrayList<MultiblockGroup> list = new ArrayList<MultiblockGroup>();
        for (List<MultiblockGroup> subGroup : this.groups) {
            for (MultiblockGroup group : subGroup) {
                if (!group.matches(world, startCheckPos)) continue;
                list.add(group);
            }
        }
        return list;
    }

    public HashMap<BlockPos, List<IBlockState>> getStructureLayer(MultiblockGroup selected, int layer) {
        HashMap<BlockPos, List<IBlockState>> stateMap = new HashMap<BlockPos, List<IBlockState>>();
        for (BlockPos entry : selected.getPositions()) {
            if (entry.func_177956_o() != layer) continue;
            stateMap.put(entry, (List<IBlockState>)selected.getStates());
        }
        return stateMap;
    }

    public int getMinX() {
        int min = Integer.MAX_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMinX() >= min) continue;
                min = gr.getMinX();
            }
        }
        return min;
    }

    public int getMinY() {
        int min = Integer.MAX_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMinY() >= min) continue;
                min = gr.getMinY();
            }
        }
        return min;
    }

    public int getMinZ() {
        int min = Integer.MAX_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMinZ() >= min) continue;
                min = gr.getMinZ();
            }
        }
        return min;
    }

    public int getMaxX() {
        int max = Integer.MIN_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMaxX() <= max) continue;
                max = gr.getMaxX();
            }
        }
        return max;
    }

    public int getMaxY() {
        int max = Integer.MIN_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMaxY() <= max) continue;
                max = gr.getMaxY();
            }
        }
        return max;
    }

    public int getMaxZ() {
        int max = Integer.MIN_VALUE;
        for (List<MultiblockGroup> group : this.groups) {
            for (MultiblockGroup gr : group) {
                if (gr.getMaxZ() <= max) continue;
                max = gr.getMaxZ();
            }
        }
        return max;
    }

    public int getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public int getLength() {
        return this.getMaxZ() - this.getMinZ();
    }

    public int getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public String getId() {
        return this.id;
    }

    public ArrayList<MultiblockGroup> getGroups() {
        ArrayList<MultiblockGroup> list = new ArrayList<MultiblockGroup>();
        for (List<MultiblockGroup> groups : this.groups) {
            int num = new Random((long)AMGuiHelper.instance.getSlowTicker() * 4500L).nextInt(groups.size());
            MultiblockGroup group = groups.get(num);
            list.add(group);
        }
        return list;
    }
}

