/*
 * Decompiled with CFR 0.152.
 */
package am2.api.blocks;

import am2.api.blocks.MultiblockGroup;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TypedMultiblockGroup
extends MultiblockGroup {
    protected ArrayList<HashMap<Integer, IBlockState>> states;
    protected HashMap<BlockPos, Integer> groups = new HashMap();

    private static ArrayList<IBlockState> createStateList(ArrayList<HashMap<Integer, IBlockState>> arrayList) {
        ArrayList<IBlockState> stateMap = new ArrayList<IBlockState>();
        for (HashMap<Integer, IBlockState> map : arrayList) {
            stateMap.addAll(map.values());
        }
        return stateMap;
    }

    public TypedMultiblockGroup(String name, ArrayList<HashMap<Integer, IBlockState>> arrayList, boolean ignoreState) {
        super(name, TypedMultiblockGroup.createStateList(arrayList), ignoreState);
        this.states = arrayList;
    }

    public void addBlock(BlockPos position, int group) {
        this.positions.add(position);
        this.groups.put(position, group);
    }

    @Override
    @Deprecated
    public void addBlock(BlockPos position) {
        this.addBlock(position, 0);
    }

    public int getGroup(BlockPos pos) {
        return this.groups.get(pos);
    }

    public ArrayList<IBlockState> getState(BlockPos pos) {
        ArrayList<IBlockState> state = new ArrayList<IBlockState>();
        for (HashMap<Integer, IBlockState> map : this.states) {
            state.add(map.get(this.getGroup(pos)));
        }
        return state;
    }

    @Override
    public boolean matches(World world, BlockPos startCheckPos) {
        for (HashMap<Integer, IBlockState> map : this.states) {
            boolean subFlag = false;
            for (BlockPos pos : this.positions) {
                IBlockState checkState = world.func_180495_p(startCheckPos.func_177971_a((Vec3i)pos));
                IBlockState state = map.get(this.getGroup(pos));
                if (this.ignoreState) {
                    subFlag = checkState.func_177230_c().equals(state.func_177230_c());
                } else {
                    boolean bl = subFlag = checkState.func_177230_c() == state.func_177230_c() && checkState.func_177230_c().func_176201_c(checkState) == state.func_177230_c().func_176201_c(state);
                }
                if (subFlag) continue;
                break;
            }
            if (!subFlag) continue;
            return true;
        }
        return false;
    }
}

