/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.pages;

import am2.api.compendium.pages.CompendiumPage;
import am2.api.recipes.RecipeArsMagica;
import am2.api.recipes.RecipesEssenceRefiner;
import am2.defs.ItemDefs;
import am2.gui.AMGuiHelper;
import am2.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PageItemStack
extends CompendiumPage<ItemStack> {
    private int recipeWidth;
    private int recipeHeight;
    private Object[] craftingComponents;
    private ItemStack stackTip;

    public PageItemStack(ItemStack element) {
        super(element);
        this.getAndAnalyzeRecipe();
    }

    @Override
    protected void renderPage(int posX, int posY, int mouseX, int mouseY) {
        int cx = posX + 60;
        int cy = posY + 92;
        this.stackTip = null;
        RenderHelper.func_74518_a();
        if (this.craftingComponents == null) {
            AMGuiHelper.DrawItemAtXY((ItemStack)this.element, cx, cy, 0.0f);
            if (mouseX > cx && mouseX < cx + 16 && mouseY > cy && mouseY < cy + 16) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.addAll(((ItemStack)this.element).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false));
                this.drawHoveringText(tooltip, mouseX, mouseY, this.mc.field_71466_p);
            }
        }
        this.RenderRecipe(cx, cy, mouseX, mouseY);
        this.mc.field_71446_o.func_110577_a(new ResourceLocation("arsmagica2", "textures/gui/ArcaneCompendiumGuiExtras.png"));
        this.zLevel += 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawTexturedModalRect_Classic(posX + 125, posY + 15, 112, 145, 60, 40, 40, 40);
        this.drawTexturedModalRect_Classic(posX, posY + 200, 112, 175, 60, 40, 40, 40);
        this.drawExtra(cx, cy);
        GlStateManager.func_179141_d();
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (this.stackTip != null) {
            this.renderItemToolTip(this.stackTip, mouseX, mouseY);
        }
        RenderHelper.func_74519_b();
    }

    private void RenderRecipe(int cx, int cy, int mousex, int mousey) {
        int step = 32;
        int sx = cx - step;
        int sy = cy - step;
        if (this.craftingComponents == null) {
            return;
        }
        boolean isEssenceRefiner = false;
        for (Map.Entry<Integer, RecipeArsMagica> entry : RecipesEssenceRefiner.essenceRefinement().GetRecipeList().entrySet()) {
            if (entry.getValue().getOutput().func_77969_a((ItemStack)this.element)) {
                isEssenceRefiner = true;
            }
            if (!isEssenceRefiner) continue;
            break;
        }
        if (isEssenceRefiner) {
            this.renderCraftingComponent(0, cx, cy - 36, mousex, mousey);
            this.renderCraftingComponent(1, cx - 30, cy - 2, mousex, mousey);
            this.renderCraftingComponent(2, cx, cy - 2, mousex, mousey);
            this.renderCraftingComponent(3, cx + 28, cy - 2, mousex, mousey);
            this.renderCraftingComponent(4, cx, cy + 30, mousex, mousey);
        } else if (this.recipeHeight > 0) {
            for (int i = 0; i < this.recipeHeight; ++i) {
                for (int j = 0; j < this.recipeWidth; ++j) {
                    int index = i * this.recipeWidth + j;
                    this.renderCraftingComponent(index, sx, sy, mousex, mousey);
                    sx += step;
                }
                sx = cx - step;
                sy += step;
            }
        } else {
            int col = 0;
            int row = 0;
            int widthSq = (int)Math.ceil(Math.sqrt(this.recipeWidth));
            String label = "\u00a7nShapeless";
            this.mc.field_71466_p.func_78276_b(label, cx - (int)((double)this.mc.field_71466_p.func_78256_a(label) / 2.5), cy - step * 3, 0x6600FF);
            for (int i = 0; i < this.recipeWidth; ++i) {
                sx = cx - step + step * col;
                sy = cy - step + step * row;
                int index = row * widthSq + col++;
                if (col >= widthSq) {
                    ++row;
                    col = 0;
                }
                this.renderCraftingComponent(index, sx, sy, mousex, mousey);
            }
        }
        sx = cx;
        sy = cy - (int)(2.5 * (double)step);
        if (this.element != null) {
            AMGuiHelper.DrawItemAtXY((ItemStack)this.element, sx, sy, this.zLevel);
            if (((ItemStack)this.element).field_77994_a > 1) {
                this.mc.field_71466_p.func_175065_a("x" + ((ItemStack)this.element).field_77994_a, (float)(sx + 16), (float)(sy + 8), 0, false);
            }
            if (mousex > sx && mousex < sx + 16 && mousey > sy && mousey < sy + 16) {
                this.stackTip = (ItemStack)this.element;
            }
        }
    }

    private void renderCraftingComponent(int index, int sx, int sy, int mousex, int mousey) {
        Object craftingComponent = this.craftingComponents[index];
        if (craftingComponent == null) {
            return;
        }
        ItemStack stack = null;
        if (craftingComponent instanceof ItemStack) {
            stack = (ItemStack)craftingComponent;
        } else if (craftingComponent instanceof List) {
            if (((List)craftingComponent).size() == 0) {
                return;
            }
            int idx = new Random(AMGuiHelper.instance.getSlowTicker()).nextInt(((List)craftingComponent).size());
            stack = ((ItemStack)((List)craftingComponent).get(idx)).func_77946_l();
        }
        ArrayList alternates = new ArrayList();
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            stack.func_77973_b().func_150895_a(stack.func_77973_b(), stack.func_77973_b().func_77640_w(), alternates);
        }
        if (alternates.size() > 0) {
            stack = (ItemStack)alternates.get(new Random(AMGuiHelper.instance.getSlowTicker()).nextInt(alternates.size()));
        }
        try {
            AMGuiHelper.DrawItemAtXY(stack, sx, sy, this.zLevel);
            RenderHelper.func_74518_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mousex > sx && mousex < sx + 16 && mousey > sy && mousey < sy + 16) {
            this.stackTip = stack;
        }
    }

    private void drawExtra(int cx, int cy) {
        GlStateManager.func_179084_k();
        if (this.craftingComponents == null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.drawTexturedModalRect_Classic(cx - 77, cy - 68, 0, 101, 150, 150, 100, 147);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (((ItemStack)this.element).func_77973_b() == ItemDefs.essence || ((ItemStack)this.element).func_77973_b() == ItemDefs.deficitCrystal || ((ItemStack)this.element).func_77973_b() == ItemDefs.core) {
                this.drawTexturedModalRect_Classic(cx - 43, cy - 45, 367, 0, 105, 105, 70, 105);
            } else if (((ItemStack)this.element).func_77973_b() != ItemDefs.spell_component) {
                this.drawTexturedModalRect_Classic(cx - 43, cy - 43, 0, 0, 100, 100, 67, 95);
            }
            GlStateManager.func_179084_k();
        }
    }

    private void getAndAnalyzeRecipe() {
        boolean isEssenceRefiner = false;
        for (Map.Entry<Integer, RecipeArsMagica> entry : RecipesEssenceRefiner.essenceRefinement().GetRecipeList().entrySet()) {
            if (entry.getValue().getOutput().func_77969_a((ItemStack)this.element)) {
                isEssenceRefiner = true;
            }
            if (!isEssenceRefiner) continue;
            break;
        }
        if (isEssenceRefiner) {
            RecipeArsMagica essenceRecipe = RecipesEssenceRefiner.essenceRefinement().recipeFor((ItemStack)this.element);
            if (essenceRecipe != null) {
                this.craftingComponents = essenceRecipe.getRecipeItems();
                this.recipeHeight = 2;
            } else {
                this.craftingComponents = null;
            }
        } else {
            IRecipe recipe = RecipeUtils.getRecipeFor((ItemStack)this.element);
            if (recipe != null) {
                this.element = recipe.func_77571_b();
                if (recipe instanceof ShapedRecipes) {
                    this.recipeWidth = ((ShapedRecipes)recipe).field_77576_b;
                    this.recipeHeight = ((ShapedRecipes)recipe).field_77577_c;
                    this.craftingComponents = ((ShapedRecipes)recipe).field_77574_d;
                } else if (recipe instanceof ShapedOreRecipe) {
                    this.recipeWidth = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
                    this.recipeHeight = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
                    this.craftingComponents = ((ShapedOreRecipe)recipe).getInput();
                } else if (recipe instanceof ShapelessRecipes) {
                    this.recipeWidth = ((ShapelessRecipes)recipe).func_77570_a();
                    this.recipeHeight = -1;
                    this.craftingComponents = ((ShapelessRecipes)recipe).field_77579_b.toArray();
                } else if (recipe instanceof ShapelessOreRecipe) {
                    this.recipeWidth = ((ShapelessOreRecipe)recipe).func_77570_a();
                    this.recipeHeight = -1;
                    this.craftingComponents = ((ShapelessOreRecipe)recipe).getInput().toArray();
                } else {
                    this.craftingComponents = null;
                }
            } else {
                this.craftingComponents = null;
            }
        }
    }
}

