/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.pages;

import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.api.compendium.pages.CompendiumPage;
import am2.gui.AMGuiHelper;
import am2.gui.GuiBlockAccess;
import am2.gui.controls.GuiButtonCompendiumNext;
import am2.gui.controls.GuiButtonVariableDims;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class PageMultiblock
extends CompendiumPage<MultiblockStructureDefinition> {
    private int curLayer = -1;
    private int maxLayers = 0;
    private GuiBlockAccess blockAccess = new GuiBlockAccess();
    private GuiButtonCompendiumNext prevLayer;
    private GuiButtonCompendiumNext nextLayer;
    private GuiButtonVariableDims pauseCycling;
    private ItemStack stackTip = null;
    private static final ResourceLocation red = new ResourceLocation("arsmagica2", "textures/blocks/red.png");

    public PageMultiblock(MultiblockStructureDefinition element) {
        super(element);
        this.maxLayers = element.getHeight();
    }

    @Override
    public GuiButton[] getButtons(int id, int posX, int posY) {
        this.prevLayer = new GuiButtonCompendiumNext(id++, posX, posY + 19, false);
        this.nextLayer = new GuiButtonCompendiumNext(id++, posX + 125, posY + 19, true);
        this.pauseCycling = new GuiButtonVariableDims(5, posX + 105, posY + 190, AMGuiHelper.instance.runCompendiumTicker ? I18n.func_74838_a((String)"am2.gui.pause") : I18n.func_74838_a((String)"am2.gui.cycle")).setDimensions(40, 20);
        this.prevLayer.field_146125_m = true;
        this.nextLayer.field_146125_m = true;
        this.pauseCycling.field_146125_m = true;
        return new GuiButton[]{this.prevLayer, this.nextLayer, this.pauseCycling};
    }

    @Override
    public void switchButtonDisplay(boolean shouldShow) {
        if (shouldShow) {
            this.prevLayer.field_146125_m = true;
            this.nextLayer.field_146125_m = true;
            this.pauseCycling.field_146125_m = true;
        } else {
            this.prevLayer.field_146125_m = false;
            this.nextLayer.field_146125_m = false;
            this.pauseCycling.field_146125_m = false;
        }
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        if (button == this.nextLayer) {
            ++this.curLayer;
            if (this.curLayer > this.maxLayers) {
                this.curLayer = -1;
            }
        } else if (button == this.prevLayer) {
            --this.curLayer;
            if (this.curLayer < -1) {
                this.curLayer = this.maxLayers;
            }
        } else if (button == this.pauseCycling) {
            AMGuiHelper.instance.runCompendiumTicker = !AMGuiHelper.instance.runCompendiumTicker;
            this.pauseCycling.field_146126_j = AMGuiHelper.instance.runCompendiumTicker ? I18n.func_74838_a((String)"am2.gui.pause") : I18n.func_74838_a((String)"am2.gui.cycle");
        }
        super.actionPerformed(button);
    }

    @Override
    protected void renderPage(int posX, int posY, int mouseX, int mouseY) {
        this.stackTip = null;
        int cx = posX + 60;
        int cy = posY + 92;
        String label = String.format("%s: %s", I18n.func_74838_a((String)"am2.gui.layer"), this.curLayer == -1 ? I18n.func_74838_a((String)"am2.gui.all") : "" + this.curLayer);
        this.mc.field_71466_p.func_78276_b(label, cx - this.mc.field_71466_p.func_78256_a(label) / 2, cy - 90, 0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        BlockPos pickedBlock = this.getPickedBlock(cx, cy, mouseX, mouseY);
        if (this.curLayer == -1) {
            for (int i = ((MultiblockStructureDefinition)this.element).getMinY(); i <= ((MultiblockStructureDefinition)this.element).getMaxY(); ++i) {
                int y = i - ((MultiblockStructureDefinition)this.element).getMinY();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(20.0f * (float)y));
                this.drawMultiblockLayer(cx, cy, i, pickedBlock, mouseX, mouseY);
            }
        } else {
            int i = ((MultiblockStructureDefinition)this.element).getMinY() + this.curLayer;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(20.0f * (float)this.curLayer));
            this.drawMultiblockLayer(cx, cy, i, pickedBlock, mouseX, mouseY);
        }
        if (this.stackTip != null) {
            this.renderItemToolTip(this.stackTip, mouseX, mouseY);
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private BlockPos getPickedBlock(int cx, int cy, int mousex, int mousey) {
        BlockPos block = null;
        float step_x = 14.0f;
        float step_y = -16.0f;
        float step_z = 7.0f;
        cy = (int)((float)cy - step_y * (float)((MultiblockStructureDefinition)this.element).getMinY() / 2.0f);
        cy = (int)((float)cy - step_y * (float)((MultiblockStructureDefinition)this.element).getMaxY() / 2.0f);
        int start = this.curLayer == -1 ? ((MultiblockStructureDefinition)this.element).getMinY() : ((MultiblockStructureDefinition)this.element).getMinY() + this.curLayer;
        int end = this.curLayer == -1 ? ((MultiblockStructureDefinition)this.element).getMaxY() : ((MultiblockStructureDefinition)this.element).getMinY() + this.curLayer;
        for (int i = start; i <= end; ++i) {
            TreeMap<BlockPos, List<IBlockState>> layerBlocksSorted = this.getMultiblockLayer(i);
            float px = (float)cx - step_x * (float)(((MultiblockStructureDefinition)this.element).getWidth() / 2);
            float py = (float)cy - step_z * (float)(((MultiblockStructureDefinition)this.element).getLength() / 2);
            for (BlockPos bc : layerBlocksSorted.keySet()) {
                float x = px + (float)(bc.func_177958_n() - bc.func_177952_p()) * step_x;
                float y = py + (float)(bc.func_177952_p() + bc.func_177958_n()) * step_z + step_y * (float)i;
                x += 20.0f;
                y -= 10.0f;
                if (!((float)mousex > x) || !((float)mousex < x + 32.0f) || !((float)mousey > y) || !((float)mousey < y + 32.0f)) continue;
                block = bc;
            }
        }
        return block;
    }

    private void drawMultiblockLayer(int cx, int cy, int layer, BlockPos pickedBlock, int mousex, int mousey) {
        TreeMap<BlockPos, List<IBlockState>> layerBlocksSorted = this.getMultiblockLayer(layer);
        float step_x = 14.0f;
        float step_y = -16.0f;
        float step_z = 7.0f;
        cy = (int)((float)cy - step_y * (float)((MultiblockStructureDefinition)this.element).getMinX() / 2.0f);
        cy = (int)((float)cy - step_y * (float)((MultiblockStructureDefinition)this.element).getMaxY() / 2.0f);
        float px = (float)cx - step_x * (float)(((MultiblockStructureDefinition)this.element).getWidth() / 2);
        float py = (float)cy - step_z * (float)(((MultiblockStructureDefinition)this.element).getLength() / 2);
        for (BlockPos bc : layerBlocksSorted.keySet()) {
            ItemStack stack;
            IBlockState bd = layerBlocksSorted.get(bc).get(AMGuiHelper.instance.getSlowTicker() % layerBlocksSorted.get(bc).size());
            float x = px + (float)(bc.func_177958_n() - bc.func_177952_p()) * step_x;
            float y = py + (float)(bc.func_177952_p() + bc.func_177958_n()) * step_z + step_y * (float)layer;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(15 * bc.func_177958_n()));
            boolean picked = pickedBlock != null && bc.equals((Object)pickedBlock);
            this.renderBlock(bd, x, y, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), picked);
            GL11.glPopMatrix();
            if (!picked || (stack = new ItemStack(bd.func_177230_c(), 1, bd.func_177230_c().func_176201_c(bd))).func_77973_b() == null) continue;
            this.stackTip = stack;
        }
    }

    private TreeMap<BlockPos, List<IBlockState>> getMultiblockLayer(int layer) {
        TreeMap<BlockPos, List<IBlockState>> layerBlocksSorted = new TreeMap<BlockPos, List<IBlockState>>();
        for (MultiblockGroup mutex : ((MultiblockStructureDefinition)this.element).getGroups()) {
            HashMap<BlockPos, List<IBlockState>> layerBlocks = ((MultiblockStructureDefinition)this.element).getStructureLayer(mutex, layer);
            for (BlockPos bc : layerBlocks.keySet()) {
                if (mutex instanceof TypedMultiblockGroup) {
                    TypedMultiblockGroup newGroup = (TypedMultiblockGroup)mutex;
                    layerBlocksSorted.put(bc, newGroup.getState(bc));
                    continue;
                }
                layerBlocksSorted.put(bc, layerBlocks.get(bc));
            }
        }
        return layerBlocksSorted;
    }

    private void renderBlock(IBlockState state, float x, float y, int offsetX, int offsetY, int offsetZ, boolean picked) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + 15.0f), (float)(y + 3.0f), (float)(12.0f * (float)offsetZ));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)40.0f);
        GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
        GlStateManager.func_179109_b((float)1.0f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.blockAccess.setFakeBlockAndMeta(state);
        if (picked) {
            this.mc.field_71446_o.func_110577_a(red);
        } else {
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        }
        GlStateManager.func_179145_e();
        if (state.func_177230_c() instanceof ITileEntityProvider) {
            TileEntityRendererDispatcher.field_147556_a.func_178469_a(((ITileEntityProvider)state.func_177230_c()).func_149915_a((World)Minecraft.func_71410_x().field_71441_e, state.func_177230_c().func_176201_c(state)), 0.0, 0.0, 0.0, 0.0f, 0);
        }
        GlStateManager.func_179140_f();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft.func_71410_x().func_175602_ab().func_175018_a(state, new BlockPos(0, 0, 0), (IBlockAccess)this.blockAccess, Tessellator.func_178181_a().func_178180_c());
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

