/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.pages;

import am2.api.ArsMagicaAPI;
import am2.api.compendium.pages.CompendiumPage;
import am2.api.event.SpellRecipeItemsEvent;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellModifiers;
import am2.defs.ItemDefs;
import am2.gui.AMGuiHelper;
import am2.texture.SpellIconManager;
import am2.utils.RecipeUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public class PageSpellComponent
extends CompendiumPage<AbstractSpellPart> {
    private Object[] craftingComponents;
    private float framecount = 0.0f;
    private ItemStack stackTip = null;
    private int tipX;
    private int tipY;
    private static HashMap<Item, Integer> forcedMetas = new HashMap();

    public PageSpellComponent(AbstractSpellPart element) {
        super(element);
        this.getAndAnalyzeRecipe();
    }

    @Override
    protected void renderPage(int posX, int posY, int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        int cx = posX + 64;
        int cy = posY + 92;
        this.framecount += 0.5f;
        this.stackTip = null;
        this.RenderRecipe(cx, cy, mouseX, mouseY);
        TextureAtlasSprite icon = SpellIconManager.INSTANCE.getSprite(((AbstractSpellPart)((Object)this.element)).getRegistryName().toString());
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (icon != null) {
            AMGuiHelper.DrawIconAtXY(icon, (float)cx, (float)cy, this.zLevel, 16, 16, false);
        }
        if (mouseX > cx && mouseX < cx + 16 && mouseY > cy && mouseY < cy + 16) {
            this.stackTip = new ItemStack((Item)ItemDefs.spell_component, 1, ArsMagicaAPI.getSkillRegistry().getId(((AbstractSpellPart)((Object)this.element)).getRegistryName()));
            this.tipX = mouseX;
            this.tipY = mouseY;
        }
        this.mc.field_71446_o.func_110577_a(new ResourceLocation("arsmagica2", "textures/gui/ArcaneCompendiumGuiExtras.png"));
        this.zLevel += 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawTexturedModalRect_Classic(posX + 125, posY + 15, 112, 145, 60, 40, 40, 40);
        this.drawTexturedModalRect_Classic(posX + 0, posY + 200, 112, 175, 60, 40, 40, 40);
        GlStateManager.func_179084_k();
        this.zLevel -= 1.0f;
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderModifiers(posX, posY, mouseX, mouseY);
        if (this.stackTip != null) {
            this.renderItemToolTip(this.stackTip, this.tipX, this.tipY);
        }
        RenderHelper.func_74519_b();
    }

    private void renderModifiers(int posX, int posY, int mouseX, int mouseY) {
        ArrayList<SpellModifier> modifiers = new ArrayList<SpellModifier>();
        EnumSet<SpellModifiers> mods = ((AbstractSpellPart)((Object)this.element)).getModifiers();
        block0: for (AbstractSpellPart modifier : ArsMagicaAPI.getSpellRegistry()) {
            if (this.element == modifier || !(modifier instanceof SpellModifier)) continue;
            for (Object mod : ((SpellModifier)modifier).getAspectsModified()) {
                if (!mods.contains(mod)) continue;
                modifiers.add((SpellModifier)modifier);
                continue block0;
            }
        }
        int startX = 72 - 8 * modifiers.size();
        int yOffset = 10;
        if (!modifiers.isEmpty()) {
            String shapeName = I18n.func_74838_a((String)(this.element instanceof SpellComponent ? "am2.gui.modifies" : "am2.gui.modifiedBy"));
            this.mc.field_71466_p.func_78276_b(shapeName, posX + 72 - this.mc.field_71466_p.func_78256_a(shapeName) / 2, posY, 0);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderHelper.func_74520_c();
        for (Object mod : modifiers) {
            TextureAtlasSprite modIcon = SpellIconManager.INSTANCE.getSprite(mod.getRegistryName().toString());
            if (modIcon != null) {
                AMGuiHelper.DrawIconAtXY(modIcon, (float)(posX + startX), (float)(posY + yOffset), this.zLevel, 16, 16, false);
            }
            if (mouseX > posX + startX && mouseX < posX + startX + 16 && mouseY > posY + yOffset && mouseY < posY + yOffset + 16) {
                this.stackTip = new ItemStack((Item)ItemDefs.spell_component, 1, ArsMagicaAPI.getSkillRegistry().getId(mod.getRegistryName()));
                this.tipX = mouseX;
                this.tipY = mouseY;
            }
            startX += 16;
        }
        RenderHelper.func_74518_a();
    }

    private void RenderRecipe(int cx, int cy, int mousex, int mousey) {
        if (this.craftingComponents == null) {
            return;
        }
        float angleStep = 360.0f / (float)this.craftingComponents.length;
        for (int i = 0; i < this.craftingComponents.length; ++i) {
            float angle = (float)Math.toRadians(angleStep * (float)i + this.framecount % 360.0f);
            float nextangle = (float)Math.toRadians(angleStep * (float)((i + 1) % this.craftingComponents.length) + this.framecount % 360.0f);
            float dist = 45.0f;
            int x = (int)Math.round((double)cx - Math.cos(angle) * (double)dist);
            int y = (int)Math.round((double)cy - Math.sin(angle) * (double)dist);
            int nextx = (int)Math.round((double)cx - Math.cos(nextangle) * (double)dist);
            int nexty = (int)Math.round((double)cy - Math.sin(nextangle) * (double)dist);
            AMGuiHelper.line2d(x + 8, y + 8, cx + 8, cy + 8, this.zLevel, 221);
            AMGuiHelper.gradientline2d(x + 8, y + 8, nextx + 8, nexty + 8, this.zLevel, 221, 0xDD00DD);
            this.renderCraftingComponent(i, x, y, mousex, mousey);
        }
    }

    private void renderCraftingComponent(int index, int sx, int sy, int mousex, int mousey) {
        Object craftingComponent = this.craftingComponents[index];
        if (craftingComponent == null) {
            return;
        }
        ItemStack stack = null;
        if (craftingComponent instanceof ItemStack) {
            stack = (ItemStack)craftingComponent;
        } else if (craftingComponent instanceof List) {
            if (((List)craftingComponent).size() == 0) {
                return;
            }
            int idx = new Random(AMGuiHelper.instance.getSlowTicker()).nextInt(((List)craftingComponent).size());
            stack = ((ItemStack)((List)craftingComponent).get(idx)).func_77946_l();
        }
        ArrayList<ItemStack> alternates = new ArrayList<ItemStack>();
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            stack.func_77973_b().func_150895_a(stack.func_77973_b(), stack.func_77973_b().func_77640_w(), alternates);
        } else {
            alternates.add(stack);
        }
        if (alternates.size() > 0) {
            stack = (ItemStack)alternates.get(new Random(new Random(AMGuiHelper.instance.getSlowTicker()).nextLong()).nextInt(alternates.size()));
        }
        if (forcedMetas.containsKey(stack.func_77973_b())) {
            stack = new ItemStack(stack.func_77973_b(), stack.field_77994_a, forcedMetas.get(stack.func_77973_b()).intValue());
        }
        try {
            AMGuiHelper.DrawItemAtXY(stack, sx, sy, this.zLevel);
            RenderHelper.func_74518_a();
        }
        catch (Throwable t) {
            forcedMetas.put(stack.func_77973_b(), 0);
        }
        if (mousex > sx && mousex < sx + 16 && mousey > sy && mousey < sy + 16) {
            this.stackTip = stack;
            this.tipX = mousex;
            this.tipY = mousey;
        }
    }

    private void getAndAnalyzeRecipe() {
        ArrayList<Object> recipe = new ArrayList<Object>();
        Object[] recipeItems = ((AbstractSpellPart)((Object)this.element)).getRecipe();
        SpellRecipeItemsEvent event = new SpellRecipeItemsEvent(((AbstractSpellPart)((Object)this.element)).getRegistryName().toString(), recipeItems);
        MinecraftForge.EVENT_BUS.post((Event)event);
        recipeItems = event.recipeItems;
        if (recipeItems != null) {
            for (int i = 0; i < recipeItems.length; ++i) {
                Object o = recipeItems[i];
                if (o instanceof ItemStack) {
                    recipe.add(o);
                    continue;
                }
                if (o instanceof Item) {
                    recipe.add(new ItemStack((Item)o));
                    continue;
                }
                if (o instanceof Block) {
                    recipe.add(new ItemStack((Block)o));
                    continue;
                }
                if (!(o instanceof String)) continue;
                if (((String)o).startsWith("E:")) {
                    String s = (String)o;
                    try {
                        int[] types = RecipeUtils.ParseEssenceIDs(s);
                        int type = 0;
                        for (int t : types) {
                            type |= t;
                        }
                        int amount = (Integer)recipeItems[++i];
                        recipe.add(new ItemStack(ItemDefs.etherium, amount, type));
                    }
                    catch (Throwable t) {}
                    continue;
                }
                recipe.add(OreDictionary.getOres((String)((String)o)));
            }
        }
        this.craftingComponents = recipe.toArray();
    }
}

