/*
 * Decompiled with CFR 0.152.
 */
package am2.api.compendium.pages;

import am2.api.compendium.pages.CompendiumPage;
import am2.api.compendium.wrapper.StackMapWrapper;
import am2.gui.controls.GuiButtonCompendiumNext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class PageStackMap
extends CompendiumPage<StackMapWrapper> {
    private GuiButtonCompendiumNext nextPage = null;
    private GuiButtonCompendiumNext prevPage = null;
    private int page = 0;
    private int maxPages;

    public PageStackMap(StackMapWrapper element) {
        super(element);
        this.maxPages = (int)Math.floor(((double)element.getInput().size() - 1.0) / 24.0);
    }

    @Override
    public GuiButton[] getButtons(int id, int posX, int posY) {
        if (this.nextPage == null) {
            this.nextPage = new GuiButtonCompendiumNext(id++, posX + 125, posY + 20, true);
        }
        if (this.prevPage == null) {
            this.prevPage = new GuiButtonCompendiumNext(id++, posX + 5, posY + 20, false);
        }
        this.nextPage.field_146125_m = this.page < this.maxPages;
        this.prevPage.field_146125_m = this.page > 0;
        return new GuiButton[]{this.nextPage, this.prevPage};
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        if (button == this.nextPage) {
            ++this.page;
            if (this.page > this.maxPages) {
                this.page = this.maxPages;
            }
            this.nextPage.field_146125_m = this.page < this.maxPages;
            this.prevPage.field_146125_m = this.page > 0;
        } else if (button == this.prevPage) {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.nextPage.field_146125_m = this.page < this.maxPages;
            this.prevPage.field_146125_m = this.page > 0;
        }
    }

    @Override
    public void switchButtonDisplay(boolean shouldShow) {
        if (shouldShow) {
            this.nextPage.field_146125_m = this.page < this.maxPages;
            this.prevPage.field_146125_m = this.page > 0;
        } else {
            this.nextPage.field_146125_m = false;
            this.prevPage.field_146125_m = false;
        }
    }

    @Override
    protected void renderPage(int posX, int posY, int mouseX, int mouseY) {
        String loc = ((StackMapWrapper)this.element).getLocalizedName();
        this.mc.field_71466_p.func_78276_b(loc, posX + 72 - this.mc.field_71466_p.func_78256_a(loc) / 2, posY, 0);
        int index = 0;
        int offsetX = 16;
        int offsetY = 24;
        RenderHelper.func_74520_c();
        int max = -1;
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        map.putAll(((StackMapWrapper)this.element).getInput());
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null || (Integer)entry.getValue() <= max) continue;
            max = (Integer)entry.getValue();
        }
        ItemStack tip = null;
        for (int i = 0; i <= max; ++i) {
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null || (Integer)entry.getValue() != i) continue;
                int entryPage = (int)Math.floor((double)index / 24.0);
                ++index;
                if (entryPage == this.page) {
                    this.mc.func_175599_af().func_175042_a((ItemStack)entry.getKey(), posX + offsetX, posY + offsetY);
                    this.mc.field_71466_p.func_78276_b(((Integer)entry.getValue()).toString(), posX + offsetX + 8 - this.mc.field_71466_p.func_78256_a(((Integer)entry.getValue()).toString()) / 2, posY + offsetY + 18, 0xFFFFFF);
                }
                if (mouseX > posX + offsetX && mouseX < posX + offsetX + 16 && mouseY > posY + offsetY && mouseY < posY + offsetY + 16) {
                    tip = (ItemStack)entry.getKey();
                }
                offsetX += 32;
                if (index % 4 == 0) {
                    offsetX = 16;
                    offsetY += 32;
                }
                if (index % 24 != 0) continue;
                offsetX = 16;
                offsetY = 24;
            }
        }
        if (tip != null) {
            this.renderItemToolTip(tip, mouseX, mouseY);
        }
    }
}

