/*
 * Decompiled with CFR 0.152.
 */
package am2.api.event;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PotionEvent
extends Event {
    public Potion id;
    public int duration;
    public int amplifier;
    public boolean ambient;
    public boolean showParticules;
    public PotionEffect effect;

    protected PotionEvent(Potion id, int duration, int amplifier, boolean ambient, boolean showParticules) {
        this.id = id;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.showParticules = showParticules;
        this.effect = new PotionEffect(id, duration, amplifier, ambient, showParticules);
    }

    protected PotionEvent(PotionEffect effect) {
        this.effect = effect;
        this.id = effect.func_188419_a();
        this.duration = effect.func_76459_b();
        this.amplifier = effect.func_76458_c();
        this.showParticules = effect.func_188418_e();
        this.ambient = effect.func_82720_e();
    }

    public PotionEffect getEffect() {
        return this.effect;
    }

    public static class EventPotionLoaded
    extends PotionEvent {
        private NBTTagCompound compound;

        public EventPotionLoaded(PotionEffect effect, NBTTagCompound compound) {
            super(effect);
            this.compound = compound;
        }

        public NBTTagCompound getCompound() {
            return this.compound;
        }

        public static PotionEffect post(PotionEffect effect, NBTTagCompound compound) {
            EventPotionLoaded event = new EventPotionLoaded(effect, compound);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getEffect();
        }
    }

    public static class EventPotionAdded
    extends PotionEvent {
        public EventPotionAdded(Potion id, int duration, int amplifier, boolean ambient, boolean showParticules) {
            super(id, duration, amplifier, ambient, showParticules);
        }

        public EventPotionAdded(PotionEffect effect) {
            super(effect);
        }
    }
}

