/*
 * Decompiled with CFR 0.152.
 */
package am2.api.flickers;

import am2.LogHelper;
import am2.api.affinity.Affinity;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FlickerGenerationPool {
    public static FlickerGenerationPool INSTANCE = new FlickerGenerationPool();
    private HashMap<Affinity, Integer> map = new HashMap();

    private FlickerGenerationPool() {
        this.addWeightedAffinity(Affinity.AIR, 50);
        this.addWeightedAffinity(Affinity.ARCANE, 25);
        this.addWeightedAffinity(Affinity.EARTH, 50);
        this.addWeightedAffinity(Affinity.ENDER, 5);
        this.addWeightedAffinity(Affinity.FIRE, 50);
        this.addWeightedAffinity(Affinity.ICE, 25);
        this.addWeightedAffinity(Affinity.LIFE, 5);
        this.addWeightedAffinity(Affinity.LIGHTNING, 25);
        this.addWeightedAffinity(Affinity.NATURE, 25);
        this.addWeightedAffinity(Affinity.WATER, 50);
    }

    public void addWeightedAffinity(Affinity aff, int weight) {
        if (this.map.containsKey(aff)) {
            LogHelper.warn("Override : %s is already registered, report to the mod author", aff.getRegistryName().toString());
        }
        this.map.put(aff, weight);
    }

    public int getTotalWeight() {
        int total = 0;
        for (Integer integer : this.map.values()) {
            if (integer == null) continue;
            total += integer.intValue();
        }
        return total;
    }

    public Affinity getWeightedAffinity() {
        int chosen = new Random().nextInt(this.getTotalWeight());
        int total = 0;
        for (Map.Entry<Affinity, Integer> entry : this.map.entrySet()) {
            if (entry.getValue() == null || (total += entry.getValue().intValue()) <= chosen) continue;
            return entry.getKey();
        }
        return Affinity.NONE;
    }
}

