/*
 * Decompiled with CFR 0.152.
 */
package am2.armor;

import am2.api.items.armor.ArmorImbuement;
import am2.api.items.armor.ImbuementTiers;
import am2.armor.AMArmor;
import am2.armor.infusions.ImbuementRegistry;
import am2.extensions.EntityExtension;
import am2.utils.EntityUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ArmorHelper {
    private static final int IMBUE_TIER_COST = 12;

    public static boolean PlayerHasArmorInSlot(EntityPlayer player, EntityEquipmentSlot armorSlot) {
        return player.func_184582_a(armorSlot) != null;
    }

    public static void HandleArmorInfusion(EntityPlayer player) {
        EntityExtension ext = EntityExtension.For((EntityLivingBase)player);
        float infusionCost = 0.0f;
        boolean bFullSet = ArmorHelper.getFullArsMagicaArmorSet(player) != -1;
        for (EntityEquipmentSlot i : EntityEquipmentSlot.values()) {
            if (i.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            infusionCost += ArmorHelper.GetArsMagicaArmorInfusionCostFromSlot(player, i);
        }
        if (bFullSet) {
            infusionCost = (float)((double)infusionCost * 0.75);
        }
        if (infusionCost > 0.0f && ext.hasEnoughtMana(infusionCost)) {
            ext.deductMana(infusionCost);
            ext.bankedInfusionHelm += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, EntityEquipmentSlot.HEAD);
            ext.bankedInfusionChest += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, EntityEquipmentSlot.CHEST);
            ext.bankedInfusionLegs += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, EntityEquipmentSlot.LEGS);
            ext.bankedInfusionBoots += ArmorHelper.GetArsMagicaArmorRepairAmountFromSlot(player, EntityEquipmentSlot.FEET);
            if (ext.bankedInfusionHelm > 1.0f) {
                int repairAmount = (int)Math.floor(ext.bankedInfusionHelm);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, EntityEquipmentSlot.HEAD);
                ext.bankedInfusionHelm -= (float)repairAmount;
            }
            if (ext.bankedInfusionChest > 1.0f) {
                int repairAmount = (int)Math.floor(ext.bankedInfusionChest);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, EntityEquipmentSlot.CHEST);
                ext.bankedInfusionChest -= (float)repairAmount;
            }
            if (ext.bankedInfusionLegs > 1.0f) {
                int repairAmount = (int)Math.floor(ext.bankedInfusionLegs);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, EntityEquipmentSlot.LEGS);
                ext.bankedInfusionLegs -= (float)repairAmount;
            }
            if (ext.bankedInfusionBoots > 1.0f) {
                int repairAmount = (int)Math.floor(ext.bankedInfusionBoots);
                ArmorHelper.RepairEquippedArsMagicaArmorItem(player, repairAmount, EntityEquipmentSlot.FEET);
                ext.bankedInfusionBoots -= (float)repairAmount;
            }
        }
    }

    private static void RepairEquippedArsMagicaArmorItem(EntityPlayer player, int repairAmount, EntityEquipmentSlot slot) {
        if (!ArmorHelper.PlayerHasArmorInSlot(player, slot)) {
            return;
        }
        ItemStack armor = player.func_184582_a(slot);
        if (armor.func_77951_h()) {
            armor.func_77964_b(armor.func_77952_i() - repairAmount);
        }
    }

    private static boolean PlayerHasArsInfusableInSlot(EntityPlayer player, EntityEquipmentSlot armorSlot) {
        return player.func_184582_a(armorSlot) != null && player.func_184582_a(armorSlot).func_77973_b() instanceof AMArmor;
    }

    private static float GetArsMagicaArmorInfusionCostFromSlot(EntityPlayer player, EntityEquipmentSlot armorSlot) {
        if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, armorSlot)) {
            return 0.0f;
        }
        if (player.func_184582_a(armorSlot).func_77951_h()) {
            AMArmor armor = (AMArmor)player.func_184582_a(armorSlot).func_77973_b();
            return armor.GetInfusionCost();
        }
        return 0.0f;
    }

    public static int getFullArsMagicaArmorSet(EntityPlayer player) {
        int matlID = -1;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, slot)) {
                return -1;
            }
            AMArmor armor = (AMArmor)player.func_184582_a(slot).func_77973_b();
            if (matlID == -1) {
                matlID = armor.getMaterialID();
                continue;
            }
            if (matlID == armor.getMaterialID()) continue;
            return -1;
        }
        return matlID;
    }

    private static float GetArsMagicaArmorRepairAmountFromSlot(EntityPlayer player, EntityEquipmentSlot armorSlot) {
        if (!ArmorHelper.PlayerHasArsInfusableInSlot(player, armorSlot)) {
            return 0.0f;
        }
        if (player.func_184582_a(armorSlot).func_77951_h()) {
            AMArmor armor = (AMArmor)player.func_184582_a(armorSlot).func_77973_b();
            return armor.GetInfusionRepair();
        }
        return 0.0f;
    }

    public static ArmorImbuement[] getInfusionsOnArmor(EntityPlayer player, EntityEquipmentSlot armorSlot) {
        ItemStack stack = player.func_184582_a(armorSlot);
        return ArmorHelper.getInfusionsOnArmor(stack);
    }

    public static ArmorImbuement[] getInfusionsOnArmor(ItemStack stack) {
        String infusionList;
        if (stack == null || !stack.func_77942_o() || !(stack.func_77973_b() instanceof ItemArmor)) {
            return new ArmorImbuement[0];
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.func_77978_p().func_74781_a("AMArmorProperties");
        if (armorProps != null && (infusionList = armorProps.func_74779_i("armorEffects")) != null && infusionList != "") {
            String[] ids = infusionList.split("\\|");
            ArmorImbuement[] infusions = new ArmorImbuement[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                infusions[i] = ImbuementRegistry.instance.getImbuementByID(new ResourceLocation(ids[i]));
            }
            return infusions;
        }
        return new ArmorImbuement[0];
    }

    public static boolean isInfusionPreset(ItemStack stack, String id) {
        String infusionList;
        if (stack == null || !stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.func_77978_p().func_74781_a("AMArmorProperties");
        if (armorProps != null && (infusionList = armorProps.func_74779_i("armorEffects")) != null) {
            return infusionList.contains(id);
        }
        return false;
    }

    public static void imbueArmor(ItemStack armorStack, ResourceLocation id, boolean ignoreLevelRequirement) {
        ArmorImbuement imbuement = ImbuementRegistry.instance.getImbuementByID(id);
        if (armorStack != null && imbuement != null && armorStack.func_77973_b() instanceof ItemArmor) {
            if (!ignoreLevelRequirement && ArmorHelper.getArmorLevel(armorStack) < ArmorHelper.getImbueCost(imbuement.getTier())) {
                return;
            }
            for (EntityEquipmentSlot i : imbuement.getValidSlots()) {
                String infusionList;
                NBTTagCompound armorProps;
                if (i != ((ItemArmor)armorStack.func_77973_b()).field_77881_a) continue;
                if (!armorStack.func_77942_o()) {
                    armorStack.func_77982_d(new NBTTagCompound());
                }
                if ((armorProps = (NBTTagCompound)armorStack.func_77978_p().func_74781_a("AMArmorProperties")) == null) {
                    armorProps = new NBTTagCompound();
                }
                infusionList = (infusionList = armorProps.func_74779_i("armorEffects")) == null || infusionList == "" ? id.toString() : infusionList + "|" + id;
                armorProps.func_74778_a("armorEffects", infusionList);
                armorStack.func_77978_p().func_74782_a("AMArmorProperties", (NBTBase)armorProps);
                ArmorHelper.deductXPFromArmor(EntityUtils.getXPFromLevel(ArmorHelper.getImbueCost(imbuement.getTier())), armorStack);
                break;
            }
        }
    }

    public static int getArmorLevel(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound armorProps = (NBTTagCompound)stack.func_77978_p().func_74781_a("AMArmorProperties");
        if (armorProps != null) {
            return armorProps.func_74762_e("XPLevel");
        }
        return 0;
    }

    public static int getImbueCost(ImbuementTiers tier) {
        return 30 + tier.ordinal() * 12;
    }

    public static void addXPToArmor(float totalAmt, EntityPlayer player) {
        int numPieces = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || player.func_184582_a(slot) == null) continue;
            ++numPieces;
        }
        float xpPerPiece = totalAmt / (float)numPieces;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            ArmorHelper.addXPToArmor(xpPerPiece, player.func_184582_a(slot));
        }
    }

    public static void deductXPFromArmor(float amt, ItemStack armor) {
        if (armor != null && armor.func_77973_b() instanceof ItemArmor) {
            NBTTagCompound armorProps;
            if (!armor.func_77942_o()) {
                armor.func_77982_d(new NBTTagCompound());
            }
            if ((armorProps = (NBTTagCompound)armor.func_77978_p().func_74781_a("AMArmorProperties")) == null) {
                armorProps = new NBTTagCompound();
            }
            armorProps.func_74780_a("infusedXP", Math.max(armorProps.func_74769_h("infusedXP") - (double)amt, 0.0));
            armorProps.func_74768_a("XPLevel", EntityUtils.getLevelFromXP((float)armorProps.func_74769_h("infusedXP")));
            armor.func_77978_p().func_74782_a("AMArmorProperties", (NBTBase)armorProps);
        }
    }

    public static void addXPToArmor(float amt, ItemStack armor) {
        if (armor != null && armor.func_77973_b() instanceof ItemArmor) {
            NBTTagCompound armorProps;
            if (!armor.func_77942_o()) {
                armor.func_77982_d(new NBTTagCompound());
            }
            if ((armorProps = (NBTTagCompound)armor.func_77978_p().func_74781_a("AMArmorProperties")) == null) {
                armorProps = new NBTTagCompound();
            }
            armorProps.func_74780_a("infusedXP", armorProps.func_74769_h("infusedXP") + (double)amt);
            armorProps.func_74768_a("XPLevel", EntityUtils.getLevelFromXP((float)armorProps.func_74769_h("infusedXP")));
            armor.func_77978_p().func_74782_a("AMArmorProperties", (NBTBase)armorProps);
        }
    }
}

