/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.BlockAMContainer;
import am2.blocks.tileentity.TileEntityCrystalMarker;
import am2.blocks.tileentity.TileEntityCrystalMarkerSpellExport;
import am2.blocks.tileentity.TileEntityFlickerHabitat;
import am2.defs.ItemDefs;
import am2.items.ItemBlockCrystalMarker;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockCrystalMarker
extends BlockAMContainer {
    public static final int META_IN = 0;
    public static final int META_OUT = 1;
    public static final int META_LIKE_EXPORT = 2;
    public static final int META_SET_EXPORT = 3;
    public static final int META_REGULATE_EXPORT = 4;
    public static final int META_REGULATE_MULTI = 5;
    public static final int META_SET_IMPORT = 6;
    public static final int META_FINAL_DEST = 7;
    public static final int META_SPELL_EXPORT = 8;
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)8);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final String[] crystalMarkerTypes = new String[]{"cm_import", "cm_export", "cm_likeExport", "cm_setExport", "cm_regulateExport", "cm_regulateMulti", "cm_setImport", "cm_final", "cm_spellExport"};

    public BlockCrystalMarker() {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    private int getCrystalTier(int meta) {
        switch (meta) {
            case 0: 
            case 1: 
            case 7: {
                return 0;
            }
            case 2: 
            case 3: 
            case 6: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    public int func_149750_m(IBlockState state) {
        return 3 + this.getCrystalTier(this.func_176201_c(state));
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        par3List.add(new ItemStack((Block)this, 1, 0));
        par3List.add(new ItemStack((Block)this, 1, 1));
        par3List.add(new ItemStack((Block)this, 1, 2));
        par3List.add(new ItemStack((Block)this, 1, 3));
        par3List.add(new ItemStack((Block)this, 1, 4));
        par3List.add(new ItemStack((Block)this, 1, 5));
        par3List.add(new ItemStack((Block)this, 1, 6));
        par3List.add(new ItemStack((Block)this, 1, 7));
        par3List.add(new ItemStack((Block)this, 1, 8));
    }

    public TileEntity func_149915_a(World world, int i) {
        if (i == 8) {
            return new TileEntityCrystalMarkerSpellExport(i);
        }
        return new TileEntityCrystalMarker(i);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int operandType = (Integer)state.func_177229_b((IProperty)TYPE);
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ItemDefs.crystalWrench) {
            player.func_184609_a(EnumHand.MAIN_HAND);
            return world.field_72995_K;
        }
        if (heldItem != null && heldItem.func_77973_b() == ItemDefs.spellStaffMagitech) {
            player.func_184609_a(hand);
            if (world.field_72995_K) {
                return true;
            }
            if (operandType == 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"am2.tooltip.noPriIn")));
                return false;
            }
            TileEntityCrystalMarker crystalMarkerTE = this.GetTileEntity(world, pos);
            TileEntityFlickerHabitat elementalAttunerTE = null;
            if (crystalMarkerTE != null) {
                int oldPriority = crystalMarkerTE.getPriority();
                crystalMarkerTE.cyclePriority();
                AMVector3 elementalAttunerVector = crystalMarkerTE.getElementalAttuner();
                if (elementalAttunerVector != null && (elementalAttunerTE = this.GetElementalAttunerTileEntity(world, elementalAttunerVector.toBlockPos())) != null) {
                    elementalAttunerTE.switchMarkerPriority(new AMVector3(pos), oldPriority, crystalMarkerTE.getPriority());
                }
                player.func_145747_a((ITextComponent)new TextComponentString(String.format(I18n.func_74838_a((String)"am2.tooltip.priSet"), String.format("%d", crystalMarkerTE.getPriority()))));
            }
            return false;
        }
        if (operandType == 3 || operandType == 4 || operandType == 5 || operandType == 6) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ArsMagica2.instance, (int)5, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCrystalMarker) {
            ((TileEntityCrystalMarker)te).setFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
            IBlockState attachedTo = null;
            double minx = 0.0;
            double miny = 0.0;
            double minz = 0.0;
            double maxx = 1.0;
            double maxy = 1.0;
            double maxz = 1.0;
            attachedTo = world.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
            if (attachedTo != null) {
                minx = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72340_a;
                miny = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72338_b;
                minz = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72339_c;
                maxx = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72336_d;
                maxy = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e;
                maxz = attachedTo.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72334_f;
                ((TileEntityCrystalMarker)te).SetConnectedBoundingBox(minx, miny, minz, maxx, maxy, maxz);
            }
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    private TileEntityCrystalMarker GetTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCrystalMarker) {
            return (TileEntityCrystalMarker)te;
        }
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        AMVector3 elementalAttunerVector;
        TileEntityCrystalMarker crystalMarkerTE = this.GetTileEntity(world, pos);
        TileEntityFlickerHabitat elementalAttunerTE = null;
        if (crystalMarkerTE != null && (elementalAttunerVector = crystalMarkerTE.getElementalAttuner()) != null && (elementalAttunerTE = this.GetElementalAttunerTileEntity(world, elementalAttunerVector.toBlockPos())) != null) {
            int operandType = (Integer)state.func_177229_b((IProperty)TYPE);
            if (BlockCrystalMarker.isInputMarker(operandType)) {
                elementalAttunerTE.removeInMarkerLocation(pos);
            } else if (BlockCrystalMarker.isOutputMarker(operandType)) {
                elementalAttunerTE.removeOutMarkerLocation(pos);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    private TileEntityFlickerHabitat GetElementalAttunerTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFlickerHabitat) {
            return (TileEntityFlickerHabitat)te;
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        TileEntityCrystalMarker cm = (TileEntityCrystalMarker)te;
        if (cm == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case UP: {
                return new AxisAlignedBB((double)0.35f, (double)((float)(1.0 + cm.GetConnectedBoundingBox().field_72338_b) - 0.1f), (double)0.32f, (double)0.65f, (double)((float)(1.0 + cm.GetConnectedBoundingBox().field_72338_b)), (double)0.68f);
            }
            case DOWN: {
                return new AxisAlignedBB((double)0.35f, (double)((float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72337_e))), (double)0.3f, (double)0.65f, (double)((float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72337_e)) + 0.1f), (double)0.7f);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)0.35f, (double)0.32f, (double)((float)(1.0 + (1.0 - cm.GetConnectedBoundingBox().field_72334_f)) - 0.1f), (double)0.65f, (double)0.68f, (double)((float)(1.0 + (1.0 - cm.GetConnectedBoundingBox().field_72334_f))));
            }
            case NORTH: {
                return new AxisAlignedBB((double)0.35f, (double)0.32f, (double)((float)(0.0 - cm.GetConnectedBoundingBox().field_72339_c)), (double)0.65f, (double)0.68f, (double)((float)(0.0 - cm.GetConnectedBoundingBox().field_72339_c) + 0.1f));
            }
            case EAST: {
                return new AxisAlignedBB((double)((float)(1.0 + cm.GetConnectedBoundingBox().field_72340_a) - 0.1f), (double)0.32f, (double)0.35f, (double)((float)(1.0 + cm.GetConnectedBoundingBox().field_72340_a)), (double)0.68f, (double)0.65f);
            }
            case WEST: {
                return new AxisAlignedBB((double)((float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72336_d))), (double)0.32f, (double)0.35f, (double)((float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72336_d)) + 0.1f), (double)0.68f, (double)0.65f);
            }
        }
        return null;
    }

    public void onNeighborChange(IBlockAccess iblockaccess, BlockPos pos, BlockPos neighbor) {
        if (!(iblockaccess instanceof World)) {
            return;
        }
        World world = (World)iblockaccess;
        TileEntity te = world.func_175625_s(pos);
        TileEntityCrystalMarker cm = null;
        boolean mustDrop = false;
        if (te == null || !(te instanceof TileEntityCrystalMarker)) {
            return;
        }
        cm = (TileEntityCrystalMarker)te;
        mustDrop = world.func_175623_d(pos.func_177972_a(cm.getFacing()));
        if (mustDrop && !world.field_72995_K) {
            IBlockState block = world.func_180495_p(pos);
            ItemStack itemStack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block));
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
            world.func_72838_d((Entity)entityItem);
            world.func_175698_g(pos);
        }
    }

    public static boolean isOutputMarker(int operandType) {
        return operandType == 1 || operandType == 2 || operandType == 3 || operandType == 4 || operandType == 5 || operandType == 7 || operandType == 8;
    }

    public static boolean isInputMarker(int operandType) {
        return operandType == 0 || operandType == 5 || operandType == 6 || operandType == 8;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public BlockAMContainer registerAndName(ResourceLocation rl) {
        this.func_149663_c(rl.toString());
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)rl);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockCrystalMarker((Block)this), (ResourceLocation)rl);
        return this;
    }
}

