/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.math.AMVector3;
import am2.blocks.BlockArsMagicaBlock;
import am2.blocks.BlockEffigy;
import am2.bosses.BossSpawnHelper;
import am2.defs.BlockDefs;
import am2.defs.CreativeTabsDefs;
import am2.items.ItemBlockSubtypes;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockInlay
extends BlockRailBase {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177709_a((String)"shape", BlockRailBase.EnumRailDirection.class);
    private final int material;
    public static final int TYPE_REDSTONE = 0;
    public static final int TYPE_IRON = 1;
    public static final int TYPE_GOLD = 2;
    private static final String minecartGoldInlayKey = "AM2GoldInlayTimer";

    public BlockInlay(int type) {
        super(false);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabsDefs.tabAM2Blocks);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", -1);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH));
        this.material = type;
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        if (block.func_176223_P().func_185897_m() && this.countAdjacentRails(world, pos) == 3) {
            this.func_176564_a(world, pos, state, false);
        }
    }

    protected int countAdjacentRails(World world, BlockPos pos) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!BlockRailBase.func_176562_d((World)world, (BlockPos)pos.func_177972_a(enumfacing)) && !BlockRailBase.func_176562_d((World)world, (BlockPos)pos.func_177972_a(enumfacing).func_177984_a()) && !BlockRailBase.func_176562_d((World)world, (BlockPos)pos.func_177972_a(enumfacing).func_177977_b())) continue;
            ++i;
        }
        return i;
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        AMParticle particle;
        if (world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c().isAir(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b()) && ArsMagica2.config.FullGFX() && rand.nextInt(10) < 8 && (particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(world, ArsMagica2.config.FullGFX() ? "radiant" : "sparkle2", (float)pos.func_177958_n() + rand.nextFloat(), pos.func_177956_o(), (float)pos.func_177952_p() + rand.nextFloat()))) != null) {
            particle.func_187114_a(20);
            particle.setParticleScale(ArsMagica2.config.FullGFX() ? 0.015f : 0.15f);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.01f, -0.025f, 1, false));
            if (this == BlockDefs.redstoneInlay) {
                particle.setRGBColorF(1.0f, 0.4f, 0.4f);
            } else if (this == BlockDefs.ironInlay) {
                particle.setRGBColorF(1.0f, 1.0f, 1.0f);
            } else if (this == BlockDefs.goldInlay) {
                particle.setRGBColorF(1.0f, 1.0f, 0.2f);
            }
        }
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.field_72995_K) {
            this.func_189541_b(state, worldIn, pos, blockIn);
        }
    }

    public int func_149738_a(World par1World) {
        return 60 + par1World.field_73012_v.nextInt(80);
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        if (this.material == 0) {
            return 0.7f;
        }
        return 0.4f;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)).func_177015_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.SOUTH_EAST) {
                this.checkPattern(worldIn, pos);
            }
            worldIn.func_180497_b(pos, (Block)this, this.func_149738_a(worldIn), 0);
        }
    }

    private void checkPattern(World world, BlockPos pos) {
        boolean allGood = true;
        for (int i = 0; i <= 2; ++i) {
            for (int j = 0; j <= 2; ++j) {
                if (i == 1 && j == 1) continue;
                allGood &= world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() == this;
            }
        }
        if (allGood && !world.field_72995_K && !this.checkForIceEffigy(world, pos)) {
            this.checkForLightningEffigy(world, pos);
        }
    }

    private boolean checkForIceEffigy(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177982_a(1, 0, 1)).func_177230_c() == BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.BLUETOPAZ)).func_177230_c() && world.func_180495_p(pos.func_177982_a(1, 1, 1)).func_177230_c() == BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.BLUETOPAZ)).func_177230_c() && world.func_180495_p(pos.func_177982_a(1, 2, 1)).func_177230_c() == BlockDefs.iceEffigy) {
            IBlockState state = world.func_180495_p(pos.func_177982_a(1, 2, 1));
            int iceMeta = (Integer)world.func_180495_p(pos.func_177982_a(1, 2, 1)).func_177229_b((IProperty)BlockEffigy.PROGRESS);
            if (iceMeta > 0) {
                ArsMagica2.proxy.particleManager.RibbonFromPointToPoint(world, (double)pos.func_177958_n() + 1.5, pos.func_177956_o() + 2, (double)pos.func_177952_p() + 1.5, pos.func_177958_n() + 2, pos.func_177956_o() + 3, pos.func_177952_p() + 2);
            }
            if (iceMeta >= 3) {
                BossSpawnHelper.instance.onIceEffigyBuilt(world, pos.func_177982_a(1, 0, 1));
            } else {
                List snowmen = world.func_72872_a(EntitySnowman.class, new AxisAlignedBB((double)(pos.func_177958_n() - 9), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 9), (double)(pos.func_177958_n() + 10), (double)(pos.func_177956_o() + 4), (double)(pos.func_177952_p() + 10)));
                if (snowmen.size() > 0) {
                    ((EntitySnowman)snowmen.get(0)).func_70097_a((DamageSource)DamageSources.unsummon, 5000.0f);
                    world.func_175656_a(pos.func_177982_a(1, 2, 1), state.func_177226_a((IProperty)BlockEffigy.PROGRESS, (Comparable)Integer.valueOf(++iceMeta)));
                    ArsMagica2.proxy.particleManager.BeamFromEntityToPoint(world, (Entity)snowmen.get(0), (double)pos.func_177958_n() + 1.5, (double)pos.func_177956_o() + 2.5, (double)pos.func_177952_p() + 1.5);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkForLightningEffigy(World world, BlockPos pos) {
        if (!world.func_72896_J()) {
            return false;
        }
        if (world.func_180495_p(pos.func_177982_a(1, 0, 1)).func_177230_c() == BlockDefs.manaBattery && world.func_180495_p(pos.func_177982_a(1, 1, 1)).func_177230_c() == Blocks.field_150411_aY && world.func_180495_p(pos.func_177982_a(1, 2, 1)).func_177230_c() == BlockDefs.lightningEffigy) {
            IBlockState state = world.func_180495_p(pos.func_177982_a(1, 2, 1));
            int fenceMeta = (Integer)world.func_180495_p(pos.func_177982_a(1, 2, 1)).func_177229_b((IProperty)BlockEffigy.PROGRESS);
            if (fenceMeta > 0) {
                ArsMagica2.proxy.particleManager.RibbonFromPointToPoint(world, (double)pos.func_177958_n() + 1.5, pos.func_177956_o() + 2, (double)pos.func_177952_p() + 1.5, pos.func_177958_n() + 2, pos.func_177956_o() + 3, pos.func_177952_p() + 2);
            }
            world.func_175656_a(pos.func_177982_a(1, 2, 1), state.func_177226_a((IProperty)BlockEffigy.PROGRESS, (Comparable)Integer.valueOf(++fenceMeta)));
            if (!world.field_72995_K) {
                int i;
                for (i = 0; i < 5; ++i) {
                    ArsMagica2.proxy.particleManager.BoltFromPointToPoint(world, (double)pos.func_177958_n() + 1.5, pos.func_177956_o() + 30, (double)pos.func_177952_p() + 1.5, (double)pos.func_177958_n() + 1.5, pos.func_177956_o() + 2, (double)pos.func_177952_p() + 1.5);
                }
                for (i = 0; i < fenceMeta; ++i) {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187754_de, SoundCategory.AMBIENT, 1.0f, world.field_73012_v.nextFloat() + 0.5f, false);
                }
            }
            if (fenceMeta >= 3) {
                BossSpawnHelper.instance.onLightningEffigyBuilt(world, pos.func_177982_a(1, 0, 1));
            }
            return true;
        }
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        if (cart == null) {
            return;
        }
        long millisSinceLastTeleport = cart.getEntityData().func_74763_f(minecartGoldInlayKey);
        BlockRailBase.EnumRailDirection meta = (BlockRailBase.EnumRailDirection)world.func_180495_p(pos).func_177229_b(SHAPE);
        if (this.material == 0) {
            float limit = 2.0f;
            if (meta == BlockRailBase.EnumRailDirection.EAST_WEST) {
                if (cart.field_70159_w > 0.0 && cart.field_70159_w < (double)limit) {
                    cart.field_70159_w *= (double)1.1f;
                } else if (cart.field_70159_w < 0.0 && cart.field_70159_w > (double)(-limit)) {
                    cart.field_70159_w *= (double)1.1f;
                }
            } else if (meta == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                if (cart.field_70179_y > 0.0 && cart.field_70179_y < (double)limit) {
                    cart.field_70179_y *= (double)1.1f;
                } else if (cart.field_70179_y < 0.0 && cart.field_70179_y > (double)(-limit)) {
                    cart.field_70179_y *= (double)1.1f;
                }
            }
        } else if (this.material == 1) {
            if (meta == BlockRailBase.EnumRailDirection.EAST_WEST) {
                cart.field_70159_w = -cart.field_70159_w * 0.5;
                if (cart.field_70159_w < 0.0) {
                    cart.func_70107_b((double)pos.func_177958_n() - 0.02, cart.field_70163_u, cart.field_70161_v);
                } else if (cart.field_70159_w > 0.0) {
                    cart.func_70107_b((double)pos.func_177958_n() + 1.02, cart.field_70163_u, cart.field_70161_v);
                }
            } else if (meta == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                cart.field_70179_y = -cart.field_70179_y * 0.5;
                if (cart.field_70179_y < 0.0) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)pos.func_177952_p() - 0.02);
                } else if (cart.field_70179_y > 0.0) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)pos.func_177952_p() + 1.02);
                }
            }
        } else if (this.material == 2) {
            boolean cooldownPassed;
            int i;
            AMVector3 teleportLocation = null;
            if (meta == BlockRailBase.EnumRailDirection.EAST_WEST) {
                if (cart.field_70159_w > 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_180495_p(pos.func_177982_a(i, 0, 0)).func_177230_c() != BlockDefs.goldInlay) continue;
                        teleportLocation = new AMVector3(pos.func_177982_a(i, 0, 0));
                        break;
                    }
                } else if (cart.field_70159_w < 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_180495_p(pos.func_177982_a(-i, 0, 0)).func_177230_c() != BlockDefs.goldInlay) continue;
                        teleportLocation = new AMVector3(pos.func_177982_a(-i, 0, 0));
                        break;
                    }
                }
            } else if (meta == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                if (cart.field_70179_y > 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_180495_p(pos.func_177982_a(0, 0, i)).func_177230_c() != BlockDefs.goldInlay) continue;
                        teleportLocation = new AMVector3(pos.func_177982_a(0, 0, i));
                        break;
                    }
                } else if (cart.field_70179_y < 0.0) {
                    for (i = 1; i <= 8; ++i) {
                        if (world.func_180495_p(pos.func_177982_a(0, 0, -i)).func_177230_c() != BlockDefs.goldInlay) continue;
                        teleportLocation = new AMVector3(pos.func_177982_a(0, 0, -i));
                        break;
                    }
                }
            }
            BlockRailBase.EnumRailDirection teleportMeta = teleportLocation != null ? (BlockRailBase.EnumRailDirection)world.func_180495_p(teleportLocation.toBlockPos()).func_177229_b(SHAPE) : null;
            long time = System.currentTimeMillis();
            boolean bl = cooldownPassed = time - millisSinceLastTeleport > 5000L;
            if (teleportLocation != null && (teleportMeta == BlockRailBase.EnumRailDirection.EAST_WEST || teleportMeta == BlockRailBase.EnumRailDirection.NORTH_SOUTH) && cooldownPassed) {
                world.func_184134_a((double)teleportLocation.x, (double)teleportLocation.y, (double)teleportLocation.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                world.func_184134_a(cart.field_70165_t, cart.field_70163_u, cart.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                cart.func_70107_b((double)teleportLocation.x, (double)teleportLocation.y, (double)teleportLocation.z);
                cart.getEntityData().func_74772_a(minecartGoldInlayKey, time);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.01f, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return blockState.func_185900_c((IBlockAccess)worldIn, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        if (entityIn instanceof EntityMinecart) {
            return;
        }
        BlockInlay.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d(worldIn, pos));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_180497_b(pos, (Block)this, this.func_149738_a(worldIn), 0);
    }

    public BlockInlay registerAndName(ResourceLocation rl) {
        this.func_149663_c(rl.toString());
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)rl);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockSubtypes((Block)this), (ResourceLocation)rl);
        return this;
    }
}

