/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.render;

import am2.blocks.BlockEssenceGenerator;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.defs.BlockDefs;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.opengl.GL11;

public class TileObeliskRenderer
extends TileEntitySpecialRenderer<TileEntityObelisk> {
    IModel defaultModel;
    IModel activeModel;
    IModel highPowerModel;
    IModel runesModel;
    IBakedModel defaultBakedModel;
    IBakedModel activeBakedModel;
    IBakedModel highPowerBakedModel;
    IBakedModel runesBakedModel;

    private void bake() {
        try {
            this.defaultModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("arsmagica2", "block/obelisk.obj"));
            this.activeModel = ((OBJModel)this.defaultModel).retexture(ImmutableMap.of((Object)"#Material", (Object)"arsmagica2:blocks/custom/obelisk_active"));
            this.highPowerModel = ((OBJModel)this.defaultModel).retexture(ImmutableMap.of((Object)"#Material", (Object)"arsmagica2:blocks/custom/obelisk_active_highpower"));
            this.runesModel = ((OBJModel)this.defaultModel).retexture(ImmutableMap.of((Object)"#Material", (Object)"arsmagica2:blocks/custom/obelisk_runes"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Function getter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        this.defaultBakedModel = this.defaultModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, getter);
        this.activeBakedModel = this.activeModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, getter);
        this.highPowerBakedModel = this.highPowerModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, getter);
        this.runesBakedModel = this.runesModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, getter);
    }

    public void renderTileEntityAt(TileEntityObelisk te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!te.func_145831_w().func_175668_a(te.func_174877_v(), false) || te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() != BlockDefs.obelisk) {
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        EnumFacing facing = EnumFacing.NORTH;
        if (te.func_145830_o()) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            facing = (EnumFacing)state.func_177229_b(BlockEssenceGenerator.FACING);
        }
        if (facing == EnumFacing.WEST || facing == EnumFacing.SOUTH) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (facing == EnumFacing.SOUTH || facing == EnumFacing.EAST) {
            GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)(180.0f - facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (te.func_145830_o()) {
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), this.getBakedModel(te), te.func_145831_w().func_180495_p(te.func_174877_v()), te.func_174877_v(), tessellator.func_178180_c(), false);
        } else {
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, this.getBakedModel(te), BlockDefs.obelisk.func_176223_P(), new BlockPos(0, 0, 0), tessellator.func_178180_c(), false);
        }
        tessellator.func_78381_a();
        if (te.isActive()) {
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GlStateManager.func_179147_l();
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("arsmagica2:blocks/custom/obelisk_runes");
            GlStateManager.func_179152_a((float)(1.0f / (sprite.func_94212_f() - sprite.func_94209_e())), (float)(1.0f / (sprite.func_94210_h() - sprite.func_94206_g())), (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("arsmagica2:textures/blocks/custom/obelisk_runes.png"));
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
            float normx = (float)(System.currentTimeMillis() % 32000L) / 32000.0f;
            float normy = (float)(System.currentTimeMillis() % 28000L) / 28000.0f;
            GL11.glTranslatef((float)normx, (float)normy, (float)0.0f);
            float transp = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transp);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), this.runesBakedModel, te.func_145831_w().func_180495_p(te.func_174877_v()), te.func_174877_v(), tessellator.func_178180_c(), false);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GlStateManager.func_179084_k();
            GL11.glMatrixMode((int)5888);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private IBakedModel getBakedModel(TileEntityObelisk obelisk) {
        this.bake();
        if (obelisk.isHighPowerActive()) {
            return this.highPowerBakedModel;
        }
        if (obelisk.isActive()) {
            return this.activeBakedModel;
        }
        return this.defaultBakedModel;
    }
}

