/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.ArsMagicaAPI;
import am2.api.blocks.IKeystoneLockable;
import am2.api.spell.AbstractSpellPart;
import am2.api.spell.SpellComponent;
import am2.api.spell.SpellModifier;
import am2.api.spell.SpellShape;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.defs.ItemDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleHoldPosition;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.spell.component.Summon;
import am2.spell.shape.Binding;
import am2.utils.InventoryUtilities;
import am2.utils.RecipeUtils;
import am2.utils.SpellUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityArcaneDeconstructor
extends TileEntityAMPower
implements IInventory,
ISidedInventory,
IKeystoneLockable<TileEntityArcaneDeconstructor> {
    private int particleCounter;
    private static final float DECONSTRUCTION_POWER_COST = 1.25f;
    private static final int DECONSTRUCTION_TIME = 200;
    private int current_deconstruction_time = 0;
    private static final ArrayList<PowerTypes> validPowerTypes = Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.DARK});
    @SideOnly(value=Side.CLIENT)
    AMParticle radiant;
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private ItemStack[] deconstructionRecipe;

    public TileEntityArcaneDeconstructor() {
        super(500);
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 250;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.particleCounter == 0 || this.particleCounter++ > 1000) {
                this.particleCounter = 1;
                this.radiant = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "radiant", (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f));
                if (this.radiant != null) {
                    this.radiant.func_187114_a(1000);
                    this.radiant.setRGBColorF(0.1f, 0.1f, 0.1f);
                    this.radiant.setParticleScale(0.1f);
                    this.radiant.AddParticleController(new ParticleHoldPosition(this.radiant, 1000, 1, false));
                }
            }
        } else if (!this.isActive()) {
            if (this.inventory[0] != null) {
                this.current_deconstruction_time = 1;
            }
        } else if (this.inventory[0] == null) {
            this.current_deconstruction_time = 0;
            this.deconstructionRecipe = null;
            this.func_70296_d();
        } else if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, 1.25f)) {
            if (this.deconstructionRecipe == null) {
                if (!this.getDeconstructionRecipe()) {
                    this.transferOrEjectItem(this.inventory[0]);
                    this.func_70299_a(0, null);
                }
            } else {
                if (this.current_deconstruction_time++ >= 200) {
                    if (this.getDeconstructionRecipe()) {
                        for (ItemStack stack : this.deconstructionRecipe) {
                            this.transferOrEjectItem(stack);
                        }
                    }
                    this.deconstructionRecipe = null;
                    this.func_70298_a(0, 1);
                    this.current_deconstruction_time = 0;
                }
                if (this.current_deconstruction_time % 10 == 0) {
                    this.func_70296_d();
                }
            }
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.DARK, 1.25f);
        }
    }

    private boolean getDeconstructionRecipe() {
        ItemStack checkStack = this.func_70301_a(0);
        ArrayList<ItemStack> recipeItems = new ArrayList<ItemStack>();
        if (checkStack == null) {
            return false;
        }
        if (checkStack.func_77973_b() == ItemDefs.spell) {
            ItemStack stack;
            int numStages = SpellUtils.numStages(checkStack);
            for (int i = 0; i < numStages; ++i) {
                int n;
                SpellShape shape = SpellUtils.getShapeForStage(checkStack, i);
                Object[] componentParts = shape.getRecipe();
                if (componentParts != null) {
                    for (Object object : componentParts) {
                        ItemStack stack2 = this.objectToItemStack(object);
                        if (stack2 == null) continue;
                        if (stack2.func_77973_b() == ItemDefs.bindingCatalyst) {
                            stack2.func_77964_b(((Binding)ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation("arsmagica2", "binding"))).getBindingType(checkStack));
                        }
                        recipeItems.add(stack2.func_77946_l());
                    }
                }
                ArrayList<SpellComponent> components = SpellUtils.getComponentsForStage(checkStack, i);
                for (SpellComponent component : components) {
                    componentParts = component.getRecipe();
                    if (componentParts == null) continue;
                    Object[] objectArray = componentParts;
                    int n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        Object o2 = objectArray[n];
                        stack = this.objectToItemStack(o2);
                        if (stack == null) continue;
                        if (stack.func_77973_b() == ItemDefs.crystalPhylactery) {
                            ItemDefs.crystalPhylactery.setSpawnClass(stack, ((Summon)ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation("arsmagica2", "summon"))).getSummonType(checkStack));
                            ItemDefs.crystalPhylactery.addFill(stack, 100.0f);
                        }
                        recipeItems.add(stack.func_77946_l());
                    }
                }
                ArrayList<SpellModifier> modifiers = SpellUtils.getModifiersForStage(checkStack, i);
                for (SpellModifier spellModifier : modifiers) {
                    componentParts = spellModifier.getRecipe();
                    if (componentParts == null) continue;
                    Object[] objectArray = componentParts;
                    n = objectArray.length;
                    for (int o2 = 0; o2 < n; ++o2) {
                        Object o = objectArray[o2];
                        ItemStack stack3 = this.objectToItemStack(o);
                        if (stack3 == null) continue;
                        recipeItems.add(stack3.func_77946_l());
                    }
                }
            }
            int numShapeGroups = SpellUtils.numShapeGroups(checkStack);
            for (int i = 0; i < numShapeGroups; ++i) {
                ArrayList<AbstractSpellPart> parts = SpellUtils.getShapeGroupParts(checkStack, i);
                for (AbstractSpellPart entry : parts) {
                    Object[] componentParts = null;
                    if (entry != null) {
                        componentParts = entry.getRecipe();
                    }
                    if (componentParts == null) continue;
                    for (Object o : componentParts) {
                        stack = this.objectToItemStack(o);
                        if (stack == null) continue;
                        if (stack.func_77973_b() == ItemDefs.bindingCatalyst) {
                            stack.func_77964_b(((Binding)ArsMagicaAPI.getSpellRegistry().getObject(new ResourceLocation("arsmagica2", "binding"))).getBindingType(checkStack));
                        }
                        recipeItems.add(stack.func_77946_l());
                    }
                }
            }
            this.deconstructionRecipe = recipeItems.toArray(new ItemStack[recipeItems.size()]);
            return true;
        }
        IRecipe recipe = RecipeUtils.getRecipeFor(checkStack);
        if (recipe == null) {
            return false;
        }
        Object[] recipeParts = RecipeUtils.getRecipeItems(recipe);
        if (recipeParts != null && checkStack != null && recipe.func_77571_b() != null) {
            if (recipe.func_77571_b().func_77973_b() == checkStack.func_77973_b() && recipe.func_77571_b().func_77952_i() == checkStack.func_77952_i() && recipe.func_77571_b().field_77994_a > 1) {
                return false;
            }
            for (Object o : recipeParts) {
                ItemStack stack = this.objectToItemStack(o);
                if (stack == null || stack.func_77973_b().hasContainerItem(stack)) continue;
                stack.field_77994_a = 1;
                recipeItems.add(stack.func_77946_l());
            }
        }
        this.deconstructionRecipe = recipeItems.toArray(new ItemStack[recipeItems.size()]);
        return true;
    }

    private ItemStack objectToItemStack(Object o) {
        ItemStack output = null;
        if (o instanceof ItemStack) {
            output = (ItemStack)o;
        } else if (o instanceof Item) {
            output = new ItemStack((Item)o);
        } else if (o instanceof Block) {
            output = new ItemStack((Block)o);
        } else if (o instanceof List) {
            output = this.objectToItemStack(((List)o).get(0));
        }
        if (output != null && output.field_77994_a == 0) {
            output.field_77994_a = 1;
        }
        return output;
    }

    private void transferOrEjectItem(ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(i, j, k))) == null || !(te instanceof IInventory)) continue;
                    for (EnumFacing side : EnumFacing.values()) {
                        if (!InventoryUtilities.mergeIntoInventory((IInventory)te, stack, stack.field_77994_a, side)) continue;
                        return;
                    }
                }
            }
        }
        EntityItem item = new EntityItem(this.field_145850_b);
        item.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        item.func_92058_a(stack);
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public boolean isActive() {
        return this.current_deconstruction_time > 0;
    }

    public int func_70302_i_() {
        return 16;
    }

    public ItemStack func_70301_a(int var1) {
        if (var1 >= this.inventory.length) {
            return null;
        }
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "ArcaneDeconstructor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i <= 9;
    }

    public int[] func_180463_a(EnumFacing var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return i == 0;
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return i >= 1 && i <= 9;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        return new ItemStack[]{this.inventory[13], this.inventory[14], this.inventory[15]};
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return validPowerTypes;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("DeconstructorInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.current_deconstruction_time = nbttagcompound.func_74762_e("DeconstructionTime");
        if (this.current_deconstruction_time > 0) {
            this.getDeconstructionRecipe();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("DeconstructorInventory", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a("DeconstructionTime", this.current_deconstruction_time);
        return nbttagcompound;
    }

    public int getProgressScaled(int i) {
        return this.current_deconstruction_time * i / 200;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

