/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.blocks.IKeystoneLockable;
import am2.api.items.ISpellFocus;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleHoldPosition;
import am2.particles.ParticleOrbitPoint;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;

public class TileEntityAstralBarrier
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable<TileEntityAstralBarrier> {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private boolean displayAura = false;
    private int particleTickCounter = 0;
    public static int keystoneSlot = 0;

    public TileEntityAstralBarrier() {
        super(250);
    }

    public void ToggleAuraDisplay() {
        this.displayAura = !this.displayAura;
    }

    public int getRadius() {
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof ISpellFocus) {
            ISpellFocus focus = (ISpellFocus)this.inventory[0].func_77973_b();
            return (focus.getFocusLevel() + 1) * 5;
        }
        return 0;
    }

    public boolean IsActive() {
        return PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 0.35f * (float)this.getRadius()) && this.field_145850_b.func_175687_A(this.field_174879_c) > 0 && this.getRadius() > 0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        int radius = this.getRadius();
        if (this.IsActive()) {
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 0.35f * (float)radius);
        }
        if (this.field_145850_b.field_72995_K && this.IsActive()) {
            AMParticle effect;
            if (this.displayAura && (effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "symbols", this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p()))) != null) {
                effect.setIgnoreMaxAge(false);
                effect.func_187114_a(100);
                effect.setParticleScale(0.5f);
                effect.AddParticleController(new ParticleOrbitPoint(effect, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, false).SetOrbitSpeed(0.03).SetTargetDistance(radius));
            }
            ++this.particleTickCounter;
            if (this.particleTickCounter >= 15) {
                this.particleTickCounter = 0;
                effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "sparkle", (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.1 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_174879_c.func_177952_p() + 0.5));
                if (effect != null) {
                    effect.setIgnoreMaxAge(false);
                    effect.func_187114_a(100);
                    effect.setParticleScale(0.5f);
                    effect.AddParticleController(new ParticleOrbitPoint(effect, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, false).SetOrbitSpeed(0.005).SetTargetDistance(this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3));
                    effect.AddParticleController(new ParticleHoldPosition(effect, 80, 2, true));
                    effect.AddParticleController(new ParticleFadeOut(effect, 3, false).setFadeSpeed(0.05f));
                }
            }
        }
    }

    public void onEntityBlocked(EntityLivingBase entity) {
        if (this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.DARK, 50.0f)) {
            entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.DARK, 50.0f);
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Astral Barrier";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("AstralBarrierInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("AstralBarrierInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 50;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[1], this.inventory[2], this.inventory[3]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

