/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.DamageSources;
import am2.api.IMultiblockStructureController;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.api.math.AMVector3;
import am2.blocks.BlockArsMagicaBlock;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.buffs.BuffEffectAstralDistortion;
import am2.buffs.BuffEffectManaRegen;
import am2.defs.BlockDefs;
import am2.defs.PotionEffectsDefs;
import am2.entity.EntityAirSled;
import am2.entity.EntityBroom;
import am2.entity.EntityDarkling;
import am2.entity.EntityFlicker;
import am2.entity.EntityShadowHelper;
import am2.entity.EntityThrownRock;
import am2.entity.EntityThrownSickle;
import am2.entity.EntityWinterGuardianArm;
import am2.particles.AMLineArc;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import am2.utils.EntityUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class TileEntityBlackAurem
extends TileEntityObelisk
implements IMultiblockStructureController {
    private final HashMap<EntityLivingBase, AMLineArc> arcs = new HashMap();
    private final ArrayList<EntityLivingBase> cachedEntities = new ArrayList();
    private int ticksSinceLastEntityScan = 0;

    public TileEntityBlackAurem() {
        super(10000);
        this.structure = new MultiblockStructureDefinition("blackaurem_structure");
        this.pillars = new MultiblockGroup("pillars", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150385_bj.func_176223_P()}), false);
        this.caps = new HashMap();
        this.capsGroup = new TypedMultiblockGroup("caps", Lists.newArrayList((Object[])new HashMap[]{this.createMap(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.SUNSTONE))), this.createMap(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.CHIMERITE))), this.createMap(Blocks.field_150343_Z.func_176223_P())}), false);
        this.caps.put(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.CHIMERITE)), Float.valueOf(1.1f));
        this.caps.put(Blocks.field_150343_Z.func_176223_P(), Float.valueOf(1.5f));
        this.caps.put(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.SUNSTONE)), Float.valueOf(2.0f));
        MultiblockGroup aurem = new MultiblockGroup("aurem", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.blackAurem.func_176223_P()}), true);
        aurem.addBlock(BlockPos.field_177992_a);
        this.capsGroup.addBlock(new BlockPos(-2, 2, -2), 0);
        this.capsGroup.addBlock(new BlockPos(2, 2, -2), 0);
        this.capsGroup.addBlock(new BlockPos(-2, 2, 2), 0);
        this.capsGroup.addBlock(new BlockPos(2, 2, 2), 0);
        this.pillars.addBlock(new BlockPos(-2, 0, -2));
        this.pillars.addBlock(new BlockPos(-2, 1, -2));
        this.pillars.addBlock(new BlockPos(2, 0, -2));
        this.pillars.addBlock(new BlockPos(2, 1, -2));
        this.pillars.addBlock(new BlockPos(-2, 0, 2));
        this.pillars.addBlock(new BlockPos(-2, 1, 2));
        this.pillars.addBlock(new BlockPos(2, 0, 2));
        this.pillars.addBlock(new BlockPos(2, 1, 2));
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure);
        this.structure.addGroup(this.pillars, new MultiblockGroup[0]);
        this.structure.addGroup(this.capsGroup, new MultiblockGroup[0]);
        this.structure.addGroup(this.wizardChalkCircle, new MultiblockGroup[0]);
        this.structure.addGroup(aurem, new MultiblockGroup[0]);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.surroundingCheckTicks;
        }
        if (this.field_145850_b.field_72995_K || this.ticksSinceLastEntityScan++ > 25) {
            this.updateNearbyEntities();
            this.ticksSinceLastEntityScan = 0;
        }
        Iterator<EntityLivingBase> it = this.cachedEntities.iterator();
        while (it.hasNext()) {
            EntityLivingBase ent;
            block21: {
                block20: {
                    ent = it.next();
                    if (!ent.func_70644_a(PotionEffectsDefs.astralDistortion)) {
                        ent.func_70690_d((PotionEffect)new BuffEffectAstralDistortion(600, 0));
                    }
                    if (ent.field_70128_L) break block20;
                    AMVector3 aMVector3 = new AMVector3(this.field_174879_c);
                    AMVector3 aMVector32 = new AMVector3((Entity)ent);
                    if (!(aMVector3.distanceTo(aMVector32) > 10.0)) break block21;
                }
                it.remove();
                continue;
            }
            RayTraceResult mop = this.field_145850_b.func_72901_a(new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5), new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v), false);
            if (EntityUtils.isSummon(ent) || mop != null) continue;
            ent.field_70181_x = 0.0;
            ent.field_70159_w = 0.0;
            ent.field_70179_y = 0.0;
            double deltaX = (double)((float)this.field_174879_c.func_177958_n() + 0.5f) - ent.field_70165_t;
            double deltaZ = (double)((float)this.field_174879_c.func_177952_p() + 0.5f) - ent.field_70161_v;
            double angle = Math.atan2(deltaZ, deltaX);
            double offsetX = Math.cos(angle) * 0.1;
            double offsetZ = Math.sin(angle) * 0.1;
            double offsetY = 0.05f;
            double distanceHorizontal = deltaX * deltaX + deltaZ * deltaZ;
            double distanceVertical = (double)this.field_174879_c.func_177956_o() - ent.field_70163_u;
            if (distanceHorizontal < 1.3 * Math.max(1.0, Math.abs(distanceVertical / 2.0))) {
                if (distanceVertical < -1.5 && this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(10) < 3) {
                    ArsMagica2.proxy.particleManager.BoltFromPointToPoint(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, 4, 0);
                }
                if (distanceVertical < -2.0) {
                    offsetY = 0.0;
                    if (!this.field_145850_b.field_72995_K && ent.func_70097_a((DamageSource)DamageSources.darkNexus, 4.0f) && ent.func_110143_aJ() <= 0.0f) {
                        ent.func_70106_y();
                        float power = (float)((int)Math.ceil(ent.func_110138_aP() * (float)(ent.field_70173_aa / 20) % 5000.0f)) * this.powerMultiplier;
                        PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.DARK, power);
                    }
                }
            }
            if (this.field_145850_b.field_72995_K) {
                if (!this.arcs.containsKey(ent)) {
                    AMLineArc arc = (AMLineArc)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "textures/blocks/oreblocksunstone.png", (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5, (Entity)ent));
                    if (arc != null) {
                        arc.setExtendToTarget();
                        arc.func_70538_b(1.0f, 1.0f, 1.0f);
                    }
                    this.arcs.put(ent, arc);
                }
                Iterator<EntityLivingBase> arcIterator = this.arcs.keySet().iterator();
                ArrayList<Entity> toRemove = new ArrayList<Entity>();
                while (arcIterator.hasNext()) {
                    Entity arcEnt = (Entity)arcIterator.next();
                    AMLineArc arc = this.arcs.get(arcEnt);
                    if (arcEnt != null && !arcEnt.field_70128_L && arc != null && arc.func_187113_k()) {
                        AMVector3 aMVector3 = new AMVector3((Entity)ent);
                        AMVector3 aMVector33 = new AMVector3(this.field_174879_c);
                        if (!(aMVector3.distanceSqTo(aMVector33) > 100.0)) continue;
                    }
                    toRemove.add(arcEnt);
                }
                for (Entity e : toRemove) {
                    this.arcs.remove(e);
                }
            }
            if (this.field_145850_b.field_72995_K) continue;
            ent.func_70091_d(offsetX, offsetY, offsetZ);
        }
        if (this.surroundingCheckTicks % 100 == 0) {
            this.checkNearbyBlockState();
            this.surroundingCheckTicks = 1;
            if (!this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, 0, -2), this.field_174879_c.func_177982_a(2, 3, 2)));
                for (EntityPlayer p : nearbyPlayers) {
                    if (p.func_70644_a(PotionEffectsDefs.manaRegen)) continue;
                    p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 2));
                }
            }
        }
        super.callSuperUpdate();
    }

    private void updateNearbyEntities() {
        List nearbyEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-10, 0, -10), this.field_174879_c.func_177982_a(10, 4, 10)));
        for (EntityLivingBase entity : nearbyEntities) {
            if (entity.func_180431_b((DamageSource)DamageSources.darkNexus) || !entity.func_184222_aU() || entity instanceof EntityDarkling || entity instanceof EntityPlayer || entity instanceof EntityAirSled || entity instanceof EntityWinterGuardianArm || entity instanceof EntityThrownSickle || entity instanceof EntityFlicker || entity instanceof EntityShadowHelper || entity instanceof EntityThrownRock || entity instanceof EntityBroom || this.cachedEntities.contains(entity)) continue;
            this.cachedEntities.add(entity);
        }
        this.ticksSinceLastEntityScan = 0;
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.DARK;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.DARK});
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }
}

