/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.IMultiblockStructureController;
import am2.api.blocks.MultiblockGroup;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.blocks.TypedMultiblockGroup;
import am2.blocks.BlockArsMagicaBlock;
import am2.blocks.tileentity.TileEntityObelisk;
import am2.buffs.BuffEffectManaRegen;
import am2.defs.BlockDefs;
import am2.defs.PotionEffectsDefs;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityCelestialPrism
extends TileEntityObelisk
implements IMultiblockStructureController {
    private int particleCounter = 0;
    private boolean onlyChargeAtNight = false;

    public TileEntityCelestialPrism() {
        super(2500);
        this.powerBase = 1.0f;
        this.structure = new MultiblockStructureDefinition("celestialprism_structure");
        this.capsGroup = new TypedMultiblockGroup("caps", Lists.newArrayList((Object[])new HashMap[]{this.createMap(Blocks.field_150359_w.func_176223_P()), this.createMap(Blocks.field_150340_R.func_176223_P()), this.createMap(Blocks.field_150484_ah.func_176223_P()), this.createMap(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.MOONSTONE)))}), false);
        this.pillars = new MultiblockGroup("pillars", Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150371_ca.func_176223_P()}), false);
        this.caps = new HashMap();
        this.caps.put(Blocks.field_150359_w.func_176223_P(), Float.valueOf(1.1f));
        this.caps.put(Blocks.field_150340_R.func_176223_P(), Float.valueOf(1.4f));
        this.caps.put(Blocks.field_150484_ah.func_176223_P(), Float.valueOf(2.0f));
        this.caps.put(BlockDefs.blocks.func_176223_P().func_177226_a(BlockArsMagicaBlock.BLOCK_TYPE, (Comparable)((Object)BlockArsMagicaBlock.EnumBlockType.MOONSTONE)), Float.valueOf(3.0f));
        MultiblockGroup prism = new MultiblockGroup("prism", Lists.newArrayList((Object[])new IBlockState[]{BlockDefs.celestialPrism.func_176223_P()}), true);
        prism.addBlock(BlockPos.field_177992_a);
        this.pillars.addBlock(new BlockPos(-2, 0, -2));
        this.pillars.addBlock(new BlockPos(-2, 1, -2));
        this.capsGroup.addBlock(new BlockPos(-2, 2, -2), 0);
        this.capsGroup.addBlock(new BlockPos(2, 2, -2), 0);
        this.capsGroup.addBlock(new BlockPos(-2, 2, 2), 0);
        this.capsGroup.addBlock(new BlockPos(2, 2, 2), 0);
        this.pillars.addBlock(new BlockPos(2, 0, -2));
        this.pillars.addBlock(new BlockPos(2, 1, -2));
        this.pillars.addBlock(new BlockPos(-2, 0, 2));
        this.pillars.addBlock(new BlockPos(-2, 1, 2));
        this.pillars.addBlock(new BlockPos(2, 0, 2));
        this.pillars.addBlock(new BlockPos(2, 1, 2));
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure);
        this.structure.addGroup(this.pillars, new MultiblockGroup[0]);
        this.structure.addGroup(this.capsGroup, new MultiblockGroup[0]);
        this.structure.addGroup(this.wizardChalkCircle, new MultiblockGroup[0]);
        this.structure.addGroup(prism, new MultiblockGroup[0]);
    }

    @Override
    protected void checkNearbyBlockState() {
        List<MultiblockGroup> groups = this.structure.getMatchingGroups(this.field_145850_b, this.field_174879_c);
        float capsLevel = 1.0f;
        boolean pillarsFound = false;
        boolean wizChalkFound = false;
        boolean capsFound = false;
        for (MultiblockGroup group : groups) {
            if (group == this.pillars) {
                pillarsFound = true;
                continue;
            }
            if (group == this.wizardChalkCircle) {
                wizChalkFound = true;
                continue;
            }
            if (group != this.capsGroup) continue;
            capsFound = true;
        }
        if (pillarsFound && capsFound) {
            IBlockState capState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 2, 2));
            for (IBlockState cap : this.caps.keySet()) {
                if (capState != cap) continue;
                capsLevel = ((Float)this.caps.get(cap)).floatValue();
                if (cap.func_177230_c() == BlockDefs.blocks && cap.func_177229_b(BlockArsMagicaBlock.BLOCK_TYPE) == BlockArsMagicaBlock.EnumBlockType.MOONSTONE) {
                    this.onlyChargeAtNight = true;
                    break;
                }
                this.onlyChargeAtNight = false;
                break;
            }
        }
        this.powerMultiplier = 1.0f;
        if (wizChalkFound) {
            this.powerMultiplier = 1.25f;
        }
        if (pillarsFound) {
            this.powerMultiplier *= capsLevel;
        }
    }

    private boolean isNight() {
        long ticks = this.field_145850_b.func_72820_D() % 24000L;
        return ticks >= 12500L && ticks <= 23500L;
    }

    @Override
    public void func_73660_a() {
        if (this.surroundingCheckTicks++ % 100 == 0) {
            this.checkNearbyBlockState();
            this.surroundingCheckTicks = 1;
            if (!this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, 0, -2), this.field_174879_c.func_177982_a(2, 3, 2)));
                for (EntityPlayer p : nearbyPlayers) {
                    if (p.func_70644_a(PotionEffectsDefs.manaRegen)) continue;
                    p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 0));
                }
            }
        }
        if (this.onlyChargeAtNight == this.isNight()) {
            PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.LIGHT, 0.25f * this.powerMultiplier);
            if (this.field_145850_b.field_72995_K && this.particleCounter++ % (ArsMagica2.config.FullGFX() ? 60 : (ArsMagica2.config.NoGFX() ? 180 : 120)) == 0) {
                this.particleCounter = 1;
                ArsMagica2.proxy.particleManager.RibbonFromPointToPoint(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat());
            }
        }
        super.callSuperUpdate();
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.LIGHT;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.LIGHT});
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }
}

