/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.api.math.AMVector3;
import am2.blocks.tileentity.TileEntityCraftingAltar;
import am2.blocks.tileentity.TileEntityCrystalMarker;
import am2.defs.BlockDefs;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCrystalMarkerSpellExport
extends TileEntityCrystalMarker {
    static final int RESCAN_INTERVAL = 600;
    static final int UPDATE_INTERVAL = 100;
    ArrayList<AMVector3> craftingAltarCache = new ArrayList();
    int updateCounter = 0;

    public TileEntityCrystalMarkerSpellExport() {
        this(0);
    }

    public TileEntityCrystalMarkerSpellExport(int type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.updateCounter % 600 == 0) {
            this.scanForCraftingAltars();
        }
        if (this.updateCounter % 100 == 0 && this.updateFilter() && this.field_145850_b.field_72995_K) {
            this.spawnParticles();
        }
        ++this.updateCounter;
    }

    private void spawnParticles() {
        for (int i = 0; i < 15; ++i) {
            AMParticle effect = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "sparkle2", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            if (effect == null) continue;
            effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 1, false));
            effect.AddParticleController(new ParticleFadeOut(effect, 2, false).setFadeSpeed(0.035f).setKillParticleOnFinish(true));
            effect.addRandomOffset(0.2, 0.2, 0.2);
            effect.setRGBColorF(0.0f, 0.5f, 1.0f);
            effect.setIgnoreMaxAge(true);
        }
    }

    private void scanForCraftingAltars() {
        this.craftingAltarCache.clear();
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    Block block;
                    if (i == 0 && j == 0 && k == 0 || (block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(i, j, k)).func_177230_c()) != BlockDefs.craftingAltar) continue;
                    this.craftingAltarCache.add(new AMVector3(this.field_174879_c.func_177982_a(i, j, k)));
                }
            }
        }
    }

    private boolean updateFilter() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        Iterator<AMVector3> it = this.craftingAltarCache.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            TileEntityCraftingAltar altar = this.getCATE(it.next());
            if (altar == null) {
                it.remove();
                continue;
            }
            if (!altar.isCrafting()) continue;
            filter.add(altar.getNextPlannedItem());
            changed = true;
        }
        this.filterItems = filter.toArray(new ItemStack[filter.size()]);
        return changed;
    }

    private TileEntityCraftingAltar getCATE(AMVector3 vec) {
        TileEntity te = this.field_145850_b.func_175625_s(vec.toBlockPos());
        if (te != null && te instanceof TileEntityCraftingAltar) {
            return (TileEntityCraftingAltar)te;
        }
        return null;
    }
}

