/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.api.blocks.IKeystoneLockable;
import am2.api.recipes.RecipesEssenceRefiner;
import am2.blocks.BlockEssenceRefiner;
import am2.blocks.tileentity.TileEntityAMPower;
import am2.defs.BlockDefs;
import am2.power.PowerNodeRegistry;
import am2.power.PowerTypes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityEssenceRefiner
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable<TileEntityEssenceRefiner>,
ISidedInventory {
    public static final float REFINE_TIME = 400.0f;
    private static final int OUTPUT_INDEX = 5;
    private static final int FUEL_INDEX = 2;
    public static final float TICK_REFINE_COST = 12.5f;
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    public float remainingRefineTime = 0.0f;

    public TileEntityEssenceRefiner() {
        super(1000);
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return "Essence Refiner";
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("EssenceRefinerInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.remainingRefineTime = nbttagcompound.func_74760_g("RefineTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74776_a("RefineTime", this.remainingRefineTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("EssenceRefinerInventory", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    public int getRefinementProgressScaled(int i) {
        return (int)(this.remainingRefineTime * (float)i / this.getRefineTime());
    }

    public float getRefinementPercentage() {
        if (!this.isRefining()) {
            return 0.0f;
        }
        return 1.0f - this.remainingRefineTime / this.getRefineTime();
    }

    public boolean isRefining() {
        return this.remainingRefineTime > 0.0f;
    }

    private float getRefineTime() {
        return 400.0f;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canRefine()) {
                if (this.remainingRefineTime <= 0.0f) {
                    this.remainingRefineTime = this.getRefineTime();
                    this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                }
            } else if (this.remainingRefineTime != 0.0f) {
                this.remainingRefineTime = 0.0f;
                this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            }
            if (this.isRefining()) {
                this.setActiveTexture();
                if (PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 12.5f)) {
                    this.remainingRefineTime -= 1.0f;
                    if (this.remainingRefineTime % 10.0f == 0.0f) {
                        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                    }
                    if (this.remainingRefineTime <= 0.0f) {
                        this.remainingRefineTime = 0.0f;
                        if (!this.field_145850_b.field_72995_K) {
                            this.refineItem();
                        }
                    }
                    PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 12.5f);
                }
            } else {
                this.setActiveTexture();
            }
        }
    }

    private void setActiveTexture() {
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != BlockDefs.essenceRefiner) {
            this.func_145843_s();
            return;
        }
        if (((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEssenceRefiner.ACTIVE)).booleanValue() == this.isRefining() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isRefining()) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEssenceRefiner.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEssenceRefiner.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private boolean canRefine() {
        if (this.inventory[2] == null) {
            return false;
        }
        ItemStack itemstack = RecipesEssenceRefiner.essenceRefinement().GetResult(this.getCraftingGridContents(), null);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[5] == null) {
            return true;
        }
        if (!this.inventory[5].func_77969_a(itemstack)) {
            return false;
        }
        if (this.inventory[5].field_77994_a < this.func_70297_j_() && this.inventory[5].field_77994_a < this.inventory[5].func_77976_d()) {
            return true;
        }
        return this.inventory[5].field_77994_a < itemstack.func_77976_d();
    }

    public void refineItem() {
        if (!this.canRefine()) {
            return;
        }
        ItemStack itemstack = RecipesEssenceRefiner.essenceRefinement().GetResult(this.getCraftingGridContents(), null);
        if (this.inventory[5] == null) {
            this.inventory[5] = itemstack.func_77946_l();
        } else if (this.inventory[5].func_77973_b() == itemstack.func_77973_b()) {
            this.inventory[5].field_77994_a += itemstack.field_77994_a;
        }
        this.decrementCraftingGridContents();
    }

    private void decrementCraftingGridContents() {
        for (int i = 0; i < 5; ++i) {
            this.decrementCraftingGridSlot(i);
        }
    }

    private void decrementCraftingGridSlot(int slot) {
        if (this.inventory[slot].func_77973_b().func_77634_r()) {
            this.inventory[slot] = new ItemStack(this.inventory[slot].func_77973_b().func_77668_q());
        } else {
            --this.inventory[slot].field_77994_a;
        }
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
    }

    private ItemStack[] getCraftingGridContents() {
        ItemStack[] contents = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            contents[i] = this.inventory[i];
        }
        return contents;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer entityplayer) {
    }

    public void func_174886_c(EntityPlayer entityplayer) {
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 500;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[6], this.inventory[7], this.inventory[8]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    @Override
    public List<PowerTypes> getValidPowerTypes() {
        return Lists.newArrayList((Object[])new PowerTypes[]{PowerTypes.NEUTRAL, PowerTypes.DARK});
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{5};
    }

    public boolean func_180462_a(int p_102007_1_, ItemStack p_102007_2_, EnumFacing p_102007_3_) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return slot == 5;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

