/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentity;

import am2.ArsMagica2;
import am2.blocks.BlockEverstone;
import am2.defs.BlockDefs;
import am2.particles.AMParticle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityEverstone
extends TileEntity
implements ITickable {
    private int reconstructTimer = 0;
    private IBlockState facade = null;
    private static final int reconstructMax = ArsMagica2.config.getEverstoneRepairRate();
    private boolean poweredFromEverstone = false;
    private boolean poweredFromRedstone = false;

    public void setFacade(IBlockState facade) {
        this.facade = facade;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
        }
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    private void propagatePoweredByEverstone(boolean powered, ArrayList<BlockPos> completedUpdates) {
        AMParticle particle;
        BlockPos myPosition = this.field_174879_c;
        if (completedUpdates.contains(myPosition)) {
            return;
        }
        completedUpdates.add(myPosition);
        this.poweredFromEverstone = powered;
        this.onBreak();
        if (this.field_145850_b.field_72995_K && (particle = (AMParticle)((Object)ArsMagica2.proxy.particleManager.spawn(this.field_145850_b, "radiant", (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f))) != null) {
            particle.func_187114_a(20);
            particle.setDontRequireControllers();
            particle.setIgnoreMaxAge(false);
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityEverstone everstone;
                    BlockPos targetPosition = this.field_174879_c.func_177982_a(i, j, k);
                    Block blockID = this.field_145850_b.func_180495_p(targetPosition).func_177230_c();
                    if (blockID != BlockDefs.everstone || completedUpdates.contains(targetPosition) || (everstone = (TileEntityEverstone)this.field_145850_b.func_175625_s(targetPosition)) == null) continue;
                    everstone.propagatePoweredByEverstone(powered, completedUpdates);
                }
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.reconstructTimer <= 0 && this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            this.propagatePoweredByEverstone(true, new ArrayList<BlockPos>());
            this.poweredFromRedstone = true;
        } else if (this.poweredFromRedstone && this.field_145850_b.func_175687_A(this.field_174879_c) == 0) {
            this.poweredFromRedstone = false;
            this.propagatePoweredByEverstone(false, new ArrayList<BlockPos>());
        }
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockEverstone.HAS_FACADE, (Comparable)Boolean.valueOf(this.getFacade() != null)).func_177226_a((IProperty)BlockEverstone.IS_SOLID, (Comparable)Boolean.valueOf(this.isSolid())), 2);
        if (this.reconstructTimer <= 0) {
            return;
        }
        if (this.field_145850_b.func_175687_A(this.field_174879_c) == 0 && !this.poweredFromEverstone) {
            --this.reconstructTimer;
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                if (this.reconstructTimer >= reconstructMax - 20 || this.reconstructTimer <= 20 || this.field_145850_b.field_73012_v.nextInt(10) < 8) {
                    // empty if block
                }
            }
        }
    }

    public int getFadeStrength() {
        if (this.reconstructTimer > reconstructMax / 2) {
            return 0;
        }
        return (int)(128.0f * ((float)(reconstructMax - this.reconstructTimer) / (float)reconstructMax));
    }

    public IBlockState getFacade() {
        return this.facade;
    }

    public boolean isSolid() {
        return this.reconstructTimer == 0;
    }

    public void onBreak() {
        this.reconstructTimer = reconstructMax;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        if (par1nbtTagCompound.func_74764_b("facade")) {
            this.facade = Block.func_176220_d((int)par1nbtTagCompound.func_74762_e("facade"));
        }
        this.poweredFromEverstone = par1nbtTagCompound.func_74767_n("poweredFromEverstone");
        this.poweredFromRedstone = par1nbtTagCompound.func_74767_n("poweredFromRedstone");
        this.reconstructTimer = par1nbtTagCompound.func_74762_e("reconstructTimer");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1nbtTagCompound) {
        super.func_189515_b(par1nbtTagCompound);
        if (this.facade != null) {
            par1nbtTagCompound.func_74768_a("facade", Block.func_176210_f((IBlockState)this.facade));
        }
        par1nbtTagCompound.func_74757_a("poweredFromEverstone", this.poweredFromEverstone);
        par1nbtTagCompound.func_74757_a("poweredFromRedstone", this.poweredFromRedstone);
        par1nbtTagCompound.func_74768_a("reconstructTimer", this.reconstructTimer);
        return par1nbtTagCompound;
    }
}

